/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.Data;

public class EventNotificationRequest
implements AxdrType {
    public byte[] code = null;
    public AxdrOptional<AxdrOctetString> time = new AxdrOptional<AxdrOctetString>(new AxdrOctetString(), false);
    public CosemAttributeDescriptor cosemAttributeDescriptor = null;
    public Data attributeValue = null;

    public EventNotificationRequest() {
    }

    public EventNotificationRequest(byte[] code) {
        this.code = code;
    }

    public EventNotificationRequest(AxdrOctetString time, CosemAttributeDescriptor cosemAttributeDescriptor, Data attributeValue) {
        this.time.setValue(time);
        this.cosemAttributeDescriptor = cosemAttributeDescriptor;
        this.attributeValue = attributeValue;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.attributeValue.encode(axdrOStream);
            codeLength += this.cosemAttributeDescriptor.encode(axdrOStream);
            codeLength += this.time.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.time = new AxdrOptional<AxdrOctetString>(new AxdrOctetString(), false);
        codeLength += this.time.decode(iStream);
        this.cosemAttributeDescriptor = new CosemAttributeDescriptor();
        codeLength += this.cosemAttributeDescriptor.decode(iStream);
        this.attributeValue = new Data();
        return codeLength += this.attributeValue.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {time: " + this.time + ", cosemAttributeDescriptor: " + this.cosemAttributeDescriptor + ", attributeValue: " + this.attributeValue + "}";
    }
}

