/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned32;

public class DataBlockG
implements AxdrType {
    public byte[] code = null;
    public AxdrBoolean lastBlock = null;
    public Unsigned32 blockNumber = null;
    public SubChoiceResult result = null;

    public DataBlockG() {
    }

    public DataBlockG(byte[] code) {
        this.code = code;
    }

    public DataBlockG(AxdrBoolean lastBlock, Unsigned32 blockNumber, SubChoiceResult result) {
        this.lastBlock = lastBlock;
        this.blockNumber = blockNumber;
        this.result = result;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.result.encode(axdrOStream);
            codeLength += this.blockNumber.encode(axdrOStream);
            codeLength += this.lastBlock.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.lastBlock = new AxdrBoolean();
        codeLength += this.lastBlock.decode(iStream);
        this.blockNumber = new Unsigned32();
        codeLength += this.blockNumber.decode(iStream);
        this.result = new SubChoiceResult();
        return codeLength += this.result.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {lastBlock: " + this.lastBlock + ", blockNumber: " + this.blockNumber + ", result: " + this.result + "}";
    }

    public static class SubChoiceResult
    implements AxdrType {
        public byte[] code = null;
        private Choices choice;
        public AxdrOctetString rawData = null;
        public AxdrEnum dataAccessResult = null;

        public SubChoiceResult() {
        }

        public SubChoiceResult(byte[] code) {
            this.code = code;
        }

        @Override
        public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    axdrOStream.write(this.code[i]);
                }
                return this.code.length;
            }
            if (this.choice == Choices._ERR_NONE_SELECTED) {
                throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
            }
            int codeLength = 0;
            if (this.choice == Choices.DATA_ACCESS_RESULT) {
                codeLength += this.dataAccessResult.encode(axdrOStream);
                AxdrEnum c = new AxdrEnum(1L);
                return codeLength += c.encode(axdrOStream);
            }
            if (this.choice == Choices.RAW_DATA) {
                codeLength += this.rawData.encode(axdrOStream);
                AxdrEnum c = new AxdrEnum(0L);
                return codeLength += c.encode(axdrOStream);
            }
            throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
        }

        @Override
        public int decode(InputStream iStream) throws IOException {
            int codeLength = 0;
            AxdrEnum choosen = new AxdrEnum();
            codeLength += choosen.decode(iStream);
            this.resetChoices();
            this.choice = Choices.valueOf(choosen.getValue());
            if (this.choice == Choices.RAW_DATA) {
                this.rawData = new AxdrOctetString();
                return codeLength += this.rawData.decode(iStream);
            }
            if (this.choice == Choices.DATA_ACCESS_RESULT) {
                this.dataAccessResult = new AxdrEnum();
                return codeLength += this.dataAccessResult.decode(iStream);
            }
            throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode(axdrOStream);
            this.code = axdrOStream.getArray();
        }

        public Choices getChoiceIndex() {
            return this.choice;
        }

        public void setRawData(AxdrOctetString newVal) {
            this.resetChoices();
            this.choice = Choices.RAW_DATA;
            this.rawData = newVal;
        }

        public void setDataAccessResult(AxdrEnum newVal) {
            this.resetChoices();
            this.choice = Choices.DATA_ACCESS_RESULT;
            this.dataAccessResult = newVal;
        }

        private void resetChoices() {
            this.choice = Choices._ERR_NONE_SELECTED;
            this.rawData = null;
            this.dataAccessResult = null;
        }

        public String toString() {
            if (this.choice == Choices.RAW_DATA) {
                return "choice: {rawData: " + this.rawData + "}";
            }
            if (this.choice == Choices.DATA_ACCESS_RESULT) {
                return "choice: {dataAccessResult: " + this.dataAccessResult + "}";
            }
            return "unknown";
        }

        public static enum Choices {
            _ERR_NONE_SELECTED(-1),
            RAW_DATA(0),
            DATA_ACCESS_RESULT(1);

            private int value;

            private Choices(int value) {
                this.value = value;
            }

            public int getValue() {
                return this.value;
            }

            public static Choices valueOf(long tagValue) {
                Choices[] values;
                for (Choices c : values = Choices.values()) {
                    if ((long)c.value != tagValue) continue;
                    return c;
                }
                return _ERR_NONE_SELECTED;
            }
        }
    }
}

