/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.cosem.AccessRequest;
import org.openmuc.jdlms.internal.asn1.cosem.AccessResponse;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponse;
import org.openmuc.jdlms.internal.asn1.cosem.ConfirmedServiceError;
import org.openmuc.jdlms.internal.asn1.cosem.DataNotification;
import org.openmuc.jdlms.internal.asn1.cosem.EventNotificationRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ExceptionResponse;
import org.openmuc.jdlms.internal.asn1.cosem.GeneralBlockTransfer;
import org.openmuc.jdlms.internal.asn1.cosem.GeneralCiphering;
import org.openmuc.jdlms.internal.asn1.cosem.GeneralDedCiphering;
import org.openmuc.jdlms.internal.asn1.cosem.GeneralGloCiphering;
import org.openmuc.jdlms.internal.asn1.cosem.GeneralSigning;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequest;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.InformationReportRequest;
import org.openmuc.jdlms.internal.asn1.cosem.InitiateRequest;
import org.openmuc.jdlms.internal.asn1.cosem.InitiateResponse;
import org.openmuc.jdlms.internal.asn1.cosem.ReadRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ReadResponse;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequest;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.UnconfirmedWriteRequest;
import org.openmuc.jdlms.internal.asn1.cosem.WriteRequest;
import org.openmuc.jdlms.internal.asn1.cosem.WriteResponse;

public class COSEMpdu
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public InitiateRequest initiateRequest = null;
    public ReadRequest readRequest = null;
    public WriteRequest writeRequest = null;
    public InitiateResponse initiateResponse = null;
    public ReadResponse readResponse = null;
    public WriteResponse writeResponse = null;
    public ConfirmedServiceError confirmedServiceError = null;
    public DataNotification dataNotification = null;
    public UnconfirmedWriteRequest unconfirmedWriteRequest = null;
    public InformationReportRequest informationReportRequest = null;
    public AxdrOctetString gloInitiateRequest = null;
    public AxdrOctetString gloReadRequest = null;
    public AxdrOctetString gloWriteRequest = null;
    public AxdrOctetString gloInitiateResponse = null;
    public AxdrOctetString gloReadResponse = null;
    public AxdrOctetString gloWriteResponse = null;
    public AxdrOctetString gloConfirmedServiceError = null;
    public AxdrOctetString gloUnconfirmedWriteRequest = null;
    public AxdrOctetString gloInformationReportRequest = null;
    public AxdrOctetString dedInitiateRequest = null;
    public AxdrOctetString dedReadRequest = null;
    public AxdrOctetString dedWriteRequest = null;
    public AxdrOctetString dedInitiateResponse = null;
    public AxdrOctetString dedReadResponse = null;
    public AxdrOctetString dedWriteResponse = null;
    public AxdrOctetString dedConfirmedServiceError = null;
    public AxdrOctetString dedUnconfirmedWriteRequest = null;
    public AxdrOctetString dedInformationReportRequest = null;
    public GetRequest getRequest = null;
    public SetRequest setRequest = null;
    public EventNotificationRequest eventNotificationRequest = null;
    public ActionRequest actionRequest = null;
    public GetResponse getResponse = null;
    public SetResponse setResponse = null;
    public ActionResponse actionResponse = null;
    public AxdrOctetString gloGetRequest = null;
    public AxdrOctetString gloSetRequest = null;
    public AxdrOctetString gloEventNotificationRequest = null;
    public AxdrOctetString gloActionRequest = null;
    public AxdrOctetString gloGetResponse = null;
    public AxdrOctetString gloSetResponse = null;
    public AxdrOctetString gloActionResponse = null;
    public AxdrOctetString dedGetRequest = null;
    public AxdrOctetString dedSetRequest = null;
    public AxdrOctetString dedEventNotificationRequest = null;
    public AxdrOctetString dedActionRequest = null;
    public AxdrOctetString dedGetResponse = null;
    public AxdrOctetString dedSetResponse = null;
    public AxdrOctetString dedActionResponse = null;
    public ExceptionResponse exceptionResponse = null;
    public AccessRequest accessRequest = null;
    public AccessResponse accessResponse = null;
    public GeneralGloCiphering generalGloCiphering = null;
    public GeneralDedCiphering generalDedCiphering = null;
    public GeneralCiphering generalCiphering = null;
    public GeneralSigning generalSigning = null;
    public GeneralBlockTransfer generalBlockTransfer = null;

    public COSEMpdu() {
    }

    public COSEMpdu(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.GENERAL_BLOCK_TRANSFER) {
            codeLength += this.generalBlockTransfer.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(224L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GENERAL_SIGNING) {
            codeLength += this.generalSigning.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(223L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GENERAL_CIPHERING) {
            codeLength += this.generalCiphering.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(221L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GENERAL_DED_CIPHERING) {
            codeLength += this.generalDedCiphering.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(220L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GENERAL_GLO_CIPHERING) {
            codeLength += this.generalGloCiphering.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(219L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_RESPONSE) {
            codeLength += this.accessResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(218L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST) {
            codeLength += this.accessRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(217L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.EXCEPTION_RESPONSE) {
            codeLength += this.exceptionResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(216L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_ACTION_RESPONSE) {
            codeLength += this.dedActionResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(215L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_SET_RESPONSE) {
            codeLength += this.dedSetResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(213L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_GET_RESPONSE) {
            codeLength += this.dedGetResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(212L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_ACTIONREQUEST) {
            codeLength += this.dedActionRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(211L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_EVENT_NOTIFICATION_REQUEST) {
            codeLength += this.dedEventNotificationRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(210L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_SET_REQUEST) {
            codeLength += this.dedSetRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(209L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_GET_REQUEST) {
            codeLength += this.dedGetRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(208L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_ACTION_RESPONSE) {
            codeLength += this.gloActionResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(207L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_SET_RESPONSE) {
            codeLength += this.gloSetResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(205L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_GET_RESPONSE) {
            codeLength += this.gloGetResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(204L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_ACTION_REQUEST) {
            codeLength += this.gloActionRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(203L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_EVENT_NOTIFICATION_REQUEST) {
            codeLength += this.gloEventNotificationRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(202L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_SET_REQUEST) {
            codeLength += this.gloSetRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(201L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_GET_REQUEST) {
            codeLength += this.gloGetRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(200L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE) {
            codeLength += this.actionResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(199L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_RESPONSE) {
            codeLength += this.setResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(197L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GET_RESPONSE) {
            codeLength += this.getResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(196L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_REQUEST) {
            codeLength += this.actionRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(195L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.EVENT_NOTIFICATION_REQUEST) {
            codeLength += this.eventNotificationRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(194L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_REQUEST) {
            codeLength += this.setRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(193L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GET_REQUEST) {
            codeLength += this.getRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(192L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_INFORMATIONREPORTREQUEST) {
            codeLength += this.dedInformationReportRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(88L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_UNCONFIRMEDWRITEREQUEST) {
            codeLength += this.dedUnconfirmedWriteRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(86L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_CONFIRMEDSERVICEERROR) {
            codeLength += this.dedConfirmedServiceError.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(78L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_WRITERESPONSE) {
            codeLength += this.dedWriteResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(77L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_READRESPONSE) {
            codeLength += this.dedReadResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(76L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_INITIATERESPONSE) {
            codeLength += this.dedInitiateResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(72L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_WRITEREQUEST) {
            codeLength += this.dedWriteRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(70L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_READREQUEST) {
            codeLength += this.dedReadRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(69L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DED_INITIATEREQUEST) {
            codeLength += this.dedInitiateRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(65L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_INFORMATIONREPORTREQUEST) {
            codeLength += this.gloInformationReportRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(56L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_UNCONFIRMEDWRITEREQUEST) {
            codeLength += this.gloUnconfirmedWriteRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(54L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_CONFIRMEDSERVICEERROR) {
            codeLength += this.gloConfirmedServiceError.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(46L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_WRITERESPONSE) {
            codeLength += this.gloWriteResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(45L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_READRESPONSE) {
            codeLength += this.gloReadResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(44L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_INITIATERESPONSE) {
            codeLength += this.gloInitiateResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(40L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_WRITEREQUEST) {
            codeLength += this.gloWriteRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(38L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_READREQUEST) {
            codeLength += this.gloReadRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(37L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GLO_INITIATEREQUEST) {
            codeLength += this.gloInitiateRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(33L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INFORMATIONREPORTREQUEST) {
            codeLength += this.informationReportRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(24L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.UNCONFIRMEDWRITEREQUEST) {
            codeLength += this.unconfirmedWriteRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(22L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DATA_NOTIFICATION) {
            codeLength += this.dataNotification.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(15L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.CONFIRMEDSERVICEERROR) {
            codeLength += this.confirmedServiceError.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(14L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.WRITERESPONSE) {
            codeLength += this.writeResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(13L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.READRESPONSE) {
            codeLength += this.readResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(12L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INITIATERESPONSE) {
            codeLength += this.initiateResponse.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(8L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.WRITEREQUEST) {
            codeLength += this.writeRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(6L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.READREQUEST) {
            codeLength += this.readRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INITIATEREQUEST) {
            codeLength += this.initiateRequest.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.INITIATEREQUEST) {
            this.initiateRequest = new InitiateRequest();
            return codeLength += this.initiateRequest.decode(iStream);
        }
        if (this.choice == Choices.READREQUEST) {
            this.readRequest = new ReadRequest();
            return codeLength += this.readRequest.decode(iStream);
        }
        if (this.choice == Choices.WRITEREQUEST) {
            this.writeRequest = new WriteRequest();
            return codeLength += this.writeRequest.decode(iStream);
        }
        if (this.choice == Choices.INITIATERESPONSE) {
            this.initiateResponse = new InitiateResponse();
            return codeLength += this.initiateResponse.decode(iStream);
        }
        if (this.choice == Choices.READRESPONSE) {
            this.readResponse = new ReadResponse();
            return codeLength += this.readResponse.decode(iStream);
        }
        if (this.choice == Choices.WRITERESPONSE) {
            this.writeResponse = new WriteResponse();
            return codeLength += this.writeResponse.decode(iStream);
        }
        if (this.choice == Choices.CONFIRMEDSERVICEERROR) {
            this.confirmedServiceError = new ConfirmedServiceError();
            return codeLength += this.confirmedServiceError.decode(iStream);
        }
        if (this.choice == Choices.DATA_NOTIFICATION) {
            this.dataNotification = new DataNotification();
            return codeLength += this.dataNotification.decode(iStream);
        }
        if (this.choice == Choices.UNCONFIRMEDWRITEREQUEST) {
            this.unconfirmedWriteRequest = new UnconfirmedWriteRequest();
            return codeLength += this.unconfirmedWriteRequest.decode(iStream);
        }
        if (this.choice == Choices.INFORMATIONREPORTREQUEST) {
            this.informationReportRequest = new InformationReportRequest();
            return codeLength += this.informationReportRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_INITIATEREQUEST) {
            this.gloInitiateRequest = new AxdrOctetString();
            return codeLength += this.gloInitiateRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_READREQUEST) {
            this.gloReadRequest = new AxdrOctetString();
            return codeLength += this.gloReadRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_WRITEREQUEST) {
            this.gloWriteRequest = new AxdrOctetString();
            return codeLength += this.gloWriteRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_INITIATERESPONSE) {
            this.gloInitiateResponse = new AxdrOctetString();
            return codeLength += this.gloInitiateResponse.decode(iStream);
        }
        if (this.choice == Choices.GLO_READRESPONSE) {
            this.gloReadResponse = new AxdrOctetString();
            return codeLength += this.gloReadResponse.decode(iStream);
        }
        if (this.choice == Choices.GLO_WRITERESPONSE) {
            this.gloWriteResponse = new AxdrOctetString();
            return codeLength += this.gloWriteResponse.decode(iStream);
        }
        if (this.choice == Choices.GLO_CONFIRMEDSERVICEERROR) {
            this.gloConfirmedServiceError = new AxdrOctetString();
            return codeLength += this.gloConfirmedServiceError.decode(iStream);
        }
        if (this.choice == Choices.GLO_UNCONFIRMEDWRITEREQUEST) {
            this.gloUnconfirmedWriteRequest = new AxdrOctetString();
            return codeLength += this.gloUnconfirmedWriteRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_INFORMATIONREPORTREQUEST) {
            this.gloInformationReportRequest = new AxdrOctetString();
            return codeLength += this.gloInformationReportRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_INITIATEREQUEST) {
            this.dedInitiateRequest = new AxdrOctetString();
            return codeLength += this.dedInitiateRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_READREQUEST) {
            this.dedReadRequest = new AxdrOctetString();
            return codeLength += this.dedReadRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_WRITEREQUEST) {
            this.dedWriteRequest = new AxdrOctetString();
            return codeLength += this.dedWriteRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_INITIATERESPONSE) {
            this.dedInitiateResponse = new AxdrOctetString();
            return codeLength += this.dedInitiateResponse.decode(iStream);
        }
        if (this.choice == Choices.DED_READRESPONSE) {
            this.dedReadResponse = new AxdrOctetString();
            return codeLength += this.dedReadResponse.decode(iStream);
        }
        if (this.choice == Choices.DED_WRITERESPONSE) {
            this.dedWriteResponse = new AxdrOctetString();
            return codeLength += this.dedWriteResponse.decode(iStream);
        }
        if (this.choice == Choices.DED_CONFIRMEDSERVICEERROR) {
            this.dedConfirmedServiceError = new AxdrOctetString();
            return codeLength += this.dedConfirmedServiceError.decode(iStream);
        }
        if (this.choice == Choices.DED_UNCONFIRMEDWRITEREQUEST) {
            this.dedUnconfirmedWriteRequest = new AxdrOctetString();
            return codeLength += this.dedUnconfirmedWriteRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_INFORMATIONREPORTREQUEST) {
            this.dedInformationReportRequest = new AxdrOctetString();
            return codeLength += this.dedInformationReportRequest.decode(iStream);
        }
        if (this.choice == Choices.GET_REQUEST) {
            this.getRequest = new GetRequest();
            return codeLength += this.getRequest.decode(iStream);
        }
        if (this.choice == Choices.SET_REQUEST) {
            this.setRequest = new SetRequest();
            return codeLength += this.setRequest.decode(iStream);
        }
        if (this.choice == Choices.EVENT_NOTIFICATION_REQUEST) {
            this.eventNotificationRequest = new EventNotificationRequest();
            return codeLength += this.eventNotificationRequest.decode(iStream);
        }
        if (this.choice == Choices.ACTION_REQUEST) {
            this.actionRequest = new ActionRequest();
            return codeLength += this.actionRequest.decode(iStream);
        }
        if (this.choice == Choices.GET_RESPONSE) {
            this.getResponse = new GetResponse();
            return codeLength += this.getResponse.decode(iStream);
        }
        if (this.choice == Choices.SET_RESPONSE) {
            this.setResponse = new SetResponse();
            return codeLength += this.setResponse.decode(iStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE) {
            this.actionResponse = new ActionResponse();
            return codeLength += this.actionResponse.decode(iStream);
        }
        if (this.choice == Choices.GLO_GET_REQUEST) {
            this.gloGetRequest = new AxdrOctetString();
            return codeLength += this.gloGetRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_SET_REQUEST) {
            this.gloSetRequest = new AxdrOctetString();
            return codeLength += this.gloSetRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_EVENT_NOTIFICATION_REQUEST) {
            this.gloEventNotificationRequest = new AxdrOctetString();
            return codeLength += this.gloEventNotificationRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_ACTION_REQUEST) {
            this.gloActionRequest = new AxdrOctetString();
            return codeLength += this.gloActionRequest.decode(iStream);
        }
        if (this.choice == Choices.GLO_GET_RESPONSE) {
            this.gloGetResponse = new AxdrOctetString();
            return codeLength += this.gloGetResponse.decode(iStream);
        }
        if (this.choice == Choices.GLO_SET_RESPONSE) {
            this.gloSetResponse = new AxdrOctetString();
            return codeLength += this.gloSetResponse.decode(iStream);
        }
        if (this.choice == Choices.GLO_ACTION_RESPONSE) {
            this.gloActionResponse = new AxdrOctetString();
            return codeLength += this.gloActionResponse.decode(iStream);
        }
        if (this.choice == Choices.DED_GET_REQUEST) {
            this.dedGetRequest = new AxdrOctetString();
            return codeLength += this.dedGetRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_SET_REQUEST) {
            this.dedSetRequest = new AxdrOctetString();
            return codeLength += this.dedSetRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_EVENT_NOTIFICATION_REQUEST) {
            this.dedEventNotificationRequest = new AxdrOctetString();
            return codeLength += this.dedEventNotificationRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_ACTIONREQUEST) {
            this.dedActionRequest = new AxdrOctetString();
            return codeLength += this.dedActionRequest.decode(iStream);
        }
        if (this.choice == Choices.DED_GET_RESPONSE) {
            this.dedGetResponse = new AxdrOctetString();
            return codeLength += this.dedGetResponse.decode(iStream);
        }
        if (this.choice == Choices.DED_SET_RESPONSE) {
            this.dedSetResponse = new AxdrOctetString();
            return codeLength += this.dedSetResponse.decode(iStream);
        }
        if (this.choice == Choices.DED_ACTION_RESPONSE) {
            this.dedActionResponse = new AxdrOctetString();
            return codeLength += this.dedActionResponse.decode(iStream);
        }
        if (this.choice == Choices.EXCEPTION_RESPONSE) {
            this.exceptionResponse = new ExceptionResponse();
            return codeLength += this.exceptionResponse.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST) {
            this.accessRequest = new AccessRequest();
            return codeLength += this.accessRequest.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_RESPONSE) {
            this.accessResponse = new AccessResponse();
            return codeLength += this.accessResponse.decode(iStream);
        }
        if (this.choice == Choices.GENERAL_GLO_CIPHERING) {
            this.generalGloCiphering = new GeneralGloCiphering();
            return codeLength += this.generalGloCiphering.decode(iStream);
        }
        if (this.choice == Choices.GENERAL_DED_CIPHERING) {
            this.generalDedCiphering = new GeneralDedCiphering();
            return codeLength += this.generalDedCiphering.decode(iStream);
        }
        if (this.choice == Choices.GENERAL_CIPHERING) {
            this.generalCiphering = new GeneralCiphering();
            return codeLength += this.generalCiphering.decode(iStream);
        }
        if (this.choice == Choices.GENERAL_SIGNING) {
            this.generalSigning = new GeneralSigning();
            return codeLength += this.generalSigning.decode(iStream);
        }
        if (this.choice == Choices.GENERAL_BLOCK_TRANSFER) {
            this.generalBlockTransfer = new GeneralBlockTransfer();
            return codeLength += this.generalBlockTransfer.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setInitiateRequest(InitiateRequest newVal) {
        this.resetChoices();
        this.choice = Choices.INITIATEREQUEST;
        this.initiateRequest = newVal;
    }

    public void setReadRequest(ReadRequest newVal) {
        this.resetChoices();
        this.choice = Choices.READREQUEST;
        this.readRequest = newVal;
    }

    public void setWriteRequest(WriteRequest newVal) {
        this.resetChoices();
        this.choice = Choices.WRITEREQUEST;
        this.writeRequest = newVal;
    }

    public void setInitiateResponse(InitiateResponse newVal) {
        this.resetChoices();
        this.choice = Choices.INITIATERESPONSE;
        this.initiateResponse = newVal;
    }

    public void setReadResponse(ReadResponse newVal) {
        this.resetChoices();
        this.choice = Choices.READRESPONSE;
        this.readResponse = newVal;
    }

    public void setWriteResponse(WriteResponse newVal) {
        this.resetChoices();
        this.choice = Choices.WRITERESPONSE;
        this.writeResponse = newVal;
    }

    public void setConfirmedServiceError(ConfirmedServiceError newVal) {
        this.resetChoices();
        this.choice = Choices.CONFIRMEDSERVICEERROR;
        this.confirmedServiceError = newVal;
    }

    public void setDataNotification(DataNotification newVal) {
        this.resetChoices();
        this.choice = Choices.DATA_NOTIFICATION;
        this.dataNotification = newVal;
    }

    public void setUnconfirmedWriteRequest(UnconfirmedWriteRequest newVal) {
        this.resetChoices();
        this.choice = Choices.UNCONFIRMEDWRITEREQUEST;
        this.unconfirmedWriteRequest = newVal;
    }

    public void setInformationReportRequest(InformationReportRequest newVal) {
        this.resetChoices();
        this.choice = Choices.INFORMATIONREPORTREQUEST;
        this.informationReportRequest = newVal;
    }

    public void setGloInitiateRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_INITIATEREQUEST;
        this.gloInitiateRequest = newVal;
    }

    public void setGloReadRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_READREQUEST;
        this.gloReadRequest = newVal;
    }

    public void setGloWriteRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_WRITEREQUEST;
        this.gloWriteRequest = newVal;
    }

    public void setGloInitiateResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_INITIATERESPONSE;
        this.gloInitiateResponse = newVal;
    }

    public void setGloReadResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_READRESPONSE;
        this.gloReadResponse = newVal;
    }

    public void setGloWriteResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_WRITERESPONSE;
        this.gloWriteResponse = newVal;
    }

    public void setGloConfirmedServiceError(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_CONFIRMEDSERVICEERROR;
        this.gloConfirmedServiceError = newVal;
    }

    public void setGloUnconfirmedWriteRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_UNCONFIRMEDWRITEREQUEST;
        this.gloUnconfirmedWriteRequest = newVal;
    }

    public void setGloInformationReportRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_INFORMATIONREPORTREQUEST;
        this.gloInformationReportRequest = newVal;
    }

    public void setDedInitiateRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_INITIATEREQUEST;
        this.dedInitiateRequest = newVal;
    }

    public void setDedReadRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_READREQUEST;
        this.dedReadRequest = newVal;
    }

    public void setDedWriteRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_WRITEREQUEST;
        this.dedWriteRequest = newVal;
    }

    public void setDedInitiateResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_INITIATERESPONSE;
        this.dedInitiateResponse = newVal;
    }

    public void setDedReadResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_READRESPONSE;
        this.dedReadResponse = newVal;
    }

    public void setDedWriteResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_WRITERESPONSE;
        this.dedWriteResponse = newVal;
    }

    public void setDedConfirmedServiceError(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_CONFIRMEDSERVICEERROR;
        this.dedConfirmedServiceError = newVal;
    }

    public void setDedUnconfirmedWriteRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_UNCONFIRMEDWRITEREQUEST;
        this.dedUnconfirmedWriteRequest = newVal;
    }

    public void setDedInformationReportRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_INFORMATIONREPORTREQUEST;
        this.dedInformationReportRequest = newVal;
    }

    public void setGetRequest(GetRequest newVal) {
        this.resetChoices();
        this.choice = Choices.GET_REQUEST;
        this.getRequest = newVal;
    }

    public void setSetRequest(SetRequest newVal) {
        this.resetChoices();
        this.choice = Choices.SET_REQUEST;
        this.setRequest = newVal;
    }

    public void setEventNotificationRequest(EventNotificationRequest newVal) {
        this.resetChoices();
        this.choice = Choices.EVENT_NOTIFICATION_REQUEST;
        this.eventNotificationRequest = newVal;
    }

    public void setActionRequest(ActionRequest newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST;
        this.actionRequest = newVal;
    }

    public void setGetResponse(GetResponse newVal) {
        this.resetChoices();
        this.choice = Choices.GET_RESPONSE;
        this.getResponse = newVal;
    }

    public void setSetResponse(SetResponse newVal) {
        this.resetChoices();
        this.choice = Choices.SET_RESPONSE;
        this.setResponse = newVal;
    }

    public void setActionResponse(ActionResponse newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_RESPONSE;
        this.actionResponse = newVal;
    }

    public void setGloGetRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_GET_REQUEST;
        this.gloGetRequest = newVal;
    }

    public void setGloSetRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_SET_REQUEST;
        this.gloSetRequest = newVal;
    }

    public void setGloEventNotificationRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_EVENT_NOTIFICATION_REQUEST;
        this.gloEventNotificationRequest = newVal;
    }

    public void setGloActionRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_ACTION_REQUEST;
        this.gloActionRequest = newVal;
    }

    public void setGloGetResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_GET_RESPONSE;
        this.gloGetResponse = newVal;
    }

    public void setGloSetResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_SET_RESPONSE;
        this.gloSetResponse = newVal;
    }

    public void setGloActionResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.GLO_ACTION_RESPONSE;
        this.gloActionResponse = newVal;
    }

    public void setDedGetRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_GET_REQUEST;
        this.dedGetRequest = newVal;
    }

    public void setDedSetRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_SET_REQUEST;
        this.dedSetRequest = newVal;
    }

    public void setDedEventNotificationRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_EVENT_NOTIFICATION_REQUEST;
        this.dedEventNotificationRequest = newVal;
    }

    public void setDedActionRequest(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_ACTIONREQUEST;
        this.dedActionRequest = newVal;
    }

    public void setDedGetResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_GET_RESPONSE;
        this.dedGetResponse = newVal;
    }

    public void setDedSetResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_SET_RESPONSE;
        this.dedSetResponse = newVal;
    }

    public void setDedActionResponse(AxdrOctetString newVal) {
        this.resetChoices();
        this.choice = Choices.DED_ACTION_RESPONSE;
        this.dedActionResponse = newVal;
    }

    public void setExceptionResponse(ExceptionResponse newVal) {
        this.resetChoices();
        this.choice = Choices.EXCEPTION_RESPONSE;
        this.exceptionResponse = newVal;
    }

    public void setAccessRequest(AccessRequest newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_REQUEST;
        this.accessRequest = newVal;
    }

    public void setAccessResponse(AccessResponse newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_RESPONSE;
        this.accessResponse = newVal;
    }

    public void setGeneralGloCiphering(GeneralGloCiphering newVal) {
        this.resetChoices();
        this.choice = Choices.GENERAL_GLO_CIPHERING;
        this.generalGloCiphering = newVal;
    }

    public void setGeneralDedCiphering(GeneralDedCiphering newVal) {
        this.resetChoices();
        this.choice = Choices.GENERAL_DED_CIPHERING;
        this.generalDedCiphering = newVal;
    }

    public void setGeneralCiphering(GeneralCiphering newVal) {
        this.resetChoices();
        this.choice = Choices.GENERAL_CIPHERING;
        this.generalCiphering = newVal;
    }

    public void setGeneralSigning(GeneralSigning newVal) {
        this.resetChoices();
        this.choice = Choices.GENERAL_SIGNING;
        this.generalSigning = newVal;
    }

    public void setGeneralBlockTransfer(GeneralBlockTransfer newVal) {
        this.resetChoices();
        this.choice = Choices.GENERAL_BLOCK_TRANSFER;
        this.generalBlockTransfer = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.initiateRequest = null;
        this.readRequest = null;
        this.writeRequest = null;
        this.initiateResponse = null;
        this.readResponse = null;
        this.writeResponse = null;
        this.confirmedServiceError = null;
        this.dataNotification = null;
        this.unconfirmedWriteRequest = null;
        this.informationReportRequest = null;
        this.gloInitiateRequest = null;
        this.gloReadRequest = null;
        this.gloWriteRequest = null;
        this.gloInitiateResponse = null;
        this.gloReadResponse = null;
        this.gloWriteResponse = null;
        this.gloConfirmedServiceError = null;
        this.gloUnconfirmedWriteRequest = null;
        this.gloInformationReportRequest = null;
        this.dedInitiateRequest = null;
        this.dedReadRequest = null;
        this.dedWriteRequest = null;
        this.dedInitiateResponse = null;
        this.dedReadResponse = null;
        this.dedWriteResponse = null;
        this.dedConfirmedServiceError = null;
        this.dedUnconfirmedWriteRequest = null;
        this.dedInformationReportRequest = null;
        this.getRequest = null;
        this.setRequest = null;
        this.eventNotificationRequest = null;
        this.actionRequest = null;
        this.getResponse = null;
        this.setResponse = null;
        this.actionResponse = null;
        this.gloGetRequest = null;
        this.gloSetRequest = null;
        this.gloEventNotificationRequest = null;
        this.gloActionRequest = null;
        this.gloGetResponse = null;
        this.gloSetResponse = null;
        this.gloActionResponse = null;
        this.dedGetRequest = null;
        this.dedSetRequest = null;
        this.dedEventNotificationRequest = null;
        this.dedActionRequest = null;
        this.dedGetResponse = null;
        this.dedSetResponse = null;
        this.dedActionResponse = null;
        this.exceptionResponse = null;
        this.accessRequest = null;
        this.accessResponse = null;
        this.generalGloCiphering = null;
        this.generalDedCiphering = null;
        this.generalCiphering = null;
        this.generalSigning = null;
        this.generalBlockTransfer = null;
    }

    public String toString() {
        if (this.choice == Choices.INITIATEREQUEST) {
            return "choice: {initiateRequest: " + this.initiateRequest + "}";
        }
        if (this.choice == Choices.READREQUEST) {
            return "choice: {readRequest: " + this.readRequest + "}";
        }
        if (this.choice == Choices.WRITEREQUEST) {
            return "choice: {writeRequest: " + this.writeRequest + "}";
        }
        if (this.choice == Choices.INITIATERESPONSE) {
            return "choice: {initiateResponse: " + this.initiateResponse + "}";
        }
        if (this.choice == Choices.READRESPONSE) {
            return "choice: {readResponse: " + this.readResponse + "}";
        }
        if (this.choice == Choices.WRITERESPONSE) {
            return "choice: {writeResponse: " + this.writeResponse + "}";
        }
        if (this.choice == Choices.CONFIRMEDSERVICEERROR) {
            return "choice: {confirmedServiceError: " + this.confirmedServiceError + "}";
        }
        if (this.choice == Choices.DATA_NOTIFICATION) {
            return "choice: {dataNotification: " + this.dataNotification + "}";
        }
        if (this.choice == Choices.UNCONFIRMEDWRITEREQUEST) {
            return "choice: {unconfirmedWriteRequest: " + this.unconfirmedWriteRequest + "}";
        }
        if (this.choice == Choices.INFORMATIONREPORTREQUEST) {
            return "choice: {informationReportRequest: " + this.informationReportRequest + "}";
        }
        if (this.choice == Choices.GLO_INITIATEREQUEST) {
            return "choice: {gloInitiateRequest: " + this.gloInitiateRequest + "}";
        }
        if (this.choice == Choices.GLO_READREQUEST) {
            return "choice: {gloReadRequest: " + this.gloReadRequest + "}";
        }
        if (this.choice == Choices.GLO_WRITEREQUEST) {
            return "choice: {gloWriteRequest: " + this.gloWriteRequest + "}";
        }
        if (this.choice == Choices.GLO_INITIATERESPONSE) {
            return "choice: {gloInitiateResponse: " + this.gloInitiateResponse + "}";
        }
        if (this.choice == Choices.GLO_READRESPONSE) {
            return "choice: {gloReadResponse: " + this.gloReadResponse + "}";
        }
        if (this.choice == Choices.GLO_WRITERESPONSE) {
            return "choice: {gloWriteResponse: " + this.gloWriteResponse + "}";
        }
        if (this.choice == Choices.GLO_CONFIRMEDSERVICEERROR) {
            return "choice: {gloConfirmedServiceError: " + this.gloConfirmedServiceError + "}";
        }
        if (this.choice == Choices.GLO_UNCONFIRMEDWRITEREQUEST) {
            return "choice: {gloUnconfirmedWriteRequest: " + this.gloUnconfirmedWriteRequest + "}";
        }
        if (this.choice == Choices.GLO_INFORMATIONREPORTREQUEST) {
            return "choice: {gloInformationReportRequest: " + this.gloInformationReportRequest + "}";
        }
        if (this.choice == Choices.DED_INITIATEREQUEST) {
            return "choice: {dedInitiateRequest: " + this.dedInitiateRequest + "}";
        }
        if (this.choice == Choices.DED_READREQUEST) {
            return "choice: {dedReadRequest: " + this.dedReadRequest + "}";
        }
        if (this.choice == Choices.DED_WRITEREQUEST) {
            return "choice: {dedWriteRequest: " + this.dedWriteRequest + "}";
        }
        if (this.choice == Choices.DED_INITIATERESPONSE) {
            return "choice: {dedInitiateResponse: " + this.dedInitiateResponse + "}";
        }
        if (this.choice == Choices.DED_READRESPONSE) {
            return "choice: {dedReadResponse: " + this.dedReadResponse + "}";
        }
        if (this.choice == Choices.DED_WRITERESPONSE) {
            return "choice: {dedWriteResponse: " + this.dedWriteResponse + "}";
        }
        if (this.choice == Choices.DED_CONFIRMEDSERVICEERROR) {
            return "choice: {dedConfirmedServiceError: " + this.dedConfirmedServiceError + "}";
        }
        if (this.choice == Choices.DED_UNCONFIRMEDWRITEREQUEST) {
            return "choice: {dedUnconfirmedWriteRequest: " + this.dedUnconfirmedWriteRequest + "}";
        }
        if (this.choice == Choices.DED_INFORMATIONREPORTREQUEST) {
            return "choice: {dedInformationReportRequest: " + this.dedInformationReportRequest + "}";
        }
        if (this.choice == Choices.GET_REQUEST) {
            return "choice: {getRequest: " + this.getRequest + "}";
        }
        if (this.choice == Choices.SET_REQUEST) {
            return "choice: {setRequest: " + this.setRequest + "}";
        }
        if (this.choice == Choices.EVENT_NOTIFICATION_REQUEST) {
            return "choice: {eventNotificationRequest: " + this.eventNotificationRequest + "}";
        }
        if (this.choice == Choices.ACTION_REQUEST) {
            return "choice: {actionRequest: " + this.actionRequest + "}";
        }
        if (this.choice == Choices.GET_RESPONSE) {
            return "choice: {getResponse: " + this.getResponse + "}";
        }
        if (this.choice == Choices.SET_RESPONSE) {
            return "choice: {setResponse: " + this.setResponse + "}";
        }
        if (this.choice == Choices.ACTION_RESPONSE) {
            return "choice: {actionResponse: " + this.actionResponse + "}";
        }
        if (this.choice == Choices.GLO_GET_REQUEST) {
            return "choice: {gloGetRequest: " + this.gloGetRequest + "}";
        }
        if (this.choice == Choices.GLO_SET_REQUEST) {
            return "choice: {gloSetRequest: " + this.gloSetRequest + "}";
        }
        if (this.choice == Choices.GLO_EVENT_NOTIFICATION_REQUEST) {
            return "choice: {gloEventNotificationRequest: " + this.gloEventNotificationRequest + "}";
        }
        if (this.choice == Choices.GLO_ACTION_REQUEST) {
            return "choice: {gloActionRequest: " + this.gloActionRequest + "}";
        }
        if (this.choice == Choices.GLO_GET_RESPONSE) {
            return "choice: {gloGetResponse: " + this.gloGetResponse + "}";
        }
        if (this.choice == Choices.GLO_SET_RESPONSE) {
            return "choice: {gloSetResponse: " + this.gloSetResponse + "}";
        }
        if (this.choice == Choices.GLO_ACTION_RESPONSE) {
            return "choice: {gloActionResponse: " + this.gloActionResponse + "}";
        }
        if (this.choice == Choices.DED_GET_REQUEST) {
            return "choice: {dedGetRequest: " + this.dedGetRequest + "}";
        }
        if (this.choice == Choices.DED_SET_REQUEST) {
            return "choice: {dedSetRequest: " + this.dedSetRequest + "}";
        }
        if (this.choice == Choices.DED_EVENT_NOTIFICATION_REQUEST) {
            return "choice: {dedEventNotificationRequest: " + this.dedEventNotificationRequest + "}";
        }
        if (this.choice == Choices.DED_ACTIONREQUEST) {
            return "choice: {dedActionRequest: " + this.dedActionRequest + "}";
        }
        if (this.choice == Choices.DED_GET_RESPONSE) {
            return "choice: {dedGetResponse: " + this.dedGetResponse + "}";
        }
        if (this.choice == Choices.DED_SET_RESPONSE) {
            return "choice: {dedSetResponse: " + this.dedSetResponse + "}";
        }
        if (this.choice == Choices.DED_ACTION_RESPONSE) {
            return "choice: {dedActionResponse: " + this.dedActionResponse + "}";
        }
        if (this.choice == Choices.EXCEPTION_RESPONSE) {
            return "choice: {exceptionResponse: " + this.exceptionResponse + "}";
        }
        if (this.choice == Choices.ACCESS_REQUEST) {
            return "choice: {accessRequest: " + this.accessRequest + "}";
        }
        if (this.choice == Choices.ACCESS_RESPONSE) {
            return "choice: {accessResponse: " + this.accessResponse + "}";
        }
        if (this.choice == Choices.GENERAL_GLO_CIPHERING) {
            return "choice: {generalGloCiphering: " + this.generalGloCiphering + "}";
        }
        if (this.choice == Choices.GENERAL_DED_CIPHERING) {
            return "choice: {generalDedCiphering: " + this.generalDedCiphering + "}";
        }
        if (this.choice == Choices.GENERAL_CIPHERING) {
            return "choice: {generalCiphering: " + this.generalCiphering + "}";
        }
        if (this.choice == Choices.GENERAL_SIGNING) {
            return "choice: {generalSigning: " + this.generalSigning + "}";
        }
        if (this.choice == Choices.GENERAL_BLOCK_TRANSFER) {
            return "choice: {generalBlockTransfer: " + this.generalBlockTransfer + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        INITIATEREQUEST(1),
        READREQUEST(5),
        WRITEREQUEST(6),
        INITIATERESPONSE(8),
        READRESPONSE(12),
        WRITERESPONSE(13),
        CONFIRMEDSERVICEERROR(14),
        DATA_NOTIFICATION(15),
        UNCONFIRMEDWRITEREQUEST(22),
        INFORMATIONREPORTREQUEST(24),
        GLO_INITIATEREQUEST(33),
        GLO_READREQUEST(37),
        GLO_WRITEREQUEST(38),
        GLO_INITIATERESPONSE(40),
        GLO_READRESPONSE(44),
        GLO_WRITERESPONSE(45),
        GLO_CONFIRMEDSERVICEERROR(46),
        GLO_UNCONFIRMEDWRITEREQUEST(54),
        GLO_INFORMATIONREPORTREQUEST(56),
        DED_INITIATEREQUEST(65),
        DED_READREQUEST(69),
        DED_WRITEREQUEST(70),
        DED_INITIATERESPONSE(72),
        DED_READRESPONSE(76),
        DED_WRITERESPONSE(77),
        DED_CONFIRMEDSERVICEERROR(78),
        DED_UNCONFIRMEDWRITEREQUEST(86),
        DED_INFORMATIONREPORTREQUEST(88),
        GET_REQUEST(192),
        SET_REQUEST(193),
        EVENT_NOTIFICATION_REQUEST(194),
        ACTION_REQUEST(195),
        GET_RESPONSE(196),
        SET_RESPONSE(197),
        ACTION_RESPONSE(199),
        GLO_GET_REQUEST(200),
        GLO_SET_REQUEST(201),
        GLO_EVENT_NOTIFICATION_REQUEST(202),
        GLO_ACTION_REQUEST(203),
        GLO_GET_RESPONSE(204),
        GLO_SET_RESPONSE(205),
        GLO_ACTION_RESPONSE(207),
        DED_GET_REQUEST(208),
        DED_SET_REQUEST(209),
        DED_EVENT_NOTIFICATION_REQUEST(210),
        DED_ACTIONREQUEST(211),
        DED_GET_RESPONSE(212),
        DED_SET_RESPONSE(213),
        DED_ACTION_RESPONSE(215),
        EXCEPTION_RESPONSE(216),
        ACCESS_REQUEST(217),
        ACCESS_RESPONSE(218),
        GENERAL_GLO_CIPHERING(219),
        GENERAL_DED_CIPHERING(220),
        GENERAL_CIPHERING(221),
        GENERAL_SIGNING(223),
        GENERAL_BLOCK_TRANSFER(224);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

