/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;

public class AgreedKey
implements AxdrType {
    public byte[] code = null;
    public AxdrOctetString keyParameters = null;
    public AxdrOctetString keyCipheredData = null;

    public AgreedKey() {
    }

    public AgreedKey(byte[] code) {
        this.code = code;
    }

    public AgreedKey(AxdrOctetString keyParameters, AxdrOctetString keyCipheredData) {
        this.keyParameters = keyParameters;
        this.keyCipheredData = keyCipheredData;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.keyCipheredData.encode(axdrOStream);
            codeLength += this.keyParameters.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.keyParameters = new AxdrOctetString();
        codeLength += this.keyParameters.decode(iStream);
        this.keyCipheredData = new AxdrOctetString();
        return codeLength += this.keyCipheredData.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {keyParameters: " + this.keyParameters + ", keyCipheredData: " + this.keyCipheredData + "}";
    }
}

