/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.GetDataResult;

public class ActionResponseWithOptionalData
implements AxdrType {
    public byte[] code = null;
    public AxdrEnum result = null;
    public AxdrOptional<GetDataResult> returnParameters = new AxdrOptional<GetDataResult>(new GetDataResult(), false);

    public ActionResponseWithOptionalData() {
    }

    public ActionResponseWithOptionalData(byte[] code) {
        this.code = code;
    }

    public ActionResponseWithOptionalData(AxdrEnum result, GetDataResult returnParameters) {
        this.result = result;
        this.returnParameters.setValue(returnParameters);
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.returnParameters.encode(axdrOStream);
            codeLength += this.result.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.result = new AxdrEnum();
        codeLength += this.result.decode(iStream);
        this.returnParameters = new AxdrOptional<GetDataResult>(new GetDataResult(), false);
        return codeLength += this.returnParameters.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {result: " + this.result + ", returnParameters: " + this.returnParameters + "}";
    }
}

