/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseNextPblock;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseNormal;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithList;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithPblock;

public class ActionResponse
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public ActionResponseNormal actionResponseNormal = null;
    public ActionResponseWithPblock actionResponseWithPblock = null;
    public ActionResponseWithList actionResponseWithList = null;
    public ActionResponseNextPblock actionResponseNextPblock = null;

    public ActionResponse() {
    }

    public ActionResponse(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.ACTION_RESPONSE_NEXT_PBLOCK) {
            codeLength += this.actionResponseNextPblock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE_WITH_LIST) {
            codeLength += this.actionResponseWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE_WITH_PBLOCK) {
            codeLength += this.actionResponseWithPblock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE_NORMAL) {
            codeLength += this.actionResponseNormal.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.ACTION_RESPONSE_NORMAL) {
            this.actionResponseNormal = new ActionResponseNormal();
            return codeLength += this.actionResponseNormal.decode(iStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE_WITH_PBLOCK) {
            this.actionResponseWithPblock = new ActionResponseWithPblock();
            return codeLength += this.actionResponseWithPblock.decode(iStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE_WITH_LIST) {
            this.actionResponseWithList = new ActionResponseWithList();
            return codeLength += this.actionResponseWithList.decode(iStream);
        }
        if (this.choice == Choices.ACTION_RESPONSE_NEXT_PBLOCK) {
            this.actionResponseNextPblock = new ActionResponseNextPblock();
            return codeLength += this.actionResponseNextPblock.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setActionResponseNormal(ActionResponseNormal newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_RESPONSE_NORMAL;
        this.actionResponseNormal = newVal;
    }

    public void setActionResponseWithPblock(ActionResponseWithPblock newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_RESPONSE_WITH_PBLOCK;
        this.actionResponseWithPblock = newVal;
    }

    public void setActionResponseWithList(ActionResponseWithList newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_RESPONSE_WITH_LIST;
        this.actionResponseWithList = newVal;
    }

    public void setActionResponseNextPblock(ActionResponseNextPblock newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_RESPONSE_NEXT_PBLOCK;
        this.actionResponseNextPblock = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.actionResponseNormal = null;
        this.actionResponseWithPblock = null;
        this.actionResponseWithList = null;
        this.actionResponseNextPblock = null;
    }

    public String toString() {
        if (this.choice == Choices.ACTION_RESPONSE_NORMAL) {
            return "choice: {actionResponseNormal: " + this.actionResponseNormal + "}";
        }
        if (this.choice == Choices.ACTION_RESPONSE_WITH_PBLOCK) {
            return "choice: {actionResponseWithPblock: " + this.actionResponseWithPblock + "}";
        }
        if (this.choice == Choices.ACTION_RESPONSE_WITH_LIST) {
            return "choice: {actionResponseWithList: " + this.actionResponseWithList + "}";
        }
        if (this.choice == Choices.ACTION_RESPONSE_NEXT_PBLOCK) {
            return "choice: {actionResponseNextPblock: " + this.actionResponseNextPblock + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        ACTION_RESPONSE_NORMAL(1),
        ACTION_RESPONSE_WITH_PBLOCK(2),
        ACTION_RESPONSE_WITH_LIST(3),
        ACTION_RESPONSE_NEXT_PBLOCK(4);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

