/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.CosemMethodDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;

public class ActionRequestNormal
implements AxdrType {
    public byte[] code = null;
    public InvokeIdAndPriority invokeIdAndPriority = null;
    public CosemMethodDescriptor cosemMethodDescriptor = null;
    public AxdrOptional<Data> methodInvocationParameters = new AxdrOptional<Data>(new Data(), false);

    public ActionRequestNormal() {
    }

    public ActionRequestNormal(byte[] code) {
        this.code = code;
    }

    public ActionRequestNormal(InvokeIdAndPriority invokeIdAndPriority, CosemMethodDescriptor cosemMethodDescriptor, Data methodInvocationParameters) {
        this.invokeIdAndPriority = invokeIdAndPriority;
        this.cosemMethodDescriptor = cosemMethodDescriptor;
        this.methodInvocationParameters.setValue(methodInvocationParameters);
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.methodInvocationParameters.encode(axdrOStream);
            codeLength += this.cosemMethodDescriptor.encode(axdrOStream);
            codeLength += this.invokeIdAndPriority.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.invokeIdAndPriority = new InvokeIdAndPriority();
        codeLength += this.invokeIdAndPriority.decode(iStream);
        this.cosemMethodDescriptor = new CosemMethodDescriptor();
        codeLength += this.cosemMethodDescriptor.decode(iStream);
        this.methodInvocationParameters = new AxdrOptional<Data>(new Data(), false);
        return codeLength += this.methodInvocationParameters.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {invokeIdAndPriority: " + this.invokeIdAndPriority + ", cosemMethodDescriptor: " + this.cosemMethodDescriptor + ", methodInvocationParameters: " + this.methodInvocationParameters + "}";
    }
}

