/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestNextPblock;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestWithFirstPblock;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestWithListAndFirstPblock;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestWithPblock;

public class ActionRequest
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public ActionRequestNormal actionRequestNormal = null;
    public ActionRequestNextPblock actionRequestNextPblock = null;
    public ActionRequestWithList actionRequestWithList = null;
    public ActionRequestWithFirstPblock actionRequestWithFirstPblock = null;
    public ActionRequestWithListAndFirstPblock actionRequestWithListAndFirstPblock = null;
    public ActionRequestWithPblock actionRequestWithPblock = null;

    public ActionRequest() {
    }

    public ActionRequest(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.ACTION_REQUEST_WITH_PBLOCK) {
            codeLength += this.actionRequestWithPblock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(6L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_LIST_AND_FIRST_PBLOCK) {
            codeLength += this.actionRequestWithListAndFirstPblock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_FIRST_PBLOCK) {
            codeLength += this.actionRequestWithFirstPblock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_LIST) {
            codeLength += this.actionRequestWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_NEXT_PBLOCK) {
            codeLength += this.actionRequestNextPblock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_NORMAL) {
            codeLength += this.actionRequestNormal.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.ACTION_REQUEST_NORMAL) {
            this.actionRequestNormal = new ActionRequestNormal();
            return codeLength += this.actionRequestNormal.decode(iStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_NEXT_PBLOCK) {
            this.actionRequestNextPblock = new ActionRequestNextPblock();
            return codeLength += this.actionRequestNextPblock.decode(iStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_LIST) {
            this.actionRequestWithList = new ActionRequestWithList();
            return codeLength += this.actionRequestWithList.decode(iStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_FIRST_PBLOCK) {
            this.actionRequestWithFirstPblock = new ActionRequestWithFirstPblock();
            return codeLength += this.actionRequestWithFirstPblock.decode(iStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_LIST_AND_FIRST_PBLOCK) {
            this.actionRequestWithListAndFirstPblock = new ActionRequestWithListAndFirstPblock();
            return codeLength += this.actionRequestWithListAndFirstPblock.decode(iStream);
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_PBLOCK) {
            this.actionRequestWithPblock = new ActionRequestWithPblock();
            return codeLength += this.actionRequestWithPblock.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setActionRequestNormal(ActionRequestNormal newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST_NORMAL;
        this.actionRequestNormal = newVal;
    }

    public void setActionRequestNextPblock(ActionRequestNextPblock newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST_NEXT_PBLOCK;
        this.actionRequestNextPblock = newVal;
    }

    public void setActionRequestWithList(ActionRequestWithList newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST_WITH_LIST;
        this.actionRequestWithList = newVal;
    }

    public void setActionRequestWithFirstPblock(ActionRequestWithFirstPblock newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST_WITH_FIRST_PBLOCK;
        this.actionRequestWithFirstPblock = newVal;
    }

    public void setActionRequestWithListAndFirstPblock(ActionRequestWithListAndFirstPblock newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST_WITH_LIST_AND_FIRST_PBLOCK;
        this.actionRequestWithListAndFirstPblock = newVal;
    }

    public void setActionRequestWithPblock(ActionRequestWithPblock newVal) {
        this.resetChoices();
        this.choice = Choices.ACTION_REQUEST_WITH_PBLOCK;
        this.actionRequestWithPblock = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.actionRequestNormal = null;
        this.actionRequestNextPblock = null;
        this.actionRequestWithList = null;
        this.actionRequestWithFirstPblock = null;
        this.actionRequestWithListAndFirstPblock = null;
        this.actionRequestWithPblock = null;
    }

    public String toString() {
        if (this.choice == Choices.ACTION_REQUEST_NORMAL) {
            return "choice: {actionRequestNormal: " + this.actionRequestNormal + "}";
        }
        if (this.choice == Choices.ACTION_REQUEST_NEXT_PBLOCK) {
            return "choice: {actionRequestNextPblock: " + this.actionRequestNextPblock + "}";
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_LIST) {
            return "choice: {actionRequestWithList: " + this.actionRequestWithList + "}";
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_FIRST_PBLOCK) {
            return "choice: {actionRequestWithFirstPblock: " + this.actionRequestWithFirstPblock + "}";
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_LIST_AND_FIRST_PBLOCK) {
            return "choice: {actionRequestWithListAndFirstPblock: " + this.actionRequestWithListAndFirstPblock + "}";
        }
        if (this.choice == Choices.ACTION_REQUEST_WITH_PBLOCK) {
            return "choice: {actionRequestWithPblock: " + this.actionRequestWithPblock + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        ACTION_REQUEST_NORMAL(1),
        ACTION_REQUEST_NEXT_PBLOCK(2),
        ACTION_REQUEST_WITH_LIST(3),
        ACTION_REQUEST_WITH_FIRST_PBLOCK(4),
        ACTION_REQUEST_WITH_LIST_AND_FIRST_PBLOCK(5),
        ACTION_REQUEST_WITH_PBLOCK(6);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

