/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.AccessResponseAction;
import org.openmuc.jdlms.internal.asn1.cosem.AccessResponseGet;
import org.openmuc.jdlms.internal.asn1.cosem.AccessResponseSet;

public class AccessResponseSpecification
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public AccessResponseGet accessResponseGet = null;
    public AccessResponseSet accessResponseSet = null;
    public AccessResponseAction accessResponseAction = null;

    public AccessResponseSpecification() {
    }

    public AccessResponseSpecification(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.ACCESS_RESPONSE_ACTION) {
            codeLength += this.accessResponseAction.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_RESPONSE_SET) {
            codeLength += this.accessResponseSet.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_RESPONSE_GET) {
            codeLength += this.accessResponseGet.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.ACCESS_RESPONSE_GET) {
            this.accessResponseGet = new AccessResponseGet();
            return codeLength += this.accessResponseGet.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_RESPONSE_SET) {
            this.accessResponseSet = new AccessResponseSet();
            return codeLength += this.accessResponseSet.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_RESPONSE_ACTION) {
            this.accessResponseAction = new AccessResponseAction();
            return codeLength += this.accessResponseAction.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setAccessResponseGet(AccessResponseGet newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_RESPONSE_GET;
        this.accessResponseGet = newVal;
    }

    public void setAccessResponseSet(AccessResponseSet newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_RESPONSE_SET;
        this.accessResponseSet = newVal;
    }

    public void setAccessResponseAction(AccessResponseAction newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_RESPONSE_ACTION;
        this.accessResponseAction = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.accessResponseGet = null;
        this.accessResponseSet = null;
        this.accessResponseAction = null;
    }

    public String toString() {
        if (this.choice == Choices.ACCESS_RESPONSE_GET) {
            return "choice: {accessResponseGet: " + this.accessResponseGet + "}";
        }
        if (this.choice == Choices.ACCESS_RESPONSE_SET) {
            return "choice: {accessResponseSet: " + this.accessResponseSet + "}";
        }
        if (this.choice == Choices.ACCESS_RESPONSE_ACTION) {
            return "choice: {accessResponseAction: " + this.accessResponseAction + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        ACCESS_RESPONSE_GET(1),
        ACCESS_RESPONSE_SET(2),
        ACCESS_RESPONSE_ACTION(3);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

