/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.AccessRequestAction;
import org.openmuc.jdlms.internal.asn1.cosem.AccessRequestGet;
import org.openmuc.jdlms.internal.asn1.cosem.AccessRequestGetWithSelection;
import org.openmuc.jdlms.internal.asn1.cosem.AccessRequestSet;
import org.openmuc.jdlms.internal.asn1.cosem.AccessRequestSetWithSelection;

public class AccessRequestSpecification
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public AccessRequestGet accessRequestGet = null;
    public AccessRequestSet accessRequestSet = null;
    public AccessRequestAction accessRequestAction = null;
    public AccessRequestGetWithSelection accessRequestGetWithSelection = null;
    public AccessRequestSetWithSelection accessRequestSetWithSelection = null;

    public AccessRequestSpecification() {
    }

    public AccessRequestSpecification(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.ACCESS_REQUEST_SET_WITH_SELECTION) {
            codeLength += this.accessRequestSetWithSelection.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_GET_WITH_SELECTION) {
            codeLength += this.accessRequestGetWithSelection.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_ACTION) {
            codeLength += this.accessRequestAction.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_SET) {
            codeLength += this.accessRequestSet.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_GET) {
            codeLength += this.accessRequestGet.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.ACCESS_REQUEST_GET) {
            this.accessRequestGet = new AccessRequestGet();
            return codeLength += this.accessRequestGet.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_SET) {
            this.accessRequestSet = new AccessRequestSet();
            return codeLength += this.accessRequestSet.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_ACTION) {
            this.accessRequestAction = new AccessRequestAction();
            return codeLength += this.accessRequestAction.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_GET_WITH_SELECTION) {
            this.accessRequestGetWithSelection = new AccessRequestGetWithSelection();
            return codeLength += this.accessRequestGetWithSelection.decode(iStream);
        }
        if (this.choice == Choices.ACCESS_REQUEST_SET_WITH_SELECTION) {
            this.accessRequestSetWithSelection = new AccessRequestSetWithSelection();
            return codeLength += this.accessRequestSetWithSelection.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setAccessRequestGet(AccessRequestGet newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_REQUEST_GET;
        this.accessRequestGet = newVal;
    }

    public void setAccessRequestSet(AccessRequestSet newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_REQUEST_SET;
        this.accessRequestSet = newVal;
    }

    public void setAccessRequestAction(AccessRequestAction newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_REQUEST_ACTION;
        this.accessRequestAction = newVal;
    }

    public void setAccessRequestGetWithSelection(AccessRequestGetWithSelection newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_REQUEST_GET_WITH_SELECTION;
        this.accessRequestGetWithSelection = newVal;
    }

    public void setAccessRequestSetWithSelection(AccessRequestSetWithSelection newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS_REQUEST_SET_WITH_SELECTION;
        this.accessRequestSetWithSelection = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.accessRequestGet = null;
        this.accessRequestSet = null;
        this.accessRequestAction = null;
        this.accessRequestGetWithSelection = null;
        this.accessRequestSetWithSelection = null;
    }

    public String toString() {
        if (this.choice == Choices.ACCESS_REQUEST_GET) {
            return "choice: {accessRequestGet: " + this.accessRequestGet + "}";
        }
        if (this.choice == Choices.ACCESS_REQUEST_SET) {
            return "choice: {accessRequestSet: " + this.accessRequestSet + "}";
        }
        if (this.choice == Choices.ACCESS_REQUEST_ACTION) {
            return "choice: {accessRequestAction: " + this.accessRequestAction + "}";
        }
        if (this.choice == Choices.ACCESS_REQUEST_GET_WITH_SELECTION) {
            return "choice: {accessRequestGetWithSelection: " + this.accessRequestGetWithSelection + "}";
        }
        if (this.choice == Choices.ACCESS_REQUEST_SET_WITH_SELECTION) {
            return "choice: {accessRequestSetWithSelection: " + this.accessRequestSetWithSelection + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        ACCESS_REQUEST_GET(1),
        ACCESS_REQUEST_SET(2),
        ACCESS_REQUEST_ACTION(3),
        ACCESS_REQUEST_GET_WITH_SELECTION(4),
        ACCESS_REQUEST_SET_WITH_SELECTION(5);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

