/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.cosem.CosemMethodDescriptor;

public class AccessRequestAction
implements AxdrType {
    public byte[] code = null;
    public CosemMethodDescriptor cosemMethodDescriptor = null;

    public AccessRequestAction() {
    }

    public AccessRequestAction(byte[] code) {
        this.code = code;
    }

    public AccessRequestAction(CosemMethodDescriptor cosemMethodDescriptor) {
        this.cosemMethodDescriptor = cosemMethodDescriptor;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.cosemMethodDescriptor.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.cosemMethodDescriptor = new CosemMethodDescriptor();
        return codeLength += this.cosemMethodDescriptor.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {cosemMethodDescriptor: " + this.cosemMethodDescriptor + "}";
    }
}

