/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.Util;

public class AxdrInteger
implements AxdrType {
    private final boolean lengthFixed;
    private final boolean unsigned;
    private long val = 0L;
    private Long maxVal = null;
    private Long minVal = null;
    protected byte[] code = null;

    public AxdrInteger() {
        this.lengthFixed = false;
        this.unsigned = false;
    }

    public AxdrInteger(long val) {
        this();
        this.setValue(val);
    }

    public AxdrInteger(byte[] code) {
        this();
        this.code = code;
    }

    protected AxdrInteger(long min, long max, long val) {
        this.minVal = min;
        this.maxVal = max;
        this.setValue(val);
        this.lengthFixed = true;
        this.unsigned = min >= 0L;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            axdrOStream.write(this.code);
            return this.code.length;
        }
        return this.encodeValue(axdrOStream);
    }

    private int encodeValue(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.lengthFixed) {
            int codeLength = AxdrInteger.numOfBytesOf(this.minVal, this.maxVal);
            this.writyValToStream(axdrOStream, codeLength);
            return codeLength;
        }
        int codeLength = AxdrInteger.numOfBytesOf(this.val);
        this.writyValToStream(axdrOStream, codeLength);
        byte addCodeLengthTag = (byte)(codeLength & 0xFF | 0x80);
        axdrOStream.write(addCodeLengthTag);
        return codeLength + 1;
    }

    private void writyValToStream(ReverseByteArrayOutputStream axdrOStream, int codeLength) throws IOException {
        for (int i = 0; i < codeLength; ++i) {
            int value = (int)(this.val >> 8 * i) & 0xFF;
            axdrOStream.write(value);
        }
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        int length = 0;
        if (this.lengthFixed) {
            codeLength = length = (byte)AxdrInteger.numOfBytesOf(this.minVal, this.maxVal);
        } else {
            length = iStream.read();
            if ((length & 0x80) == 128) {
                length = (byte)(length ^ 0x80);
                codeLength = length + 1;
            } else {
                this.val = length;
                return 1;
            }
        }
        byte[] byteCode = new byte[length];
        Util.readFully(iStream, byteCode);
        if ((byteCode[0] & 0x80) == 128 && !this.unsigned) {
            this.val = -1L;
            for (int i = 0; i < length; ++i) {
                int numShiftBits = 8 * (length - i - 1);
                this.val &= (long)(byteCode[i] << numShiftBits | ~(255 << numShiftBits));
            }
        } else {
            this.val = 0L;
            for (int i = 0; i < length; ++i) {
                this.val |= (long)(byteCode[i] & 0xFF) << 8 * (length - i - 1);
            }
        }
        return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream revOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(revOStream);
        this.code = revOStream.getArray();
    }

    private static int numOfBytesOf(long minVal, long maxVal) {
        return Math.max(AxdrInteger.numOfBytesOf(minVal), AxdrInteger.numOfBytesOf(maxVal));
    }

    private static int numOfBytesOf(long val) {
        long sVal = val;
        if (val < 0L) {
            sVal = -val - 1L;
        }
        return (int)Math.ceil(Math.floor(AxdrInteger.log2(sVal) + 1.0) / 8.0);
    }

    private static double log2(long sVal) {
        return Math.log(sVal) / Math.log(2.0);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AxdrInteger)) {
            return false;
        }
        AxdrInteger other = (AxdrInteger)o;
        return other.val == this.val && other.maxVal.equals(this.maxVal) && other.minVal.equals(this.minVal);
    }

    public int hashCode() {
        if (this.lengthFixed) {
            return this.minVal.hashCode() ^ this.maxVal.hashCode() ^ (int)this.val;
        }
        return (int)this.val;
    }

    public Long getMax() {
        return this.maxVal;
    }

    public Long getMin() {
        return this.minVal;
    }

    public long getValue() {
        return this.val;
    }

    public void setValue(long newVal) {
        if (this.minVal != null && this.minVal > newVal) {
            throw new IllegalArgumentException("Value " + newVal + " is smaller than minimum " + this.minVal);
        }
        if (this.maxVal != null && this.maxVal < newVal) {
            throw new IllegalArgumentException("Value " + newVal + " is greater than maximum " + this.maxVal);
        }
        this.val = newVal;
    }

    public String toString() {
        return Long.toString(this.val);
    }
}

