/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;

public class AxdrDefault<T extends AxdrType> {
    private T value;
    private final T defaultValue;

    public AxdrDefault(T value, T defaultValue) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default cannot be null");
        }
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        boolean usage;
        int codeLength = 0;
        boolean bl = usage = !this.value.equals(this.defaultValue);
        if (usage) {
            codeLength += this.value.encode(axdrOStream);
        }
        return codeLength += new AxdrBoolean(usage).encode(axdrOStream);
    }

    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrBoolean axdrUsage = new AxdrBoolean();
        codeLength += axdrUsage.decode(iStream);
        if (axdrUsage.getValue()) {
            codeLength += this.value.decode(iStream);
        } else {
            this.setValueToDefault();
        }
        return codeLength;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        if (value == null) {
            try {
                this.setValueToDefault();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.value = value;
        }
    }

    private void setValueToDefault() throws IOException {
        ReverseByteArrayOutputStream buffer = new ReverseByteArrayOutputStream(32, true);
        this.defaultValue.encode(buffer);
        this.value.decode(new ByteArrayInputStream(buffer.getArray()));
    }

    public String toString() {
        if (this.value.equals(this.defaultValue)) {
            return this.value.toString() + "(default)";
        }
        return this.value.toString();
    }
}

