/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.axdr.types;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;

public class AxdrBoolean
implements AxdrType {
    private boolean val;
    private byte[] code;

    public AxdrBoolean() {
    }

    public AxdrBoolean(boolean val) {
        this.val = val;
    }

    public AxdrBoolean(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            axdrOStream.write(this.code);
        } else if (this.val) {
            axdrOStream.write((byte)1);
        } else {
            axdrOStream.write((byte)0);
        }
        return 1;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        if (iStream.available() == 0) {
            return 0;
        }
        this.val = iStream.read() != 0;
        return 1;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream revOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(revOStream);
        this.code = revOStream.getArray();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AxdrBoolean)) {
            return false;
        }
        AxdrBoolean other = (AxdrBoolean)o;
        return other.val == this.val;
    }

    public int hashCode() {
        return Boolean.valueOf(this.val).hashCode();
    }

    public boolean getValue() {
        return this.val;
    }

    public String toString() {
        return Boolean.toString(this.val);
    }
}

