/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import org.openmuc.jdlms.internal.asn1.cosem.ActionResponse;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponse;

public class PduHelper {
    public static final int INVALID_INVOKE_ID = -1;

    private static int invokeIdFrom(GetResponse pdu) {
        switch (pdu.getChoiceIndex()) {
            case GET_RESPONSE_NORMAL: {
                return PduHelper.invokeIdFrom(pdu.getResponseNormal.invokeIdAndPriority);
            }
            case GET_RESPONSE_WITH_DATABLOCK: {
                return PduHelper.invokeIdFrom(pdu.getResponseWithDatablock.invokeIdAndPriority);
            }
            case GET_RESPONSE_WITH_LIST: {
                return PduHelper.invokeIdFrom(pdu.getResponseWithList.invokeIdAndPriority);
            }
        }
        return -1;
    }

    private static int invokeIdFrom(SetResponse pdu) {
        switch (pdu.getChoiceIndex()) {
            case SET_RESPONSE_NORMAL: {
                return PduHelper.invokeIdFrom(pdu.setResponseNormal.invokeIdAndPriority);
            }
            case SET_RESPONSE_WITH_LIST: {
                return PduHelper.invokeIdFrom(pdu.setResponseWithList.invokeIdAndPriority);
            }
            case SET_RESPONSE_DATABLOCK: {
                return PduHelper.invokeIdFrom(pdu.setResponseDatablock.invokeIdAndPriority);
            }
            case SET_RESPONSE_LAST_DATABLOCK: {
                return PduHelper.invokeIdFrom(pdu.setResponseLastDatablock.invokeIdAndPriority);
            }
            case SET_RESPONSE_LAST_DATABLOCK_WITH_LIST: {
                return PduHelper.invokeIdFrom(pdu.setResponseLastDatablockWithList.invokeIdAndPriority);
            }
        }
        return -1;
    }

    private static int invokeIdFrom(ActionResponse pdu) {
        switch (pdu.getChoiceIndex()) {
            case ACTION_RESPONSE_NORMAL: {
                return PduHelper.invokeIdFrom(pdu.actionResponseNormal.invokeIdAndPriority);
            }
            case ACTION_RESPONSE_WITH_LIST: {
                return PduHelper.invokeIdFrom(pdu.actionResponseWithList.invokeIdAndPriority);
            }
            case ACTION_RESPONSE_NEXT_PBLOCK: {
                return PduHelper.invokeIdFrom(pdu.actionResponseNextPblock.invokeIdAndPriority);
            }
            case ACTION_RESPONSE_WITH_PBLOCK: {
                return PduHelper.invokeIdFrom(pdu.actionResponseWithPblock.invokeIdAndPriority);
            }
        }
        return -1;
    }

    public static int invokeIdFrom(COSEMpdu cosemPdu) {
        switch (cosemPdu.getChoiceIndex()) {
            case ACTION_RESPONSE: {
                return PduHelper.invokeIdFrom(cosemPdu.actionResponse);
            }
            case GET_RESPONSE: {
                return PduHelper.invokeIdFrom(cosemPdu.getResponse);
            }
            case SET_RESPONSE: {
                return PduHelper.invokeIdFrom(cosemPdu.setResponse);
            }
        }
        return -1;
    }

    public static int invokeIdFrom(InvokeIdAndPriority invokeIdAndPriority) {
        return invokeIdAndPriority.getValue()[0] & 0xF;
    }

    private PduHelper() {
    }
}

