/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import com.beanit.asn1bean.ber.types.BerObjectIdentifier;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.internal.ContextId;
import org.openmuc.jdlms.internal.asn1.iso.acse.ApplicationContextName;
import org.openmuc.jdlms.internal.asn1.iso.acse.MechanismName;

public class ObjectIdentifier {
    private static final int JOINT_ISO_CCITT = 2;
    private static final int COUNTRY = 16;
    private static final int COUNTRY_NAME = 756;
    private static final int IDENTIFIED_ORGANIZATION = 5;
    private static final int DLMS_UA = 8;
    private static final int INDEX_OF_ID = 6;

    public static MechanismName mechanismNameFrom(AuthenticationMechanism mechanismId) {
        return new MechanismName(ObjectIdentifier.identifierFrom(ObjectIdentifierId.MECHANISM_NAME, mechanismId.getId()));
    }

    public static ApplicationContextName applicationContextNameFrom(ContextId contextId) {
        return new ApplicationContextName(ObjectIdentifier.identifierFrom(ObjectIdentifierId.CONTEXT, contextId.getCode()));
    }

    public static ContextId applicationContextIdFrom(BerObjectIdentifier applicationContext) {
        return ContextId.contextIdFor(applicationContext.value[6]);
    }

    private static int[] identifierFrom(ObjectIdentifierId objectIdentifierId, int id) {
        return new int[]{2, 16, 756, 5, 8, objectIdentifierId.getId(), id};
    }

    public static AuthenticationMechanism mechanismIdFrom(MechanismName mechanismName) {
        return AuthenticationMechanism.forId(mechanismName.value[6]);
    }

    private ObjectIdentifier() {
    }

    private static enum ObjectIdentifierId {
        CONTEXT(1),
        MECHANISM_NAME(2);

        private int id;

        private ObjectIdentifierId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

