/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.CosemResourceDescriptor;
import org.openmuc.jdlms.DlmsAccessException;
import org.openmuc.jdlms.DlmsInterceptor;
import org.openmuc.jdlms.DlmsInvocationContext;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.MethodParameter;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.AbstarctInvocationCtx;
import org.openmuc.jdlms.internal.Accessor;
import org.openmuc.jdlms.internal.DataDirectoryImpl;

public class MethodAccessor
implements Accessor {
    private final Method method;
    private final CosemMethod cosemMethod;
    private final DataObject.Type parameterType;
    private final DataObject.Type returnType;
    private final int numOfParams;

    public MethodAccessor(Method method, CosemMethod cosemMethod, DataObject.Type parameterType, DataObject.Type returnType) {
        this.method = method;
        this.cosemMethod = cosemMethod;
        this.parameterType = parameterType;
        this.returnType = returnType;
        this.numOfParams = this.method.getParameterTypes().length;
    }

    public CosemMethod getCosemMethod() {
        return this.cosemMethod;
    }

    @Override
    public Accessor.AccessorType getAccessorType() {
        return Accessor.AccessorType.METHOD;
    }

    public DataObject invoke(DataDirectoryImpl.CosemClassInstance dlmsClassInstance, DataObject argument, Long connectionId, SecuritySuite.SecurityPolicy securityPolicy) throws IllegalMethodAccessException {
        Object[] parameters = this.buildMethodArguments(argument, connectionId);
        CosemInterfaceObject instance = dlmsClassInstance.getInstance();
        DlmsInterceptor interceptor = instance.getInterceptor();
        DataObject result = interceptor != null ? this.invokeInterceptor(dlmsClassInstance, securityPolicy, parameters, instance, interceptor) : this.saveInvoke(instance, parameters);
        if (result == null && this.returnType != null) {
            result = DataObject.newNullData();
        }
        return result;
    }

    private DataObject invokeInterceptor(final DataDirectoryImpl.CosemClassInstance dlmsClassInstance, SecuritySuite.SecurityPolicy securityPolicy, Object[] parameters, CosemInterfaceObject instance, DlmsInterceptor interceptor) throws IllegalMethodAccessException {
        try {
            MethodInvocationCtx ctx = new MethodInvocationCtx(parameters, instance, securityPolicy){

                @Override
                public CosemResourceDescriptor getCosemResourceDescriptor() {
                    return new MethodParameter(dlmsClassInstance.getCosemClass().id(), this.getTarget().getInstanceId(), (int)MethodAccessor.this.cosemMethod.id());
                }

                @Override
                public DataObject proceed() throws DlmsAccessException {
                    return MethodAccessor.this.saveInvoke(this.getTarget(), this.getParameters());
                }
            };
            return interceptor.intercept(ctx);
        }
        catch (IllegalMethodAccessException e) {
            throw e;
        }
        catch (DlmsAccessException e) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
    }

    private DataObject saveInvoke(CosemInterfaceObject instance, Object[] methodArguments) throws IllegalMethodAccessException {
        try {
            return (DataObject)this.method.invoke((Object)instance, methodArguments);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof IllegalMethodAccessException)) {
                throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
            }
            throw (IllegalMethodAccessException)e.getTargetException();
        }
    }

    private Object[] buildMethodArguments(DataObject argument, Long connectionId) throws IllegalMethodAccessException {
        Object[] methodArguments = new Object[this.numOfParams];
        if ((argument == null || argument.isNull()) && this.parameterType == null) {
            if (this.numOfParams == 1) {
                methodArguments[0] = connectionId;
            }
        } else if (argument != null && (argument.getType() == this.parameterType || this.parameterType == DataObject.Type.DONT_CARE)) {
            methodArguments[0] = argument;
            if (this.numOfParams == 2) {
                methodArguments[1] = connectionId;
            }
        } else {
            throw new IllegalMethodAccessException(MethodResultCode.TYPE_UNMATCHED);
        }
        return methodArguments;
    }

    private abstract class MethodInvocationCtx
    extends AbstarctInvocationCtx {
        public MethodInvocationCtx(Object[] parameters, CosemInterfaceObject target, SecuritySuite.SecurityPolicy securityPolicy) {
            super(target, parameters, securityPolicy, MethodAccessor.this.parameterType);
        }

        @Override
        public Member getMember() {
            return MethodAccessor.this.method;
        }

        @Override
        public DlmsInvocationContext.XDlmsServiceType getXDlmsServiceType() {
            return DlmsInvocationContext.XDlmsServiceType.ACTION;
        }
    }
}

