/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal;

import java.text.MessageFormat;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.DlmsInvocationContext;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.datatypes.DataObject;

abstract class AbstarctInvocationCtx
implements DlmsInvocationContext {
    private final CosemInterfaceObject target;
    private Object[] parameters;
    private final SecuritySuite.SecurityPolicy securityPolicy;
    private final int numOfParams;
    private final DataObject.Type parameterType;

    public AbstarctInvocationCtx(CosemInterfaceObject target, Object[] parameters, SecuritySuite.SecurityPolicy securityPolicy, DataObject.Type parameterType) {
        this.target = target;
        this.parameters = parameters;
        this.parameterType = parameterType;
        this.numOfParams = parameters.length;
        this.securityPolicy = securityPolicy;
    }

    @Override
    public final SecuritySuite.SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    @Override
    public final CosemInterfaceObject getTarget() {
        return this.target;
    }

    @Override
    public final Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public final void setParameters(Object[] params) {
        if (this.parameters == null) {
            throw new IllegalArgumentException("The Method does not take any arguments.");
        }
        if (this.numOfParams != params.length) {
            throw new IllegalArgumentException("The num of parameters does not match the method.");
        }
        for (int i = 0; i < params.length; ++i) {
            if (!this.parameters[i].getClass().isAssignableFrom(params[i].getClass())) {
                throw new IllegalArgumentException(MessageFormat.format("Parameter a index {0} is not assignable to the parameter type.", i));
            }
            if (!this.pramIsDObutTypesAreNotEqual(params[i])) continue;
            throw new IllegalArgumentException("Supplied DataObject does not match the required type.");
        }
        this.parameters = params;
    }

    private boolean pramIsDObutTypesAreNotEqual(Object param) {
        return this.parameterType != null && this.parameterType != DataObject.Type.DONT_CARE && param instanceof DataObject && ((DataObject)param).getType() != this.parameterType;
    }
}

