/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.datatypes;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.openmuc.jdlms.HexConverter;
import org.openmuc.jdlms.datatypes.BitString;
import org.openmuc.jdlms.datatypes.CompactArray;
import org.openmuc.jdlms.datatypes.CosemDate;
import org.openmuc.jdlms.datatypes.CosemDateFormat;
import org.openmuc.jdlms.datatypes.CosemDateTime;
import org.openmuc.jdlms.datatypes.CosemTime;

public class DataObject {
    private final Object value;
    private final Type type;

    private DataObject(Object value, Type type) {
        this.value = value;
        this.type = type;
    }

    public static DataObject newNullData() {
        return new DataObject(null, Type.NULL_DATA);
    }

    public static DataObject newArrayData(List<DataObject> array) {
        ListIterator<DataObject> iter = array.listIterator();
        if (!iter.hasNext()) {
            return new DataObject(array, Type.ARRAY);
        }
        Type arrayType = iter.next().getType();
        while (iter.hasNext()) {
            Type t = iter.next().getType();
            if (t == arrayType) continue;
            int index = iter.nextIndex() - 1;
            String msg = MessageFormat.format("Array is of type {0}, but array at {1} is of type {2}.", new Object[]{arrayType, index, t});
            throw new IllegalArgumentException(msg);
        }
        return new DataObject(array, Type.ARRAY);
    }

    public static DataObject newCompactArrayData(CompactArray compactArray) {
        return new DataObject(compactArray, Type.COMPACT_ARRAY);
    }

    public static DataObject newStructureData(List<DataObject> structure) {
        return new DataObject(structure, Type.STRUCTURE);
    }

    public static DataObject newStructureData(DataObject ... element) {
        return DataObject.newStructureData(Arrays.asList(element));
    }

    public static DataObject newBoolData(boolean bool) {
        return new DataObject(bool, Type.BOOLEAN);
    }

    public static DataObject newBitStringData(BitString bitString) throws IllegalArgumentException {
        return new DataObject(new BitString(bitString), Type.BIT_STRING);
    }

    public static DataObject newInteger32Data(int int32) {
        return new DataObject(int32, Type.DOUBLE_LONG);
    }

    public static DataObject newUInteger32Data(long uIn32) {
        if (uIn32 < 0L || uIn32 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(MessageFormat.format("Unsigned32 {0} out of range", uIn32));
        }
        return new DataObject(uIn32, Type.DOUBLE_LONG_UNSIGNED);
    }

    public static DataObject newOctetStringData(byte[] string) {
        return new DataObject(string.clone(), Type.OCTET_STRING);
    }

    public static DataObject newVisibleStringData(byte[] string) {
        return new DataObject(string.clone(), Type.VISIBLE_STRING);
    }

    public static DataObject newUtf8StringData(byte[] string) {
        return new DataObject(string.clone(), Type.UTF8_STRING);
    }

    public static DataObject newBcdData(byte bcd) throws IllegalArgumentException {
        return new DataObject(bcd, Type.BCD);
    }

    public static DataObject newInteger8Data(byte int8) throws IllegalArgumentException {
        return new DataObject(int8, Type.INTEGER);
    }

    public static DataObject newUInteger8Data(short uInt8) throws IllegalArgumentException {
        if (uInt8 < 0 || uInt8 > 255) {
            throw new IllegalArgumentException("Unsigned8 " + uInt8 + " out of range");
        }
        return new DataObject(uInt8, Type.UNSIGNED);
    }

    public static DataObject newInteger16Data(short int16) {
        return new DataObject(int16, Type.LONG_INTEGER);
    }

    public static DataObject newUInteger16Data(int uInt16) {
        if (uInt16 < 0 || uInt16 > 65535) {
            throw new IllegalArgumentException("Unsigned16 " + uInt16 + " out of range");
        }
        return new DataObject(uInt16, Type.LONG_UNSIGNED);
    }

    public static DataObject newInteger64Data(long int64) {
        return new DataObject(int64, Type.LONG64);
    }

    public static DataObject newUInteger64Data(long uInt64) {
        if (uInt64 < 0L) {
            throw new IllegalArgumentException("Unsigned64 " + uInt64 + " out of range");
        }
        return new DataObject(uInt64, Type.LONG64_UNSIGNED);
    }

    public static DataObject newEnumerateData(int enumVal) {
        if (enumVal < 0 || enumVal > 255) {
            throw new IllegalArgumentException("Enumeration " + enumVal + " out of range");
        }
        return new DataObject(enumVal, Type.ENUMERATE);
    }

    public static DataObject newFloat32Data(float float32) {
        return new DataObject(Float.valueOf(float32), Type.FLOAT32);
    }

    public static DataObject newFloat64Data(double float64) {
        return new DataObject(float64, Type.FLOAT64);
    }

    public static DataObject newDateTimeData(CosemDateTime dateTime) {
        return new DataObject(dateTime, Type.DATE_TIME);
    }

    public static DataObject newDateData(CosemDate date) {
        return new DataObject(date, Type.DATE);
    }

    public static DataObject newTimeData(CosemTime time) {
        return new DataObject(time, Type.TIME);
    }

    public Type getType() {
        return this.type;
    }

    public <T> T getValue() throws ClassCastException {
        return (T)this.value;
    }

    public Object getRawValue() {
        return this.value;
    }

    public boolean isBitString() {
        return this.type == Type.BIT_STRING;
    }

    public boolean isNumber() {
        return this.type.isNumber();
    }

    public boolean isComplex() {
        return this.type == Type.ARRAY || this.type == Type.STRUCTURE || this.type == Type.COMPACT_ARRAY;
    }

    public boolean isByteArray() {
        return this.type == Type.OCTET_STRING || this.type == Type.VISIBLE_STRING || this.type == Type.UTF8_STRING;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isCosemDateFormat() {
        return this.type == Type.DATE || this.type == Type.DATE_TIME || this.type == Type.TIME;
    }

    public boolean isNull() {
        return this.type == Type.NULL_DATA;
    }

    public String toString() {
        return this.printType(this, 0);
    }

    private String printType(DataObject resultData, int shiftChars) {
        String shift;
        StringBuilder strBuilder = new StringBuilder();
        if (shiftChars > 0) {
            String formatStr = MessageFormat.format("%{0}s%s", shiftChars);
            shift = String.format(formatStr, " ", "|- ");
        } else {
            shift = "";
        }
        String message = String.format("%s Value: ", resultData.getType().name());
        strBuilder.append(shift).append(message);
        if (resultData.isBoolean()) {
            Boolean boolVal = (Boolean)resultData.getValue();
            strBuilder.append(boolVal.toString());
        } else if (resultData.isNumber()) {
            Number number = (Number)resultData.getValue();
            strBuilder.append(number.toString());
        } else if (resultData.getType() == Type.OCTET_STRING) {
            byte[] octetStr = (byte[])resultData.getValue();
            StringBuilder strBuf = new StringBuilder();
            for (byte b : octetStr) {
                strBuf.append(String.format("%02X ", b));
            }
            strBuilder.append(strBuf.toString()).append(" (hex)");
        } else if (resultData.getType() == Type.VISIBLE_STRING) {
            byte[] visStr = (byte[])resultData.getValue();
            strBuilder.append(new String(visStr));
        } else if (resultData.isBitString()) {
            BitString biStr = (BitString)resultData.getValue();
            strBuilder.append(HexConverter.toShortHexString(biStr.getBitString()));
        } else if (resultData.isCosemDateFormat()) {
            CosemDateFormat cosemFormat = (CosemDateFormat)resultData.getValue();
            strBuilder.append(cosemFormat.toString());
        } else if (resultData.isComplex() && resultData.getType() != Type.COMPACT_ARRAY) {
            List complex = (List)resultData.getValue();
            strBuilder.append(complex.size()).append(" element(s).");
            for (DataObject data : complex) {
                strBuilder.append('\n').append(this.printType(data, shiftChars + 3));
            }
            strBuilder.append('\n');
        } else {
            return String.format("%sNo string representation for type %s", shift, resultData.getType().name());
        }
        return strBuilder.toString();
    }

    public static enum Type {
        NULL_DATA,
        ARRAY,
        STRUCTURE,
        BOOLEAN,
        BIT_STRING,
        DOUBLE_LONG(true),
        DOUBLE_LONG_UNSIGNED(true),
        OCTET_STRING,
        UTF8_STRING,
        VISIBLE_STRING,
        BCD(true),
        INTEGER(true),
        LONG_INTEGER(true),
        UNSIGNED(true),
        LONG_UNSIGNED(true),
        COMPACT_ARRAY,
        LONG64(true),
        LONG64_UNSIGNED(true),
        ENUMERATE(true),
        FLOAT32(true),
        FLOAT64(true),
        DATE_TIME,
        DATE,
        TIME,
        DONT_CARE;

        private boolean isNumber;

        private Type() {
            this(false);
        }

        private Type(boolean isNumber) {
            this.isNumber = isNumber;
        }

        private boolean isNumber() {
            return this.isNumber;
        }
    }
}

