/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import org.openmuc.jdlms.datatypes.CosemDateFormat;

public class CosemTime
implements CosemDateFormat {
    static final int LENGTH = 4;
    private byte[] octetString;

    public CosemTime(int hour, int minute, int second) {
        this(hour, minute, second, 255);
    }

    public CosemTime(int hour, int minute, int second, int hundredths) throws IllegalArgumentException {
        this.verify(hour, "Hour", 0, 23);
        this.verify(minute, "Minute", 0, 59);
        this.verify(second, "Second", 0, 59);
        this.verify(hundredths, "Hundredths", 0, 99);
        this.init(hour, minute, second, hundredths);
    }

    private void init(int hour, int minute, int second, int hundredths) {
        this.octetString = new byte[this.length()];
        this.octetString[0] = (byte)(hour & 0xFF);
        this.octetString[1] = (byte)(minute & 0xFF);
        this.octetString[2] = (byte)(second & 0xFF);
        this.octetString[3] = (byte)(hundredths & 0xFF);
    }

    private CosemTime(byte[] octetString) {
        this.octetString = octetString;
    }

    public static CosemTime decode(InputStream inputStream) throws IOException {
        byte[] octetString = new byte[4];
        if (inputStream.read(octetString) != 4) {
            throw new IOException("Stream has a invalid length.");
        }
        return CosemTime.decode(octetString);
    }

    public static CosemTime decode(byte[] octetString) {
        return new CosemTime(octetString);
    }

    private void verify(int value, String name, int lowerBound, int upperBound) {
        if (value < lowerBound || value > upperBound && value != 255) {
            throw new IllegalArgumentException(String.format("%s is out of range [%d, %d]", name, lowerBound, upperBound));
        }
    }

    @Override
    public byte[] encode() {
        return Arrays.copyOf(this.octetString, this.length());
    }

    void initCalendar(Calendar calendar) {
        int hundredths;
        int second;
        int minute;
        int hour = this.get(CosemDateFormat.Field.HOUR);
        if (hour != 255) {
            calendar.set(11, this.get(CosemDateFormat.Field.HOUR));
        }
        if ((minute = this.get(CosemDateFormat.Field.MINUTE)) != 255) {
            calendar.set(12, this.get(CosemDateFormat.Field.MINUTE));
        }
        if ((second = this.get(CosemDateFormat.Field.SECOND)) != 255) {
            calendar.set(13, this.get(CosemDateFormat.Field.SECOND));
        }
        if ((hundredths = this.get(CosemDateFormat.Field.HUNDREDTHS)) != 255) {
            calendar.set(14, hundredths * 10);
        }
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public int get(CosemDateFormat.Field field) {
        switch (field) {
            case HOUR: {
                return this.octetString[0] & 0xFF;
            }
            case MINUTE: {
                return this.octetString[1] & 0xFF;
            }
            case SECOND: {
                return this.octetString[2] & 0xFF;
            }
            case HUNDREDTHS: {
                return this.octetString[3] & 0xFF;
            }
        }
        throw new IllegalArgumentException(String.format("Field %s found in %s.", field.name(), this.getClass().getSimpleName()));
    }
}

