/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.datatypes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openmuc.jdlms.datatypes.CosemDate;
import org.openmuc.jdlms.datatypes.CosemDateFormat;
import org.openmuc.jdlms.datatypes.CosemTime;

public class CosemDateTime
implements CosemDateFormat {
    private static final int DEVIATION_NOT_SPECIFIED = 32768;
    private static final int LENGTH = 12;
    private byte[] subOctetString;
    private final CosemDate date;
    private final CosemTime time;

    public CosemDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second, int deviation, ClockStatus ... clockStatus) {
        this(year, month, dayOfMonth, 255, hour, minute, second, 255, deviation, clockStatus);
    }

    public CosemDateTime(int year, int month, int dayOfMonth, int dayOfWeek, int hour, int minute, int second, int hundredths, int deviation, ClockStatus ... clockStatus) {
        this.date = new CosemDate(year, month, dayOfMonth, dayOfWeek);
        this.time = new CosemTime(hour, minute, second, hundredths);
        this.initFields(deviation, clockStatus);
    }

    public CosemDateTime(CosemDate date, CosemTime time, int deviation, ClockStatus ... clockStatus) {
        this.date = date;
        this.time = time;
        this.initFields(deviation, clockStatus);
    }

    public CosemDateTime(CosemDate date, CosemTime time, int deviation, TimeUnit deviationTimeUnit, ClockStatus ... clockStatus) {
        this.date = date;
        this.time = time;
        this.initFields((int)TimeUnit.MINUTES.convert(deviation, deviationTimeUnit), clockStatus);
    }

    public CosemDateTime(CosemDate date, CosemTime time, ClockStatus ... clockStatus) {
        this.date = date;
        this.time = time;
        this.initFields(32768, clockStatus);
    }

    private CosemDateTime(CosemDate date, CosemTime time, byte[] subOctetString) {
        this.date = date;
        this.time = time;
        this.subOctetString = subOctetString;
    }

    public static CosemDateTime decode(byte[] octetString) {
        CosemDateTime cosemDateTime;
        if (octetString.length != 12) {
            throw new IllegalArgumentException("Arrays has an invalid length.");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(octetString);
        try {
            cosemDateTime = CosemDateTime.decode(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        inputStream.close();
        return cosemDateTime;
    }

    private static CosemDateTime decode(InputStream inputStream) throws IOException {
        CosemDate date = CosemDate.decode(inputStream);
        CosemTime time = CosemTime.decode(inputStream);
        byte[] subOctetString = new byte[3];
        if (inputStream.read(subOctetString) != 3) {
            throw new IOException("Stream has an invalid length.");
        }
        return new CosemDateTime(date, time, subOctetString);
    }

    private void initFields(int deviation, ClockStatus ... clockStatus) {
        this.validateDeviation(deviation);
        this.subOctetString = new byte[3];
        this.subOctetString[0] = (byte)((deviation & 0xFF00) >> 8);
        this.subOctetString[1] = (byte)(deviation & 0xFF);
        this.subOctetString[2] = ClockStatus.clockStatusToBitString(clockStatus);
    }

    private void validateDeviation(int deviation) {
        if ((deviation < -720 || deviation > 720) && deviation != 32768) {
            throw new IllegalArgumentException("Deviation is out of range.");
        }
    }

    @Override
    public byte[] encode() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.length());
        byte[] dateOctetString = this.date.encode();
        byteBuffer.put(dateOctetString);
        byte[] timeOctetString = this.time.encode();
        byteBuffer.put(timeOctetString);
        byteBuffer.put(this.subOctetString);
        return byteBuffer.array();
    }

    @Override
    public int length() {
        return 12;
    }

    @Override
    public int get(CosemDateFormat.Field field) {
        switch (field) {
            case DEVIATION: {
                short deviation = (short)((this.subOctetString[0] & 0xFF) << 8);
                deviation = (short)(deviation | this.subOctetString[1] & 0xFF);
                return deviation;
            }
            case CLOCK_STATUS: {
                return this.subOctetString[2];
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case HUNDREDTHS: {
                return this.time.get(field);
            }
            case YEAR: 
            case MONTH: 
            case DAY_OF_MONTH: 
            case DAY_OF_WEEK: {
                return this.date.get(field);
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum ClockStatus {
        INVALID_VALUE(1),
        DUBTFUL_VALUE(2),
        DIFFERENT_CLOCK_BASE(4),
        INVALID_CLOCK_STATUS(8),
        DAYLIGHT_SAVING_ACTIVE(128);

        private static final ClockStatus[] values;
        private byte flagMask;

        private ClockStatus(int bitmask) {
            this.flagMask = (byte)bitmask;
        }

        private static byte clockStatusToBitString(ClockStatus ... clockStatus) {
            if (clockStatus.length > values.length) {
                throw new IllegalArgumentException("Too many status flags set.");
            }
            byte bitString = 0;
            for (ClockStatus status : clockStatus) {
                bitString = (byte)(bitString | status.flagMask);
            }
            return bitString;
        }

        public static Set<ClockStatus> clockStatusFrom(byte bitString) {
            HashSet<ClockStatus> clockStatus = new HashSet<ClockStatus>();
            for (ClockStatus statusFlag : values) {
                if ((bitString & statusFlag.flagMask) != statusFlag.flagMask) continue;
                clockStatus.add(statusFlag);
            }
            return clockStatus;
        }

        static {
            values = ClockStatus.values();
        }
    }
}

