/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.datatypes;

public class BitString {
    private final byte[] bytes;
    private final int numBits;

    public BitString(byte[] bitString, int numBits) {
        if (bitString == null) {
            throw new NullPointerException("bitString cannot be null");
        }
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits cannot be negative.");
        }
        if (numBits > bitString.length * 8) {
            throw new IllegalArgumentException("'bitString' is too short to hold all bits.");
        }
        this.bytes = bitString;
        this.numBits = numBits;
    }

    public BitString(BitString other) {
        this((byte[])other.bytes.clone(), other.numBits);
    }

    public byte[] getBitString() {
        return this.bytes;
    }

    public int getNumBits() {
        return this.numBits;
    }
}

