/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openmuc.jdlms.ConnectionBuilder;
import org.openmuc.jdlms.sessionlayer.client.HdlcLayer;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.sessionlayer.client.WrapperLayer;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddress;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddressPair;
import org.openmuc.jdlms.settings.client.HdlcSettings;
import org.openmuc.jdlms.settings.client.HdlcTcpSettings;
import org.openmuc.jdlms.settings.client.Settings;
import org.openmuc.jdlms.transportlayer.client.TcpLayer;
import org.openmuc.jdlms.transportlayer.client.TransportLayer;
import org.openmuc.jdlms.transportlayer.client.UdpLayer;

public class TcpConnectionBuilder
extends ConnectionBuilder<TcpConnectionBuilder> {
    private InetAddress inetAddress;
    private int port;
    private InetSessionLayerType sessionLayerType;
    private InetTransportProtocol tranportProtocol;

    public TcpConnectionBuilder(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        this.port = 4059;
        this.sessionLayerType = InetSessionLayerType.WRAPPER;
        this.tranportProtocol = InetTransportProtocol.TCP;
    }

    public TcpConnectionBuilder(String inetAddress) throws UnknownHostException {
        this(InetAddress.getByName(inetAddress));
    }

    public TcpConnectionBuilder setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public void setTranportProtocol(InetTransportProtocol tranportProtocol) {
        this.tranportProtocol = tranportProtocol;
    }

    public TcpConnectionBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public TcpConnectionBuilder useHdlc() {
        this.sessionLayerType = InetSessionLayerType.HDLC;
        return this;
    }

    public TcpConnectionBuilder useWrapper() {
        this.sessionLayerType = InetSessionLayerType.WRAPPER;
        return this;
    }

    @Override
    protected Settings buildSettings() {
        return new TcpSettingsImpl(this);
    }

    @Override
    protected SessionLayer buildSessionLayer(Settings settings) throws IOException {
        switch (this.sessionLayerType) {
            case HDLC: {
                return new HdlcLayer((HdlcSettings)settings);
            }
        }
        TransportLayer tl = this.createNewTl((TcpSettingsImpl)settings);
        return new WrapperLayer(settings, tl);
    }

    private TransportLayer createNewTl(TcpSettingsImpl settings) {
        if (this.tranportProtocol == InetTransportProtocol.TCP) {
            return new TcpLayer(settings);
        }
        return new UdpLayer(settings);
    }

    public static enum InetTransportProtocol {
        UDP,
        TCP;

    }

    private static enum InetSessionLayerType {
        HDLC,
        WRAPPER;

    }

    public class TcpSettingsImpl
    extends ConnectionBuilder.SettingsImpl
    implements HdlcTcpSettings {
        private final InetAddress inetAddress;
        private final int port;
        private final HdlcAddressPair addressPair;
        private final InetTransportProtocol tranportProtocol;

        public TcpSettingsImpl(TcpConnectionBuilder connectionBuilder) {
            super(connectionBuilder);
            this.inetAddress = connectionBuilder.inetAddress;
            this.port = connectionBuilder.port;
            this.tranportProtocol = connectionBuilder.tranportProtocol;
            HdlcAddress source = new HdlcAddress(this.clientId());
            HdlcAddress destination = new HdlcAddress(this.logicalDeviceId(), this.physicalDeviceId());
            this.addressPair = new HdlcAddressPair(source, destination);
        }

        @Override
        public InetAddress inetAddress() {
            return this.inetAddress;
        }

        @Override
        public InetTransportProtocol tranportProtocol() {
            return this.tranportProtocol;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public HdlcAddressPair addressPair() {
            return this.addressPair;
        }
    }
}

