/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.CosemSnInterfaceObject;
import org.openmuc.jdlms.SnClassVersion;
import org.openmuc.jdlms.SnMemberRange;
import org.openmuc.jdlms.internal.Range;
import org.openmuc.jdlms.internal.RangeSet;

public class SnClassInfo
implements Serializable {
    private static final long serialVersionUID = 4113751726642331620L;
    private final RangeSet<Integer> attributes;
    private final RangeSet<Integer> methods;
    private final SnClassVersion snClassVersion;

    public SnClassInfo(int classId, int version, SnMemberRange methodRange) {
        this(new SnClassVersion(classId, version), methodRange);
    }

    @SafeVarargs
    public static Collection<SnClassInfo> mapIcToClassInfo(Class<? extends CosemSnInterfaceObject> ... ic) {
        return SnClassInfo.mapIcToClassInfo(Arrays.asList(ic));
    }

    public static Collection<SnClassInfo> mapIcToClassInfo(Collection<Class<? extends CosemSnInterfaceObject>> ics) {
        ArrayList<SnClassInfo> result = new ArrayList<SnClassInfo>(ics.size());
        for (Class<? extends CosemSnInterfaceObject> ic : ics) {
            SnClassInfo snClassInfo = new SnClassInfo(ic);
            result.add(snClassInfo);
        }
        return result;
    }

    private SnClassInfo(Class<? extends CosemSnInterfaceObject> cosemInterface) {
        CosemClass cosemClass = cosemInterface.getAnnotation(CosemClass.class);
        if (cosemClass == null) {
            throw new IllegalArgumentException("COSEM IC must be annotated with CosemClass.");
        }
        this.snClassVersion = new SnClassVersion(cosemClass.id(), cosemClass.version());
        this.attributes = new RangeSet();
        this.methods = new RangeSet();
        HashSet<CosemSnMember> m = new HashSet<CosemSnMember>();
        m.add(new CosemSnMember(0, 1, CosemSnMember.MemberType.ATTRIBUTE));
        SnClassInfo.addFieldsToSet(cosemInterface, m);
        SnClassInfo.addMethodsToSet(cosemInterface, m);
        this.setUpAttributesAndMethodsStruct(m);
    }

    public SnClassInfo(SnClassVersion snClassVersion, SnMemberRange methodRange) {
        this(snClassVersion, SnClassInfo.emptyList(), Arrays.asList(methodRange));
    }

    public SnClassInfo(int classId, int version, SnMemberRange attributeRange, SnMemberRange methodRange) {
        this(new SnClassVersion(classId, version), attributeRange, methodRange);
    }

    public SnClassInfo(SnClassVersion snClassVersion, SnMemberRange attributeRange, SnMemberRange methodRange) {
        this(snClassVersion, Arrays.asList(attributeRange), Arrays.asList(methodRange));
    }

    public SnClassInfo(int classId, int version, Collection<SnMemberRange> attributeRanges, List<SnMemberRange> methodRanges) {
        this(new SnClassVersion(classId, version), attributeRanges, methodRanges);
    }

    public SnClassInfo(SnClassVersion snClassVersion, Collection<SnMemberRange> attributeRanges, List<SnMemberRange> methodRanges) {
        this.snClassVersion = snClassVersion;
        RangeSet<Integer> rSet = new RangeSet<Integer>();
        this.attributes = new RangeSet();
        this.methods = new RangeSet();
        List<SnMemberRange> attributeRangesSorted = SnClassInfo.sort(attributeRanges);
        List<SnMemberRange> methodRangesSorted = SnClassInfo.sort(methodRanges);
        int numRPrevAttributes = SnClassInfo.firstOffsetFrom(attributeRangesSorted);
        for (SnMemberRange range : attributeRangesSorted) {
            this.checkIfValHasExisted(rSet, range);
            numRPrevAttributes = SnClassInfo.addRangeToSet(this.attributes, numRPrevAttributes, range);
        }
        int numRPrevMethods = SnClassInfo.firstOffsetFrom(methodRangesSorted);
        for (SnMemberRange range : methodRangesSorted) {
            this.checkIfValHasExisted(rSet, range);
            numRPrevMethods = SnClassInfo.addRangeToSet(this.methods, numRPrevMethods, range);
        }
    }

    private static List<SnMemberRange> emptyList() {
        return Collections.emptyList();
    }

    private static int firstOffsetFrom(List<SnMemberRange> lSorted) {
        if (!lSorted.isEmpty()) {
            int firstId = lSorted.get(0).getFirstRangeId();
            return firstId == -1 ? 0 : firstId - 1;
        }
        return 0;
    }

    private void checkIfValHasExisted(RangeSet<Integer> rSet, SnMemberRange range) {
        if (rSet.add(range) != null) {
            throw new IllegalArgumentException("Ranges intersect.");
        }
    }

    private static int addRangeToSet(RangeSet<Integer> rSet, int num, SnMemberRange range) {
        int startId = num + 1;
        if (range.getFirstRangeId() != -1) {
            startId = range.getFirstRangeId();
        }
        int endId = startId + ((Integer)range.getMaximum() - (Integer)range.getMinimum()) / 8;
        SnIdEntry e = rSet.add(new SnIdEntry(startId, endId, (Integer)range.getMinimum()));
        if (e != null) {
            // empty if block
        }
        return num + endId - startId + 1;
    }

    private static List<SnMemberRange> sort(Collection<SnMemberRange> list) {
        ArrayList<SnMemberRange> sorted = new ArrayList<SnMemberRange>(list);
        Collections.sort(sorted, new Comparator<SnMemberRange>(){

            @Override
            public int compare(SnMemberRange o1, SnMemberRange o2) {
                return ((Integer)o1.getMaximum()).compareTo((Integer)o2.getMinimum());
            }
        });
        return sorted;
    }

    public int computeAttributeSnOffsetFor(int attributeId) {
        int snOffset = SnClassInfo.calculateRangeSnOffset(attributeId, this.attributes);
        if (snOffset == -1) {
            snOffset = (attributeId - 1) * 8;
        }
        return snOffset;
    }

    public int computeMethodSnOffsetFor(int methodId) {
        return SnClassInfo.calculateRangeSnOffset(methodId, this.methods);
    }

    private static int calculateRangeSnOffset(int memberId, RangeSet<Integer> r) {
        SnIdEntry m = (SnIdEntry)r.getIntersectingRange(memberId);
        if (m == null) {
            return -1;
        }
        return m.rangeSnOffset + (memberId - (Integer)m.getMinimum()) * 8;
    }

    public SnClassVersion getSnClassVersion() {
        return this.snClassVersion;
    }

    public String toString() {
        return String.format("{%n \"class-version\": %s,%n \"attributes\": %s,%n \"methods\": %s%n}", this.snClassVersion, this.attributes, this.methods);
    }

    private void setUpAttributesAndMethodsStruct(Set<CosemSnMember> m) {
        ArrayList<CosemSnMember> list = new ArrayList<CosemSnMember>(m);
        Collections.sort(list);
        ListIterator<CosemSnMember> iter = list.listIterator();
        while (iter.hasNext()) {
            int firstId;
            CosemSnMember first = iter.next();
            CosemSnMember.MemberType memberType = first.getMemberType();
            int lastId = firstId = first.getId();
            int firstOffset = first.getSnOffset();
            CosemSnMember prev = first;
            while (iter.hasNext()) {
                CosemSnMember next = iter.next();
                int expectedOffset = prev.getSnOffset() + 8;
                if (next.getMemberType() != first.getMemberType() || expectedOffset != next.getSnOffset() || prev.getId() + 1 != next.getId()) {
                    iter.previous();
                    break;
                }
                prev = next;
                lastId = next.getId();
            }
            SnIdEntry range = new SnIdEntry(firstId, lastId, firstOffset);
            if (memberType == CosemSnMember.MemberType.ATTRIBUTE) {
                this.attributes.add(range);
                continue;
            }
            this.methods.add(range);
        }
    }

    private static void addMethodsToSet(Class<? extends CosemSnInterfaceObject> c, Set<CosemSnMember> m) {
        for (Method method : c.getDeclaredMethods()) {
            CosemMethod cosemMethod = method.getAnnotation(CosemMethod.class);
            if (cosemMethod == null || cosemMethod.snOffset() == -1) continue;
            int snOffset = cosemMethod.snOffset();
            SnClassInfo.checkOffset(snOffset);
            boolean r = m.add(new CosemSnMember(snOffset, cosemMethod.id(), CosemSnMember.MemberType.METHOD));
            SnClassInfo.checkIfMemberHasExisted(r, snOffset);
        }
    }

    private static void addFieldsToSet(Class<? extends CosemSnInterfaceObject> c, Set<CosemSnMember> m) {
        for (Field field : c.getDeclaredFields()) {
            CosemAttribute cosemAttribute = field.getAnnotation(CosemAttribute.class);
            if (cosemAttribute == null || cosemAttribute.snOffset() == -1) continue;
            int snOffset = cosemAttribute.snOffset();
            SnClassInfo.checkOffset(snOffset);
            boolean r = m.add(new CosemSnMember(snOffset, cosemAttribute.id(), CosemSnMember.MemberType.ATTRIBUTE));
            SnClassInfo.checkIfMemberHasExisted(r, snOffset);
        }
    }

    private static void checkOffset(int snOffset) {
        if (snOffset % 8 != 0) {
            throw new IllegalArgumentException("SN offsets must be a multiple of 0x08.");
        }
    }

    private static void checkIfMemberHasExisted(boolean r, int offset) {
        if (!r) {
            throw new IllegalArgumentException(String.format("Member with SN offset 0x%02X is not unique.", offset));
        }
    }

    private static class SnIdEntry
    extends Range<Integer> {
        private static final long serialVersionUID = -2092724143767438287L;
        private final int rangeSnOffset;

        public SnIdEntry(Integer fromInclusive, Integer toInclusive, int snOffset) {
            super(fromInclusive, toInclusive);
            this.rangeSnOffset = snOffset;
        }

        @Override
        public String toString() {
            return String.format("{\"range\": [%d, %d], \"snOffset\": \"0x%02X\"}", this.getMinimum(), this.getMaximum(), this.rangeSnOffset);
        }
    }

    private static class CosemSnMember
    implements Comparable<CosemSnMember> {
        private final int snOffset;
        private final int id;
        private final MemberType memberType;

        public CosemSnMember(int snOffset, int id, MemberType memberType) {
            this.snOffset = snOffset;
            this.id = id;
            this.memberType = memberType;
        }

        public int getId() {
            return this.id;
        }

        public MemberType getMemberType() {
            return this.memberType;
        }

        public int getSnOffset() {
            return this.snOffset;
        }

        @Override
        public int compareTo(CosemSnMember o) {
            return Integer.compare(this.snOffset, o.snOffset);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CosemSnMember)) {
                return false;
            }
            CosemSnMember other = (CosemSnMember)obj;
            return other.snOffset == this.snOffset;
        }

        public int hashCode() {
            return this.snOffset;
        }

        public String toString() {
            return String.format("{\"id\": %d, \"offset\": 0x%02X, \"member-type\": \"%s\"}", new Object[]{this.id, this.snOffset, this.memberType});
        }

        public static enum MemberType {
            METHOD,
            ATTRIBUTE;

        }
    }
}

