/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.datatypes.DataObject;

public class SnAddressSpec {
    private final int variableName;
    private final SelectiveAccessDescription parameterizedAccess;

    public static SnAddressSpec newAttributeAddress(int variableName) {
        return new SnAddressSpec(variableName);
    }

    public static SnAddressSpec newAttributeAddress(int variableName, SelectiveAccessDescription parameterizedAccess) {
        return new SnAddressSpec(variableName, parameterizedAccess);
    }

    public static SnAddressSpec newMethodAddress(int methodName, DataObject invocationParameter) {
        return new SnAddressSpec(methodName, new SelectiveAccessDescription(0, invocationParameter));
    }

    public static SnAddressSpec newMethodAddress(int methodName) {
        return SnAddressSpec.newMethodAddress(methodName, DataObject.newNullData());
    }

    SnAddressSpec(int variableName) {
        this(variableName, null);
    }

    SnAddressSpec(int variableName, SelectiveAccessDescription parameterizedAccess) {
        this.variableName = variableName;
        this.parameterizedAccess = parameterizedAccess;
    }

    public int getVariableName() {
        return this.variableName;
    }

    public SelectiveAccessDescription getParameterizedAccessDescriptor() {
        return this.parameterizedAccess;
    }

    public String toString() {
        return String.format("{\"variable-name\": \"0x%02X\", \"parameterized-access\": %s}", this.variableName, this.parameterizedAccess);
    }
}

