/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.util.regex.Pattern;
import org.openmuc.jdlms.ConnectionBuilder;
import org.openmuc.jdlms.sessionlayer.client.HdlcLayer;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddress;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddressPair;
import org.openmuc.jdlms.settings.client.HdlcSettings;
import org.openmuc.jdlms.settings.client.SerialSettings;
import org.openmuc.jdlms.settings.client.Settings;
import org.openmuc.jdlms.transportlayer.client.Iec21Layer;

public class SerialConnectionBuilder
extends ConnectionBuilder<SerialConnectionBuilder> {
    private static final Pattern IEC_21_PATTERN = Pattern.compile("^[A-Za-z0-9]{0,32}$");
    private String serialPortName;
    private int baudrate;
    private Iec21Layer.DataFlowControl iec21Handshake;
    private long baudrateChangeTime;
    private String iec21Address;

    public SerialConnectionBuilder(String serialPortName) {
        this.serialPortName = serialPortName;
        this.iec21Handshake = Iec21Layer.DataFlowControl.DISABLED;
        this.baudrate = 9600;
        this.baudrateChangeTime = 150L;
        this.iec21Address = "";
    }

    @Override
    protected Settings buildSettings() {
        return new HdlcSettingsImpl(this);
    }

    @Override
    protected SessionLayer buildSessionLayer(Settings settings) throws IOException {
        return new HdlcLayer((HdlcSettings)settings);
    }

    public SerialConnectionBuilder setSerialPortName(String serialPortName) {
        this.serialPortName = serialPortName;
        return this;
    }

    public SerialConnectionBuilder setIec21Address(String iec21Address) {
        if (iec21Address == null) {
            throw new IllegalArgumentException("IEC 21 address may not be null!");
        }
        if (!IEC_21_PATTERN.matcher(iec21Address).matches()) {
            throw new IllegalArgumentException("The supplied String does not match the IEC 21 address pattern.");
        }
        this.iec21Address = iec21Address;
        this.enableHandshake();
        return this;
    }

    public SerialConnectionBuilder disableHandshake() {
        this.iec21Handshake = Iec21Layer.DataFlowControl.DISABLED;
        return this;
    }

    public SerialConnectionBuilder enableHandshake() {
        this.iec21Handshake = Iec21Layer.DataFlowControl.ENABLED;
        return this;
    }

    public SerialConnectionBuilder setBaudRate(int baudrate) {
        this.baudrate = baudrate;
        this.disableHandshake();
        return this;
    }

    public SerialConnectionBuilder setBaudRateChangeTime(long baudrateChangeTime) {
        this.baudrateChangeTime = baudrateChangeTime;
        this.enableHandshake();
        return this;
    }

    public class HdlcSettingsImpl
    extends ConnectionBuilder.SettingsImpl
    implements SerialSettings {
        private final String serialPortName;
        private final int baudrate;
        private final long baudrateChangeTime;
        private final HdlcAddressPair addressPair;
        private final Iec21Layer.DataFlowControl iec21Handshake;
        private final String iec21Address;

        public HdlcSettingsImpl(SerialConnectionBuilder builder) {
            super(builder);
            this.serialPortName = builder.serialPortName;
            HdlcAddress clientAddress = new HdlcAddress(this.clientId());
            HdlcAddress serverAddress = this.physicalDeviceId() != 0 ? new HdlcAddress(this.logicalDeviceId(), this.physicalDeviceId()) : new HdlcAddress(this.logicalDeviceId());
            this.addressPair = new HdlcAddressPair(clientAddress, serverAddress);
            this.baudrate = builder.baudrate;
            this.baudrateChangeTime = builder.baudrateChangeTime;
            this.iec21Handshake = builder.iec21Handshake;
            this.iec21Address = builder.iec21Address;
        }

        @Override
        public String serialPortName() {
            return this.serialPortName;
        }

        @Override
        public HdlcAddressPair addressPair() {
            return this.addressPair;
        }

        @Override
        public int baudrate() {
            return this.baudrate;
        }

        @Override
        public long baudrateChangeDelay() {
            return this.baudrateChangeTime;
        }

        @Override
        public Iec21Layer.DataFlowControl iec21Handshake() {
            return this.iec21Handshake;
        }

        @Override
        public String iec21Address() {
            return this.iec21Address;
        }
    }
}

