/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.text.MessageFormat;
import org.openmuc.jdlms.HexConverter;

public class RawMessageData {
    private final MessageSource messageSource;
    private final byte[] message;
    private final Apdu apdu;

    private RawMessageData(MessageSource messageSource, byte[] message, Apdu apdu) {
        this.messageSource = messageSource;
        this.message = message;
        this.apdu = apdu;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public Apdu getApdu() {
        return this.apdu;
    }

    public String toString() {
        String pattern2 = "{0}: {1}";
        String pattern = "{0}: {1},\n";
        return MessageFormat.format(pattern, new Object[]{"Source", this.messageSource}) + MessageFormat.format(pattern, "Message", HexConverter.toShortHexString(this.message)) + MessageFormat.format(pattern2, "APDU", this.apdu);
    }

    private static String nullableArrayToString(byte[] data) {
        return data == null ? "[null]" : HexConverter.toShortHexString(data);
    }

    public static RawMessageDataBuilder builder() {
        return new RawMessageDataBuilder();
    }

    public static class RawMessageDataBuilder {
        private MessageSource messageSource;
        private byte[] message;
        private Apdu apdu;

        private RawMessageDataBuilder() {
        }

        public RawMessageDataBuilder setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
            return this;
        }

        public RawMessageDataBuilder setMessage(byte[] message) {
            this.message = message;
            return this;
        }

        public RawMessageDataBuilder setApdu(Apdu apdu) {
            this.apdu = apdu;
            return this;
        }

        public RawMessageData build() {
            return new RawMessageData(this.messageSource, this.message, this.apdu);
        }
    }

    public static class CosemPdu {
        private final byte[] cipheredCosemPdu;
        private final byte[] plainCosemPdu;

        public CosemPdu(byte[] cipheredCosemPdu, byte[] plainCosemPdu) {
            this.cipheredCosemPdu = cipheredCosemPdu;
            this.plainCosemPdu = plainCosemPdu;
        }

        public byte[] getCipheredCosemPdu() {
            return this.cipheredCosemPdu;
        }

        public byte[] getPlainCosemPdu() {
            return this.plainCosemPdu;
        }

        public String toString() {
            return MessageFormat.format("Ciphered COSEM PDU: {0}\nPlain COSEM PDU: {1}", RawMessageData.nullableArrayToString(this.cipheredCosemPdu), RawMessageData.nullableArrayToString(this.plainCosemPdu));
        }
    }

    public static class Apdu {
        private final CosemPdu cosemPdu;
        private final byte[] acsePdu;

        public Apdu(CosemPdu cosemPdu, byte[] acsePdu) {
            this.cosemPdu = cosemPdu;
            this.acsePdu = acsePdu;
        }

        public CosemPdu getCosemPdu() {
            return this.cosemPdu;
        }

        public byte[] getAcsePdu() {
            return this.acsePdu;
        }

        public String toString() {
            String formatStr = "{0}:\n{1}\n";
            return '\n' + MessageFormat.format("{0}:\n{1}\n", "ACSE PDU", RawMessageData.nullableArrayToString(this.getAcsePdu())) + MessageFormat.format("{0}:\n{1}\n", "COSEM PDU", this.getCosemPdu());
        }
    }

    public static enum MessageSource {
        CLIENT,
        SERVER;

    }
}

