/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObisCode {
    private static final int NUM_OF_BYTES = 6;
    private static final Pattern OBIS_PATTERN;
    private byte[] bytes;

    public ObisCode(int byteA, int byteB, int byteC, int byteD, int byteE, int byteF) {
        this.bytes = ObisCode.verifyLengthAndConvertToByteArray(byteA, byteB, byteC, byteD, byteE, byteF);
    }

    public ObisCode(String address) {
        String[] addressArray = address.split("\\.");
        if (addressArray.length == 6) {
            int[] bytesInt = new int[]{Integer.parseInt(addressArray[0]), Integer.parseInt(addressArray[1]), Integer.parseInt(addressArray[2]), Integer.parseInt(addressArray[3]), Integer.parseInt(addressArray[4]), Integer.parseInt(addressArray[5])};
            this.bytes = ObisCode.verifyLengthAndConvertToByteArray(bytesInt);
        } else {
            Matcher obisMatcher = OBIS_PATTERN.matcher(address);
            if (obisMatcher.matches()) {
                this.bytes = new byte[6];
                this.bytes[0] = (byte)ObisCode.convertToByte(obisMatcher, 2);
                this.bytes[1] = (byte)ObisCode.convertToByte(obisMatcher, 4);
                this.bytes[2] = (byte)ObisCode.convertToByte(obisMatcher, 5);
                this.bytes[3] = (byte)ObisCode.convertToByte(obisMatcher, 6);
                this.bytes[4] = (byte)ObisCode.convertToByte(obisMatcher, 8);
                int fieldF = ObisCode.convertToByte(obisMatcher, 10);
                if (fieldF == -1) {
                    fieldF = 255;
                }
                this.bytes[5] = (byte)fieldF;
            } else {
                throw new IllegalArgumentException("ObisCode is not reduced obis format.");
            }
        }
    }

    public Medium medium() {
        return Medium.mediumFor(this.bytes[0] & 0xFF);
    }

    public int channel() {
        return this.bytes[1] & 0xFF;
    }

    private static int convertToByte(Matcher obisMatcher, int group) {
        String byteStr = obisMatcher.group(group);
        if (byteStr == null) {
            return -1;
        }
        return Integer.parseInt(byteStr);
    }

    public ObisCode(byte[] bytes) {
        if (bytes.length != 6) {
            throw new IllegalArgumentException("ObisCode has the wrong length, not equal.");
        }
        this.bytes = bytes;
    }

    public String asShortObisCodeString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        sb.append(String.format("%d-", this.bytes[i++] & 0xFF));
        sb.append(String.format("%d:", this.bytes[i++] & 0xFF));
        sb.append(String.format("%d.", this.bytes[i++] & 0xFF));
        sb.append(String.format("%d", this.bytes[i++] & 0xFF));
        sb.append(String.format(".%d", this.bytes[i++] & 0xFF));
        int f = this.bytes[i] & 0xFF;
        if (f != 255) {
            sb.append(String.format("*%d", f));
        }
        return sb.toString();
    }

    public String asHexCodeString() {
        StringBuilder sb = new StringBuilder(12);
        for (int i = 0; i < 6; ++i) {
            sb.append(String.format("%02x", this.bytes[i]));
        }
        return sb.toString();
    }

    public byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    public String asDecimalString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            sb.append(this.bytes[i] & 0xFF);
            sb.append('.');
        }
        sb.append(this.bytes[5] & 0xFF);
        return sb.toString();
    }

    public String toString() {
        return this.asDecimalString();
    }

    private static byte[] verifyLengthAndConvertToByteArray(int ... bytesInt) {
        for (int b : bytesInt) {
            ObisCode.checkLength(b & 0xFFFFFFFF);
        }
        byte[] data = new byte[6];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)bytesInt[i];
        }
        return data;
    }

    private static void checkLength(int number) {
        if (number < 0 || number > 255) {
            throw new IllegalArgumentException(number + " is out of range [0, 255]");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObisCode)) {
            return false;
        }
        ObisCode other = (ObisCode)obj;
        return other == this || Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    static {
        String numberFormat = "[0-9]{1,3}";
        String a = "(([0-9]{1,3})-)?";
        String b = "(([0-9]{1,3}):)?";
        String c = "([0-9]{1,3}).";
        String d = "([0-9]{1,3})";
        String e = "(\\.([0-9]{1,3}))?";
        String f = "(\\*([0-9]{1,3}))?";
        OBIS_PATTERN = Pattern.compile("^" + a + b + c + d + e + f + "$");
    }

    public static enum Medium {
        ABSTRACT(0),
        ELECTRICITY(1),
        HEAT_COST_ALLOCATOR(4),
        COOLING(5),
        HEAT(6),
        GAS(7),
        COLD_WATER(8),
        HOT_WATER(9),
        RESERVED(-1);

        private int code;

        private Medium(int code) {
            this.code = code;
        }

        private static Medium mediumFor(int code) {
            for (Medium medium : Medium.values()) {
                if (medium.code != code) continue;
                return medium;
            }
            return RESERVED;
        }
    }
}

