/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import org.openmuc.jdlms.CosemResourceDescriptor;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.interfaceclass.method.MethodClass;
import org.openmuc.jdlms.internal.asn1.cosem.CosemMethodDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.CosemObjectInstanceId;
import org.openmuc.jdlms.internal.asn1.cosem.Integer8;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;

public final class MethodParameter
extends CosemResourceDescriptor {
    private final DataObject param;

    public MethodParameter(int classId, ObisCode instanceId, int methodId) {
        this(classId, instanceId, methodId, DataObject.newNullData());
    }

    public MethodParameter(int classId, String instanceId, int methodId) {
        this(classId, new ObisCode(instanceId), methodId);
    }

    public MethodParameter(int classId, ObisCode instanceId, int methodId, DataObject methodParameter) {
        super(classId, instanceId, methodId);
        this.param = methodParameter;
    }

    public MethodParameter(int classId, String instanceId, int methodId, DataObject methodParameter) {
        this(classId, new ObisCode(instanceId), methodId, methodParameter);
    }

    @Deprecated
    public MethodParameter(MethodClass methodClass, String instanceId, DataObject methodParameter) {
        this(methodClass, new ObisCode(instanceId), methodParameter);
    }

    @Deprecated
    public MethodParameter(MethodClass methodClass, ObisCode instanceId, DataObject methodParameter) {
        this(methodClass.getInterfaceClass().id(), instanceId, methodClass.getMethodId(), methodParameter);
    }

    public DataObject getParameter() {
        return this.param;
    }

    @Override
    CosemMethodDescriptor toDescriptor() {
        Unsigned16 classId = new Unsigned16(this.getClassId());
        CosemObjectInstanceId instanceId = new CosemObjectInstanceId(this.getInstanceId().bytes());
        Integer8 methodId = new Integer8(this.getId());
        return new CosemMethodDescriptor(classId, instanceId, methodId);
    }

    @Override
    public String toString() {
        return String.format("{\"address\": %s, \"parameter\": %s}", super.toString(), this.param);
    }
}

