/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AccessResultImpl;
import org.openmuc.jdlms.BaseDlmsConnection;
import org.openmuc.jdlms.ConformanceSetting;
import org.openmuc.jdlms.DlmsSnConnection;
import org.openmuc.jdlms.MethodResult;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.ReadResult;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.SnAddressSpec;
import org.openmuc.jdlms.SnWriteParameter;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.ContextId;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.DlmsEnumFunctions;
import org.openmuc.jdlms.internal.asn1.cosem.BlockNumberAccess;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.DataBlockResult;
import org.openmuc.jdlms.internal.asn1.cosem.Integer16;
import org.openmuc.jdlms.internal.asn1.cosem.ParameterizedAccess;
import org.openmuc.jdlms.internal.asn1.cosem.ReadRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ReadResponse;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;
import org.openmuc.jdlms.internal.asn1.cosem.VariableAccessSpecification;
import org.openmuc.jdlms.internal.asn1.cosem.WriteRequest;
import org.openmuc.jdlms.internal.asn1.cosem.WriteResponse;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.settings.client.Settings;

class DlmsSnConnectionImpl
extends BaseDlmsConnection
implements DlmsSnConnection {
    DlmsSnConnectionImpl(Settings settings, SessionLayer sessionLayer) {
        super(settings, sessionLayer);
    }

    @Override
    public ReadResult read(SnAddressSpec params) throws IOException {
        return this.read(Arrays.asList(params)).get(0);
    }

    @Override
    public synchronized List<ReadResult> read(List<SnAddressSpec> params) throws IOException {
        if (DlmsSnConnectionImpl.nullableListIsEmpty(params)) {
            return Collections.emptyList();
        }
        if (!this.multipleReferencesAllowed(params)) {
            return this.callEachReadIndividually(params);
        }
        ReadRequest request = new ReadRequest();
        Object[] res = new ReadResult[params.size()];
        ListIterator<SnAddressSpec> iterator = params.listIterator();
        while (iterator.hasNext()) {
            SnAddressSpec addrSpec = iterator.next();
            int indexOfCurrentVal = iterator.previousIndex();
            VariableAccessSpecification varSpec = this.createVarAccessSpecFor(res, addrSpec, indexOfCurrentVal, new AccessResultImpl(AccessResultCode.SCOPE_OF_ACCESS_VIOLATED));
            request.add(varSpec);
        }
        COSEMpdu pdu = new COSEMpdu();
        pdu.setReadRequest(request);
        ReadResponse response = this.sendReadPoll(pdu);
        Iterator resIter = response.iterator();
        int resIndex = 0;
        while (resIter.hasNext()) {
            ReadResponse.SubChoice data = (ReadResponse.SubChoice)resIter.next();
            ReadResult resultItem = DlmsSnConnectionImpl.convertReadResponseToReadResult(data);
            resIndex = DlmsSnConnectionImpl.nextFreeResultIndex(res, resIndex);
            res[resIndex++] = resultItem;
        }
        return Arrays.asList(res);
    }

    private <T> VariableAccessSpecification createVarAccessSpecFor(T[] res, SnAddressSpec addrSpec, int indexOfCurrentVal, T errVal) {
        VariableAccessSpecification varSpec = new VariableAccessSpecification();
        SelectiveAccessDescription accessDescription = addrSpec.getParameterizedAccessDescriptor();
        Integer16 variableName = new Integer16((short)addrSpec.getVariableName());
        if (accessDescription == null) {
            varSpec.setVariableName(variableName);
        } else if (this.negotiatedFeatures().contains((Object)ConformanceSetting.PARAMETERIZED_ACCESS)) {
            Unsigned8 selector = new Unsigned8(accessDescription.getAccessSelector());
            Data data = DataConverter.convertDataObjectToData(accessDescription.getAccessParameter());
            ParameterizedAccess paramAccess = new ParameterizedAccess(variableName, selector, data);
            varSpec.setParameterizedAccess(paramAccess);
        } else {
            res[indexOfCurrentVal] = errVal;
        }
        return varSpec;
    }

    private static ReadResult convertReadResponseToReadResult(ReadResponse.SubChoice data) {
        AccessResultImpl resultItem;
        if (data.getChoiceIndex() == ReadResponse.SubChoice.Choices.DATA) {
            DataObject dat = DataConverter.convertDataToDataObject(data.data);
            resultItem = new AccessResultImpl(dat);
        } else {
            AccessResultCode resultCode = DlmsEnumFunctions.enumValueFrom(data.dataAccessError, AccessResultCode.class);
            resultItem = new AccessResultImpl(resultCode);
        }
        return resultItem;
    }

    private boolean multipleReferencesAllowed(List<?> params) {
        return params.size() == 1 || this.negotiatedFeatures().contains((Object)ConformanceSetting.MULTIPLE_REFERENCES);
    }

    private List<ReadResult> callEachReadIndividually(List<SnAddressSpec> params) throws IOException {
        ArrayList<ReadResult> resultList = new ArrayList<ReadResult>(params.size());
        for (SnAddressSpec snAddress : params) {
            resultList.add(this.read(snAddress));
        }
        return resultList;
    }

    private ReadResponse sendReadPoll(COSEMpdu pdu) throws IOException {
        ReadResponse readResponse = (ReadResponse)this.send(pdu);
        ReadResponse.SubChoice.Choices choiceIndex = ((ReadResponse.SubChoice)readResponse.get(0)).getChoiceIndex();
        if (choiceIndex != ReadResponse.SubChoice.Choices.DATA_BLOCK_RESULT) {
            return readResponse;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (true) {
            DataBlockResult dataBlockResult = ((ReadResponse.SubChoice)readResponse.get((int)0)).dataBlockResult;
            baos.write(dataBlockResult.rawData.getValue());
            if (dataBlockResult.lastBlock.getValue()) {
                readResponse = new ReadResponse();
                readResponse.decode(new ByteArrayInputStream(baos.toByteArray()));
                return readResponse;
            }
            Unsigned16 blockNumber = dataBlockResult.blockNumber;
            readResponse = this.requestNexBlock(blockNumber);
        }
    }

    private ReadResponse requestNexBlock(Unsigned16 blockNumber) throws IOException {
        ReadRequest readRequest = new ReadRequest();
        VariableAccessSpecification blockNumAccess = new VariableAccessSpecification();
        blockNumAccess.setBlockNumberAccess(new BlockNumberAccess(blockNumber));
        readRequest.add(blockNumAccess);
        COSEMpdu cosemPdu = new COSEMpdu();
        cosemPdu.setReadRequest(readRequest);
        return (ReadResponse)this.send(cosemPdu);
    }

    @Override
    public AccessResultCode write(SnWriteParameter param) throws IOException {
        return this.write(Arrays.asList(param)).get(0);
    }

    @Override
    public synchronized List<AccessResultCode> write(List<SnWriteParameter> params) throws IOException {
        if (DlmsSnConnectionImpl.nullableListIsEmpty(params)) {
            return Collections.emptyList();
        }
        if (!this.multipleReferencesAllowed(params)) {
            return this.callEachWriteIndividually(params);
        }
        if (!this.negotiatedFeatures().contains((Object)ConformanceSetting.WRITE)) {
            return this.answerWithWriteNotAllowed(params);
        }
        Object[] result = new AccessResultCode[params.size()];
        ListIterator<SnWriteParameter> paramsIter = params.listIterator();
        WriteRequest request = new WriteRequest();
        request.listOfData = new WriteRequest.SubSeqOfListOfData();
        request.variableAccessSpecification = new WriteRequest.SubSeqOfVariableAccessSpecification();
        while (paramsIter.hasNext()) {
            int nextListIndex = paramsIter.previousIndex();
            SnWriteParameter writeSpec = paramsIter.next();
            AccessResultCode defaultErrorValue = AccessResultCode.SCOPE_OF_ACCESS_VIOLATED;
            VariableAccessSpecification varSpec = this.createVarAccessSpecFor(result, (SnAddressSpec)writeSpec.getAddress(), nextListIndex, defaultErrorValue);
            request.listOfData.add(DataConverter.convertDataObjectToData(writeSpec.getData()));
            request.variableAccessSpecification.add(varSpec);
        }
        if (request.variableAccessSpecification.size() == 0) {
            return Arrays.asList(result);
        }
        COSEMpdu pdu = new COSEMpdu();
        pdu.setWriteRequest(request);
        WriteResponse writeRes = (WriteResponse)this.send(pdu);
        Iterator responseIter = writeRes.iterator();
        int resultIndex = 0;
        while (responseIter.hasNext()) {
            WriteResponse.SubChoice response = (WriteResponse.SubChoice)responseIter.next();
            AccessResultCode item = response.getChoiceIndex() == WriteResponse.SubChoice.Choices.SUCCESS ? AccessResultCode.SUCCESS : DlmsEnumFunctions.enumValueFrom(response.dataAccessError, AccessResultCode.class);
            resultIndex = DlmsSnConnectionImpl.nextFreeResultIndex(result, resultIndex);
            result[resultIndex++] = item;
        }
        return Arrays.asList(result);
    }

    private List<AccessResultCode> answerWithWriteNotAllowed(List<SnWriteParameter> params) {
        ArrayList<AccessResultCode> resList = new ArrayList<AccessResultCode>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            resList.add(AccessResultCode.SCOPE_OF_ACCESS_VIOLATED);
        }
        return resList;
    }

    private List<AccessResultCode> callEachWriteIndividually(List<SnWriteParameter> params) throws IOException {
        ArrayList<AccessResultCode> resList = new ArrayList<AccessResultCode>(params.size());
        for (SnWriteParameter param : params) {
            resList.add(this.write(param));
        }
        return resList;
    }

    private static int nextFreeResultIndex(Object[] result, int resIndex) {
        int startIndex;
        for (startIndex = resIndex; startIndex < result.length && result[startIndex] != null; ++startIndex) {
        }
        return startIndex;
    }

    @Override
    void processEventPdu(COSEMpdu pdu) {
    }

    @Override
    Set<ConformanceSetting> proposedConformance() {
        return new HashSet<ConformanceSetting>(Arrays.asList(ConformanceSetting.READ, ConformanceSetting.WRITE, ConformanceSetting.MULTIPLE_REFERENCES, ConformanceSetting.PARAMETERIZED_ACCESS));
    }

    private static boolean nullableListIsEmpty(List<?> params) {
        return params == null || params.isEmpty();
    }

    @Override
    MethodResult authenticateViaHls(byte[] processedChallenge) throws IOException {
        DataObject param = DataObject.newOctetStringData(processedChallenge);
        int replyToHlsAuthOffset = 88;
        SnAddressSpec snAddress = SnAddressSpec.newMethodAddress(64000 + replyToHlsAuthOffset, param);
        ReadResult result = this.read(snAddress);
        AccessResultCode resultCode = result.getResultCode();
        MethodResultCode methodCode = MethodResultCode.SUCCESS;
        if (resultCode != AccessResultCode.SUCCESS) {
            methodCode = MethodResultCode.OBJECT_UNAVAILABLE;
        }
        return new MethodResult(methodCode, result.getResultData());
    }

    @Override
    void validateReferencingMethod() throws IOException {
        if (this.negotiatedFeatures().contains((Object)ConformanceSetting.READ) || this.negotiatedFeatures().contains((Object)ConformanceSetting.WRITE)) {
            return;
        }
        this.close();
        throw new IOException("Wrong referencing method. Remote smart meter can't use SN referencing");
    }

    @Override
    ContextId getContextId() {
        SecuritySuite.EncryptionMechanism encryptionMechanism = this.connectionSettings().securitySuite().getEncryptionMechanism();
        if (encryptionMechanism != SecuritySuite.EncryptionMechanism.NONE) {
            return ContextId.SHORT_NAME_REFERENCING_WITH_CIPHERING;
        }
        return ContextId.SHORT_NAME_REFERENCING_NO_CIPHERING;
    }
}

