/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import org.openmuc.jdlms.DataDirectory;
import org.openmuc.jdlms.ServerBuilder;
import org.openmuc.jdlms.internal.transportlayer.server.ServerTcpLayer;
import org.openmuc.jdlms.sessionlayer.server.ServerSessionLayerFactories;
import org.openmuc.jdlms.sessionlayer.server.ServerSessionLayerFactory;
import org.openmuc.jdlms.settings.server.TcpServerSettings;
import org.openmuc.jdlms.transportlayer.server.ServerTransportLayer;

public class DlmsServer
implements AutoCloseable {
    private final ServerTransportLayer serverTransportLayer;

    DlmsServer(ServerTransportLayer serverTransportLayer) {
        this.serverTransportLayer = serverTransportLayer;
    }

    void start() throws IOException {
        this.serverTransportLayer.start();
    }

    @Override
    public void close() throws IOException {
        this.serverTransportLayer.close();
    }

    public void shutdown() throws IOException {
        this.close();
    }

    public static TcpServerBuilder tcpServerBuilder(int port) {
        return new TcpServerBuilder(port);
    }

    public static TcpServerBuilder tcpServerBuilder() {
        return new TcpServerBuilder(4059);
    }

    public static class TcpServerBuilder
    extends ServerBuilder<TcpServerBuilder> {
        private int port;
        private ServerSessionLayerFactory sessionLayerFactory;

        private TcpServerBuilder(int port) {
            this.port = port;
            this.sessionLayerFactory = ServerSessionLayerFactories.newWrapperSessionLayerFactory();
        }

        public TcpServerBuilder setSessionLayerFactory(ServerSessionLayerFactory sessionLayerFactory) {
            this.sessionLayerFactory = sessionLayerFactory;
            return this;
        }

        public TcpServerBuilder setTcpPort(int port) {
            this.port = port;
            return this;
        }

        @Override
        public DlmsServer build() throws IOException {
            DataDirectory dataDirectory = this.parseLogicalDevices();
            TcpServerSettingsImpl settings = new TcpServerSettingsImpl(this.port);
            this.setPropertiesTo(settings);
            ServerTcpLayer serverLayer = new ServerTcpLayer(settings, dataDirectory, this.sessionLayerFactory);
            return this.newServer(serverLayer);
        }
    }

    public static class TcpServerSettingsImpl
    extends ServerBuilder.ServerSettingsImpl
    implements TcpServerSettings {
        private final int port;

        public TcpServerSettingsImpl(int port) {
            this.port = port;
        }

        @Override
        public int getTcpPort() {
            return this.port;
        }
    }
}

