/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openmuc.jdlms.DlmsConnection;
import org.openmuc.jdlms.DlmsLnConnectionWrapper;
import org.openmuc.jdlms.DlmsLnToSnConnectionWrapper;
import org.openmuc.jdlms.DlmsSnConnection;
import org.openmuc.jdlms.DlmsSnConnectionImpl;
import org.openmuc.jdlms.LnConnectionWrapper;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.RawMessageListener;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SnClassInfo;
import org.openmuc.jdlms.SnClassVersion;
import org.openmuc.jdlms.SnObjectInfo;
import org.openmuc.jdlms.internal.SecSuiteAccessor;
import org.openmuc.jdlms.internal.SnInterfaceClassList;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.settings.client.ReferencingMethod;
import org.openmuc.jdlms.settings.client.Settings;

public abstract class ConnectionBuilder<T extends ConnectionBuilder<T>> {
    private byte[] systemTitle = new byte[]{77, 77, 77, 0, 0, 0, 0, 1};
    private int challengeLength = 64;
    private long frameCounter = 1L;
    private int responseTimeout = 5000;
    private int logicalDeviceId = 1;
    private int clientId = 16;
    private int userId = -1;
    private SecuritySuite securitySuite = SecuritySuite.builder().build();
    private int physicalDeviceId = 0;
    private ReferencingMethod referencingMethod = ReferencingMethod.LOGICAL;
    private RawMessageListener rawMessageListener = null;
    private int hdlcMaxInformationLength = 2030;
    private boolean alwaysSendSecurityMechanismName = false;
    private boolean skipAARQEncryption = false;
    private Map<ObisCode, SnObjectInfo> lnSnMapping;
    private final Map<SnClassVersion, SnClassInfo> snClassInfos = new HashMap<SnClassVersion, SnClassInfo>();

    public ConnectionBuilder() {
        for (SnClassInfo s : SnInterfaceClassList.getDefaultSnObjects()) {
            this.snClassInfos.put(s.getSnClassVersion(), s);
        }
    }

    public T setLnToSnMapping(Collection<SnObjectInfo> lnSnMapping) {
        this.lnSnMapping = new HashMap<ObisCode, SnObjectInfo>();
        for (SnObjectInfo snObjectInfo : lnSnMapping) {
            this.lnSnMapping.put(snObjectInfo.getInstanceId(), snObjectInfo);
        }
        this.setReferencingMethod(ReferencingMethod.SHORT);
        return this.self();
    }

    public T setSnClassInfo(Collection<SnClassInfo> snClassInfos) {
        for (SnClassInfo snClassInfo : snClassInfos) {
            this.snClassInfos.put(snClassInfo.getSnClassVersion(), snClassInfo);
        }
        this.setReferencingMethod(ReferencingMethod.SHORT);
        return this.self();
    }

    public T setReferencingMethod(ReferencingMethod referencingMethod) {
        this.referencingMethod = referencingMethod;
        return this.self();
    }

    public void setHdlcMaxInformationLength(int hdlcMaxInformationLength) {
        this.hdlcMaxInformationLength = hdlcMaxInformationLength;
    }

    public T setAlwaysSendSecurityMechanismName(boolean alwaysSendSecurityMechanismName) {
        this.alwaysSendSecurityMechanismName = alwaysSendSecurityMechanismName;
        return this.self();
    }

    public T setSkipAARQEncryption(boolean skipAARQEncryption) {
        this.skipAARQEncryption = skipAARQEncryption;
        return this.self();
    }

    public T setSecuritySuite(SecuritySuite securitySuite) {
        this.securitySuite = securitySuite;
        return this.self();
    }

    public T setClientId(int clientId) {
        this.clientId = clientId;
        return this.self();
    }

    public T setUserId(int userId) {
        this.userId = userId;
        return this.self();
    }

    public T setLogicalDeviceId(int logicalDeviceId) {
        this.logicalDeviceId = logicalDeviceId;
        return this.self();
    }

    public T setChallengeLength(int challengeLength) {
        int minLength = 8;
        int maxLength = 64;
        if (challengeLength < 8 || challengeLength > 64) {
            String msg = MessageFormat.format("Challenge length has to be between {0} and {1}.", 8, 64);
            throw new IllegalArgumentException(msg);
        }
        this.challengeLength = challengeLength;
        return this.self();
    }

    public T setFrameCounter(long frameCounter) {
        long minVal = 0L;
        long maxVal = 0xFFFFFFFFL;
        if (frameCounter < 0L || frameCounter > 0xFFFFFFFFL) {
            String msg = MessageFormat.format("Frame counter value has to be between {0} and {1}.", 0L, 0xFFFFFFFFL);
            throw new IllegalArgumentException(msg);
        }
        this.frameCounter = frameCounter;
        return this.self();
    }

    public T setPhysicalDeviceAddress(int physicalDeviceAddress) {
        this.physicalDeviceId = physicalDeviceAddress;
        return this.self();
    }

    public T setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this.self();
    }

    public T setSystemTitle(String manufacturerId, long deviceId) {
        this.systemTitle = new byte[8];
        byte[] manufacturerIdBytes = manufacturerId.getBytes(StandardCharsets.US_ASCII);
        System.arraycopy(manufacturerIdBytes, 0, this.systemTitle, 0, 3);
        for (int i = 0; i < 5; ++i) {
            this.systemTitle[3 + i] = (byte)(deviceId >> (4 - i) * 8 & 0xFFL);
        }
        return this.self();
    }

    public T setRawMessageListener(RawMessageListener rawMessageListener) {
        this.rawMessageListener = rawMessageListener;
        return this.self();
    }

    public DlmsConnection build() throws IOException {
        Settings settings = this.buildSettings();
        SessionLayer sessionLayer = this.buildSessionLayer(settings);
        LnConnectionWrapper connection = settings.referencingMethod() == ReferencingMethod.LOGICAL ? new DlmsLnConnectionWrapper(settings, sessionLayer) : new DlmsLnToSnConnectionWrapper(settings, sessionLayer, this.lnSnMapping, this.snClassInfos);
        try {
            connection.connect();
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        return connection;
    }

    public DlmsSnConnection buildSnConnection() throws IOException {
        this.setReferencingMethod(ReferencingMethod.SHORT);
        Settings settings = this.buildSettings();
        SessionLayer sessionLayer = this.buildSessionLayer(settings);
        DlmsSnConnectionImpl connectionImpl = new DlmsSnConnectionImpl(settings, sessionLayer);
        connectionImpl.connect();
        return connectionImpl;
    }

    protected abstract Settings buildSettings();

    protected abstract <S extends Settings> SessionLayer buildSessionLayer(S var1) throws IOException;

    T self() {
        return (T)this;
    }

    protected abstract class SettingsImpl
    implements Settings {
        private final byte[] systemTitle;
        private final int challengeLength;
        private final long frameCounter;
        private final int responseTimeout;
        private final int clientAccessPoint;
        private final int userId;
        private final int logicalDeviceAddress;
        private final SecuritySuite securitySuite;
        private final int physicalDeviceId;
        private final ReferencingMethod referencingMethod;
        private final RawMessageListener rawMessageListener;
        private final int hdlcMaxInformationLength;
        private final boolean alwaysSendSecurityMechanismName;
        private final boolean skipAARQEncryption;

        public SettingsImpl(ConnectionBuilder<?> builder) {
            this.systemTitle = ((ConnectionBuilder)builder).systemTitle;
            this.challengeLength = ((ConnectionBuilder)builder).challengeLength;
            this.frameCounter = ((ConnectionBuilder)builder).frameCounter;
            this.responseTimeout = ((ConnectionBuilder)builder).responseTimeout;
            this.clientAccessPoint = ((ConnectionBuilder)builder).clientId;
            this.userId = ((ConnectionBuilder)builder).userId;
            this.logicalDeviceAddress = ((ConnectionBuilder)builder).logicalDeviceId;
            this.securitySuite = ((ConnectionBuilder)builder).securitySuite;
            this.physicalDeviceId = ((ConnectionBuilder)builder).physicalDeviceId;
            this.referencingMethod = ((ConnectionBuilder)builder).referencingMethod;
            this.rawMessageListener = ((ConnectionBuilder)builder).rawMessageListener;
            this.hdlcMaxInformationLength = ((ConnectionBuilder)builder).hdlcMaxInformationLength;
            this.alwaysSendSecurityMechanismName = ((ConnectionBuilder)builder).alwaysSendSecurityMechanismName;
            this.skipAARQEncryption = ((ConnectionBuilder)builder).skipAARQEncryption;
        }

        @Override
        public ReferencingMethod referencingMethod() {
            return this.referencingMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SecuritySuite securitySuite() {
            SecuritySuite securitySuite = this.securitySuite;
            synchronized (securitySuite) {
                return this.securitySuite;
            }
        }

        @Override
        public int challengeLength() {
            return this.challengeLength;
        }

        @Override
        public long frameCounter() {
            return this.frameCounter;
        }

        @Override
        public byte[] systemTitle() {
            return this.systemTitle;
        }

        @Override
        public int responseTimeout() {
            return this.responseTimeout;
        }

        @Override
        public int logicalDeviceId() {
            return this.logicalDeviceAddress;
        }

        @Override
        public int physicalDeviceId() {
            return this.physicalDeviceId;
        }

        @Override
        public int clientId() {
            return this.clientAccessPoint;
        }

        @Override
        public int userId() {
            return this.userId;
        }

        @Override
        public RawMessageListener rawMessageListener() {
            return this.rawMessageListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateAuthenticationKey(byte[] authenticationKey) {
            SecuritySuite securitySuite = this.securitySuite;
            synchronized (securitySuite) {
                ((SecSuiteAccessor)((Object)this.securitySuite)).updateAuthentciationKey(authenticationKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateGlobalEncryptionKey(byte[] globalEncryptionKey) {
            SecuritySuite securitySuite = this.securitySuite;
            synchronized (securitySuite) {
                ((SecSuiteAccessor)((Object)this.securitySuite)).updateGlobalUnicastEncryptionKey(globalEncryptionKey);
            }
        }

        @Override
        public int hdlcMaxInformationLength() {
            return this.hdlcMaxInformationLength;
        }

        @Override
        public boolean alwaysSendSecurityMechanismName() {
            return this.alwaysSendSecurityMechanismName;
        }

        @Override
        public boolean skipAARQEncryption() {
            return this.skipAARQEncryption;
        }
    }
}

