/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms;

import java.text.MessageFormat;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.GetResult;
import org.openmuc.jdlms.ReadResult;
import org.openmuc.jdlms.datatypes.DataObject;

class AccessResultImpl
implements GetResult,
ReadResult {
    private final DataObject resultData;
    private final AccessResultCode resultCode;

    AccessResultImpl(DataObject resultData) {
        this(resultData, AccessResultCode.SUCCESS);
    }

    AccessResultImpl(AccessResultCode errorCode) {
        this(null, errorCode);
    }

    private AccessResultImpl(DataObject resultData, AccessResultCode resultCode) {
        this.resultData = resultData;
        this.resultCode = resultCode;
    }

    @Override
    public DataObject getResultData() {
        return this.resultData;
    }

    @Override
    public AccessResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public boolean requestSuccessful() {
        return this.getResultCode() == AccessResultCode.SUCCESS;
    }

    public String toString() {
        return MessageFormat.format("'{'code: {0}({1}), data: '{'{2}'}}'", this.resultCode, this.resultCode.getCode(), this.resultData);
    }
}

