/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plate;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.WellSample;
import ome.xml.model.WellSampleRef;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlateAcquisition
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(PlateAcquisition.class);
    private String id;
    private String name;
    private Timestamp endTime;
    private Timestamp startTime;
    private PositiveInteger maximumFieldCount;
    private String description;
    private List<WellSample> wellSamples = new ReferenceList<WellSample>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Plate plate;

    public PlateAcquisition() {
    }

    public PlateAcquisition(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public PlateAcquisition(PlateAcquisition orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.endTime = orig.endTime;
        this.startTime = orig.startTime;
        this.maximumFieldCount = orig.maximumFieldCount;
        this.description = orig.description;
        this.wellSamples = orig.wellSamples;
        this.annotationLinks = orig.annotationLinks;
        this.plate = orig.plate;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("PlateAcquisition missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (element.hasAttribute("EndTime")) {
            this.setEndTime(Timestamp.valueOf(element.getAttribute("EndTime")));
        }
        if (element.hasAttribute("StartTime")) {
            this.setStartTime(Timestamp.valueOf(element.getAttribute("StartTime")));
        }
        if (element.hasAttribute("MaximumFieldCount")) {
            this.setMaximumFieldCount(PositiveInteger.valueOf(element.getAttribute("MaximumFieldCount")));
        }
        if ((Description_nodeList = PlateAcquisition.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> WellSampleRef_nodeList = PlateAcquisition.getChildrenByTagName(element, "WellSampleRef");
        for (Element WellSampleRef_element : WellSampleRef_nodeList) {
            WellSampleRef wellSamples_reference = new WellSampleRef();
            wellSamples_reference.setID(WellSampleRef_element.getAttribute("ID"));
            model.addReference(this, wellSamples_reference);
        }
        List<Element> AnnotationRef_nodeList = PlateAcquisition.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof WellSampleRef) {
            WellSample o_casted = (WellSample)o;
            o_casted.linkPlateAcquisition(this);
            this.wellSamples.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPlateAcquisition(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public PositiveInteger getMaximumFieldCount() {
        return this.maximumFieldCount;
    }

    public void setMaximumFieldCount(PositiveInteger maximumFieldCount) {
        this.maximumFieldCount = maximumFieldCount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedWellSampleList() {
        return this.wellSamples.size();
    }

    public List<WellSample> copyLinkedWellSampleList() {
        return new ArrayList<WellSample>(this.wellSamples);
    }

    public WellSample getLinkedWellSample(int index) {
        return this.wellSamples.get(index);
    }

    public WellSample setLinkedWellSample(int index, WellSample o) {
        return this.wellSamples.set(index, o);
    }

    public boolean linkWellSample(WellSample o) {
        o.linkPlateAcquisition(this);
        return this.wellSamples.add(o);
    }

    public boolean unlinkWellSample(WellSample o) {
        o.unlinkPlateAcquisition(this);
        return this.wellSamples.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPlateAcquisition(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPlateAcquisition(this);
        return this.annotationLinks.remove(o);
    }

    public Plate getPlate() {
        return this.plate;
    }

    public void setPlate(Plate plate_BackReference) {
        this.plate = plate_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element PlateAcquisition_element) {
        Element child;
        Reference o;
        if (PlateAcquisition_element == null) {
            PlateAcquisition_element = document.createElementNS(NAMESPACE, "PlateAcquisition");
        }
        super.asXMLElement(document, PlateAcquisition_element);
        if (this.id != null) {
            PlateAcquisition_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            PlateAcquisition_element.setAttribute("Name", this.name.toString());
        }
        if (this.endTime != null) {
            PlateAcquisition_element.setAttribute("EndTime", this.endTime.toString());
        }
        if (this.startTime != null) {
            PlateAcquisition_element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.maximumFieldCount != null) {
            PlateAcquisition_element.setAttribute("MaximumFieldCount", this.maximumFieldCount.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            PlateAcquisition_element.appendChild(description_element);
        }
        if (this.wellSamples != null) {
            for (WellSample wellSamples_value : this.wellSamples) {
                o = new WellSampleRef();
                ((WellSampleRef)o).setID(wellSamples_value.getID());
                child = document.createElementNS(NAMESPACE, "WellSampleRef");
                ((WellSampleRef)o).asXMLElement(document, child);
                PlateAcquisition_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "AnnotationRef");
                ((AnnotationRef)o).asXMLElement(document, child);
                PlateAcquisition_element.appendChild(child);
            }
        }
        if (this.plate != null) {
            // empty if block
        }
        return PlateAcquisition_element;
    }
}

