/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.dev;

import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.poi.hssf.model.FormulaParser;
import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.FormulaRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFactory;
import loci.poi.hssf.record.formula.ExpPtg;
import loci.poi.hssf.record.formula.FuncPtg;
import loci.poi.hssf.record.formula.OperationPtg;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.poifs.filesystem.POIFSFileSystem;

public class FormulaViewer {
    private String file;
    private boolean list = false;

    public void run() throws Exception {
        POIFSFileSystem fs = new POIFSFileSystem(new RandomAccessInputStream(this.file), 512);
        List records = RecordFactory.createRecords(fs.createDocumentInputStream("Workbook"));
        for (int k = 0; k < records.size(); ++k) {
            Record record = (Record)records.get(k);
            if (record.getSid() != 6) continue;
            if (this.list) {
                this.listFormula((FormulaRecord)record);
                continue;
            }
            this.parseFormulaRecord((FormulaRecord)record);
        }
    }

    private void listFormula(FormulaRecord record) {
        String sep = "~";
        List tokens = record.getParsedExpression();
        int numptgs = record.getNumberOfExpressionTokens();
        Ptg token = null;
        if (tokens != null) {
            token = (Ptg)tokens.get(numptgs - 1);
            String numArg = token instanceof FuncPtg ? String.valueOf(numptgs - 1) : String.valueOf(-1);
            StringBuffer buf = new StringBuffer();
            if (token instanceof ExpPtg) {
                return;
            }
            String name = ((OperationPtg)token).toFormulaString((Workbook)null);
            buf.append(name);
            buf.append(sep);
            switch (token.getPtgClass()) {
                case 0: {
                    buf.append("REF");
                    break;
                }
                case 32: {
                    buf.append("VALUE");
                    break;
                }
                case 64: {
                    buf.append("ARRAY");
                }
            }
            buf.append(sep);
            if (numptgs > 1) {
                token = (Ptg)tokens.get(numptgs - 2);
                switch (token.getPtgClass()) {
                    case 0: {
                        buf.append("REF");
                        break;
                    }
                    case 32: {
                        buf.append("VALUE");
                        break;
                    }
                    case 64: {
                        buf.append("ARRAY");
                    }
                }
            } else {
                buf.append("VALUE");
            }
            buf.append(sep);
            buf.append(numArg);
            System.out.println(buf.toString());
        } else {
            System.out.println("#NAME");
        }
    }

    public void parseFormulaRecord(FormulaRecord record) {
        System.out.println("==============================");
        System.out.print("row = " + record.getRow());
        System.out.println(", col = " + record.getColumn());
        System.out.println("value = " + record.getValue());
        System.out.print("xf = " + record.getXFIndex());
        System.out.print(", number of ptgs = " + record.getNumberOfExpressionTokens());
        System.out.println(", options = " + record.getOptions());
        System.out.println("RPN List = " + this.formulaString(record));
        System.out.println("Formula text = " + this.composeFormula(record));
    }

    private String formulaString(FormulaRecord record) {
        StringBuffer formula = new StringBuffer("=");
        int numptgs = record.getNumberOfExpressionTokens();
        List tokens = record.getParsedExpression();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numptgs; ++i) {
            Ptg token = (Ptg)tokens.get(i);
            buf.append(token.toFormulaString(null));
            switch (token.getPtgClass()) {
                case 0: {
                    buf.append("(R)");
                    break;
                }
                case 32: {
                    buf.append("(V)");
                    break;
                }
                case 64: {
                    buf.append("(A)");
                }
            }
            buf.append(' ');
        }
        return buf.toString();
    }

    private String composeFormula(FormulaRecord record) {
        return FormulaParser.toFormulaString((Workbook)null, record.getParsedExpression());
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public static void main(String[] args) {
        if (args == null || args.length > 2 || args[0].equals("--help")) {
            System.out.println("FormulaViewer .8 proof that the devil lies in the details (or just in BIFF8 files in general)");
            System.out.println("usage: Give me a big fat file name");
        } else if (args[0].equals("--listFunctions")) {
            try {
                FormulaViewer viewer = new FormulaViewer();
                viewer.setFile(args[1]);
                viewer.setList(true);
                viewer.run();
            }
            catch (Exception e) {
                System.out.println("Whoops!");
                e.printStackTrace();
            }
        } else {
            try {
                FormulaViewer viewer = new FormulaViewer();
                viewer.setFile(args[0]);
                viewer.run();
            }
            catch (Exception e) {
                System.out.println("Whoops!");
                e.printStackTrace();
            }
        }
    }
}

