/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.LosslessJPEGCodec;
import ome.codecs.gui.AWTImageTools;

public class JPEGCodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        if (data == null || data.length == 0) {
            return data;
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (options.bitsPerSample > 8) {
            throw new CodecException("> 8 bit data cannot be compressed with JPEG.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = AWTImageTools.makeImage(data, options.width, options.height, options.channels, options.interleaved, options.bitsPerSample / 8, false, options.littleEndian, options.signed);
        try {
            ImageIO.write((RenderedImage)img, "jpeg", out);
        }
        catch (IOException e) {
            throw new CodecException("Could not write JPEG data", e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        int i;
        DataBufferByte bb;
        BufferedImage b;
        long fp = in.getFilePointer();
        try {
            try {
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
            }
            catch (EOFException e) {
                in.seek(fp);
            }
            b = ImageIO.read(new BufferedInputStream(new DataInputStream((InputStream)in), 81920));
        }
        catch (IOException exc) {
            in.seek(fp);
            return new LosslessJPEGCodec().decompress(in, options);
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        int nPixels = b.getWidth() * b.getHeight();
        WritableRaster r = b.getRaster();
        if (!options.ycbcr && r.getDataBuffer() instanceof DataBufferByte && b.getType() == 10 && (bb = (DataBufferByte)r.getDataBuffer()).getNumBanks() == 1) {
            byte[] raw = bb.getData();
            if (options.interleaved || bb.getSize() == nPixels) {
                return raw;
            }
        }
        byte[][] buf = AWTImageTools.getPixelBytes(b, options.littleEndian);
        if (options.ycbcr && buf.length == 3) {
            int nBytes = buf[0].length / (b.getWidth() * b.getHeight());
            int mask = (int)(Math.pow(2.0, nBytes * 8) - 1.0);
            for (i = 0; i < buf[0].length; i += nBytes) {
                double y = DataTools.bytesToInt((byte[])buf[0], (int)i, (int)nBytes, (boolean)options.littleEndian);
                double cb = DataTools.bytesToInt((byte[])buf[1], (int)i, (int)nBytes, (boolean)options.littleEndian);
                double cr = DataTools.bytesToInt((byte[])buf[2], (int)i, (int)nBytes, (boolean)options.littleEndian);
                cb = Math.max(0.0, cb - 128.0);
                cr = Math.max(0.0, cr - 128.0);
                int red = (int)(y + 1.402 * cr);
                int green = (int)(y - 0.34414 * cb - 0.71414 * cr);
                int blue = (int)(y + 1.772 * cb);
                red = Math.min(red, mask) & mask;
                green = Math.min(green, mask) & mask;
                blue = Math.min(blue, mask) & mask;
                DataTools.unpackBytes((long)red, (byte[])buf[0], (int)i, (int)nBytes, (boolean)options.littleEndian);
                DataTools.unpackBytes((long)green, (byte[])buf[1], (int)i, (int)nBytes, (boolean)options.littleEndian);
                DataTools.unpackBytes((long)blue, (byte[])buf[2], (int)i, (int)nBytes, (boolean)options.littleEndian);
            }
        }
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else if (options.interleaved) {
            int next = 0;
            for (i = 0; i < buf[0].length; ++i) {
                for (int j = 0; j < buf.length; ++j) {
                    rtn[next++] = buf[j][i];
                }
            }
        } else {
            for (int i2 = 0; i2 < buf.length; ++i2) {
                System.arraycopy(buf[i2], 0, rtn, i2 * buf[0].length, buf[i2].length);
            }
        }
        return rtn;
    }
}

