/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.simple;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.openl.binding.MethodUtil;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceRedeployLock;
import org.openl.rules.ruleservice.core.RuleServiceWrapperException;
import org.openl.rules.ruleservice.simple.MethodInvocationException;
import org.openl.rules.ruleservice.simple.RulesFrontend;
import org.openl.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesFrontendImpl
implements RulesFrontend {
    private final Logger log = LoggerFactory.getLogger(RulesFrontendImpl.class);
    private final Map<String, OpenLService> runningServices = new ConcurrentHashMap<String, OpenLService>();

    @Override
    public void registerService(OpenLService service) {
        Objects.requireNonNull(service, "service cannot be null");
        OpenLService replacedService = this.runningServices.put(service.getName(), service);
        if (replacedService != null) {
            this.log.warn("Service '{}' is already registered. Replaced with new service bean.", (Object)service.getName());
        }
    }

    @Override
    public void unregisterService(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName cannot be null");
        this.runningServices.remove(serviceName);
    }

    @Override
    public Collection<String> getServiceNames() {
        return new ArrayList<String>(this.runningServices.keySet());
    }

    @Override
    public Collection<OpenLService> getServices() {
        return this.runningServices.values();
    }

    @Override
    public OpenLService findServiceByName(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName cannot be null");
        return this.getService(serviceName);
    }

    @Override
    public Object execute(String serviceName, String ruleName, Class<?>[] inputParamsTypes, Object[] params) throws MethodInvocationException {
        Objects.requireNonNull(serviceName, "serviceName cannot be null");
        Objects.requireNonNull(ruleName, "ruleName cannot be null");
        OpenLService service = this.getService(serviceName);
        if (service == null) {
            throw new MethodInvocationException(String.format("Service '%s' is not found.", serviceName));
        }
        try {
            if (service.getServiceBean() != null) {
                Method serviceMethod = MethodUtil.getMatchingAccessibleMethod(service.getServiceBean().getClass(), (String)ruleName, (Class[])inputParamsTypes);
                if (serviceMethod == null) {
                    StringBuilder sb = new StringBuilder();
                    boolean f = true;
                    for (Class<?> param : inputParamsTypes) {
                        if (!f) {
                            sb.append(",");
                        } else {
                            f = false;
                        }
                        sb.append(param != null ? param.getTypeName() : "null-class");
                    }
                    throw new MethodInvocationException(String.format("Method '%s(%s)' is not found in service '%s'.", ruleName, sb, serviceName));
                }
                try {
                    return serviceMethod.invoke(service.getServiceBean(), params);
                }
                catch (IllegalAccessException e) {
                    throw new InternalError(e.toString());
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    throw new MethodInvocationException(t.toString(), t);
                }
            }
            throw new MethodInvocationException(String.format("Service initialization '%s' has been failed.", serviceName), service.getException());
        }
        catch (RuleServiceInstantiationException e) {
            throw new MethodInvocationException(String.format("Service initialization '%s' has been failed.", serviceName), (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenLService getService(String serviceName) {
        Lock lock = RuleServiceRedeployLock.getInstance().getReadLock();
        try {
            lock.lock();
            OpenLService openLService = this.runningServices.get(serviceName);
            return openLService;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object execute(String serviceName, String ruleName, Object ... params) throws MethodInvocationException {
        Objects.requireNonNull(serviceName, "serviceName cannot be null");
        Objects.requireNonNull(ruleName, "ruleName cannot be null");
        this.log.debug("Executing rule from service with name='{}', ruleName='{}'.", (Object)serviceName, (Object)ruleName);
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i] != null ? params[i].getClass() : null;
        }
        return this.execute(serviceName, ruleName, paramTypes, params);
    }

    @Override
    public Object getValue(String serviceName, String fieldName) throws MethodInvocationException {
        Objects.requireNonNull(serviceName, "serviceName cannot be null");
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        this.log.debug("Getting value from service with name='{}', fieldName='{}'.", (Object)serviceName, (Object)fieldName);
        Object result = null;
        OpenLService service = this.getService(serviceName);
        if (service != null) {
            try {
                Method serviceMethod = service.getServiceBean().getClass().getMethod(ClassUtils.getter((String)fieldName), new Class[0]);
                result = serviceMethod.invoke(service.getServiceBean(), new Object[0]);
            }
            catch (Exception e) {
                if (e.getCause() instanceof RuleServiceWrapperException) {
                    throw new MethodInvocationException(e.getCause());
                }
                this.log.warn("Error on reading field '{}' from the service '{}'.", new Object[]{fieldName, serviceName, e});
            }
        } else {
            throw new MethodInvocationException(String.format("Service '%s' is not found.", serviceName));
        }
        return result;
    }
}

