/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.simple;

import org.openl.rules.ruleservice.simple.MethodInvocationException;
import org.openl.rules.ruleservice.simple.MethodInvocationRuntimeException;
import org.openl.rules.ruleservice.simple.RulesFrontend;
import org.openl.runtime.ASMProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class OpenLServiceFactoryBean<T>
implements FactoryBean<T> {
    private Class<T> proxyInterface;
    private String serviceName;
    private ClassLoader classLoader;
    private RulesFrontend rulesFrontend;

    public OpenLServiceFactoryBean(Class<T> proxyInterface, String serviceName) {
        this.proxyInterface = proxyInterface;
        this.serviceName = serviceName;
    }

    public T getObject() {
        ClassLoader cl = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        return (T)ASMProxyFactory.newProxyInstance((ClassLoader)cl, (method, args) -> {
            try {
                return this.rulesFrontend.execute(this.serviceName, method.getName(), method.getParameterTypes(), args);
            }
            catch (MethodInvocationException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new MethodInvocationRuntimeException((Throwable)((Object)e));
            }
        }, this.proxyInterface);
    }

    public Class<?> getObjectType() {
        return this.proxyInterface;
    }

    public boolean isSingleton() {
        return Boolean.TRUE;
    }

    @Autowired
    @Qualifier(value="frontend")
    public void setRulesFrontend(RulesFrontend rulesFrontend) {
        this.rulesFrontend = rulesFrontend;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Deprecated
    public OpenLServiceFactoryBean() {
    }

    @Deprecated
    public void setProxyInterface(Class<T> proxyInterface) {
        this.proxyInterface = proxyInterface;
    }

    @Deprecated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

