/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ServiceInfo {
    private final Date startedTime;
    private final String name;
    private final String servicePath;
    private final Map<String, String> urls = new HashMap<String, String>(1);
    private final boolean hasManifest;
    private final String deploymentName;
    private final ServiceStatus status;

    public ServiceInfo(Date startedTime, String name, boolean failed, Map<String, String> urls, String servicePath, boolean hasManifest, String deploymentName) {
        this.startedTime = Objects.requireNonNull(startedTime, "startedTime cannot be null");
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.status = failed ? ServiceStatus.FAILED : ServiceStatus.DEPLOYED;
        this.servicePath = servicePath;
        this.urls.putAll(urls);
        this.hasManifest = hasManifest;
        this.deploymentName = deploymentName;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartedTime() {
        return this.startedTime;
    }

    public Map<String, String> getUrls() {
        return this.urls;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    public boolean getHasManifest() {
        return this.hasManifest;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public static enum ServiceStatus {
        DEPLOYED,
        FAILED;

    }
}

