/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.PreDestroy;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectException;
import org.openl.rules.common.impl.CommonVersionImpl;
import org.openl.rules.deploy.LocalDeployment;
import org.openl.rules.deploy.LocalProject;
import org.openl.rules.deploy.LocalProjectResource;
import org.openl.rules.project.abstraction.AProjectArtefact;
import org.openl.rules.project.abstraction.Deployment;
import org.openl.rules.project.abstraction.IDeployment;
import org.openl.rules.project.abstraction.IProject;
import org.openl.rules.project.abstraction.IProjectArtefact;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolver;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.file.FileSystemRepository;
import org.openl.rules.repository.zip.ZippedLocalRepository;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.loader.DataSourceListener;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.util.FileTypeHelper;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringUtils;
import org.openl.util.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileSystemUtils;

public class RuleServiceLoaderImpl
implements RuleServiceLoader {
    private static final Pattern NOT_ALLOWED_SYMBOLS = Pattern.compile("[^[-.\\w]]");
    private final Logger log = LoggerFactory.getLogger(RuleServiceLoaderImpl.class);
    private final ProjectResolver projectResolver;
    private final Repository repository;
    private final FileSystemRepository tempRepo;
    private final Path tempPath = Files.createTempDirectory("rules-deploy_", new FileAttribute[0]);
    private String deployPath = "";

    public RuleServiceLoaderImpl(Repository repository) throws IOException {
        this.log.info("Local temporary folder location is: {}", (Object)this.tempPath);
        this.tempRepo = new FileSystemRepository();
        this.tempRepo.setUri(this.tempPath.toString());
        this.tempRepo.initialize();
        this.projectResolver = ProjectResolver.getInstance();
        this.repository = repository;
    }

    @Override
    public ProjectDescriptor resolveProject(String deploymentName, CommonVersion deploymentVersion, String projectName) throws ProjectResolvingException {
        Path projectFolder;
        Objects.requireNonNull(deploymentName, "deploymentName cannot be null");
        Objects.requireNonNull(deploymentVersion, "deploymentVersion cannot be null");
        Objects.requireNonNull(projectName, "projectName cannot be null");
        this.log.debug("Resolving modules for deployment (name='{}', version='{}', projectName='{}')", new Object[]{deploymentName, deploymentVersion.getVersionName(), projectName});
        IDeployment localDeployment = this.getDeployment(deploymentName, deploymentVersion);
        IProject project = localDeployment.getProject(projectName);
        if (project == null) {
            throw new RuleServiceRuntimeException(String.format("Project '%s' is not found in deployment '%s'.", projectName, deploymentName));
        }
        if (project instanceof LocalProject) {
            projectFolder = ((LocalProject)project).getData().getPath();
            if (projectFolder.getFileName() != null && (FileTypeHelper.isZipFile((String)projectFolder.getFileName().toString()) || ZippedLocalRepository.zipArchiveFilter((Path)projectFolder))) {
                FileSystem fs = FileSystems.getFileSystem(ZipUtils.toJarURI((Path)projectFolder));
                projectFolder = fs.getPath("/", new String[0]);
            }
        } else {
            String stringValue = project.getArtefactPath().getStringValue();
            projectFolder = this.tempPath.resolve(stringValue);
        }
        return this.projectResolver.resolve(projectFolder);
    }

    @Override
    public IDeployment getDeployment(String deploymentName, CommonVersion version) {
        String versionName;
        Deployment loadedDeployment;
        if (this.repository.supports().isLocal() && this.repository.supports().folders()) {
            try {
                FileData data = this.repository.check(this.getDeployPath() + deploymentName);
                if (data != null && data.getPath() != null) {
                    return this.buildLocalDeployment(version, data, this.repository);
                }
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
        if ((loadedDeployment = new Deployment((Repository)this.tempRepo, deploymentName + "_v" + RuleServiceLoaderImpl.cleanUp(versionName = version.getVersionName()), deploymentName, version, true)).getProjects().isEmpty()) {
            this.log.debug("Loading deployment with name='{}' and version='{}'", (Object)deploymentName, (Object)versionName);
            String folderPath = this.getDeployPath() + deploymentName;
            boolean folderStructure = this.isFolderStructure(folderPath);
            Deployment deployment = new Deployment(this.repository, folderPath, deploymentName, version, folderStructure);
            try {
                loadedDeployment.update((AProjectArtefact)deployment, null);
                loadedDeployment.refresh();
            }
            catch (ProjectException e) {
                this.log.warn("Exception occurs on loading deployment with name='{}' and version='{}' from data source.", new Object[]{deploymentName, versionName, e});
                throw new RuleServiceRuntimeException((Throwable)e);
            }
        }
        return loadedDeployment;
    }

    @Override
    public Collection<IDeployment> getDeployments() {
        List fileData;
        try {
            fileData = this.repository.supports().folders() ? this.repository.listFolders(this.getDeployPath()) : this.repository.list(this.getDeployPath());
        }
        catch (IOException ex) {
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
        ConcurrentHashMap<String, LocalDeployment> deployments = new ConcurrentHashMap<String, LocalDeployment>();
        for (FileData fd : fileData) {
            LocalDeployment deployment;
            String name = fd.getName();
            String deployFolder = this.getDeployPath();
            String deploymentPath = name.substring(deployFolder.length());
            String[] pathEntries = deploymentPath.split("/");
            String deploymentFolderName = pathEntries[0];
            String version = fd.getVersion();
            CommonVersionImpl commonVersion = new CommonVersionImpl(version == null ? "0" : version);
            String folderPath = this.getDeployPath() + deploymentFolderName;
            if (this.isLocalZipFile(fd)) {
                try {
                    deployment = this.buildLocalDeployment((CommonVersion)commonVersion, fd, this.repository);
                }
                catch (IOException e) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)e);
                }
            } else {
                boolean folderStructure = this.isFolderStructure(folderPath);
                deployment = new Deployment(this.repository, folderPath, deploymentFolderName, (CommonVersion)commonVersion, folderStructure);
            }
            deployments.putIfAbsent(deploymentFolderName, deployment);
        }
        return deployments.values();
    }

    private boolean isLocalZipFile(FileData fileData) {
        return this.repository.supports().folders() && this.repository.supports().isLocal() && fileData.getPath() != null && (FileTypeHelper.isZipFile((String)fileData.getPath().getFileName().toString()) || ZippedLocalRepository.zipArchiveFilter((Path)fileData.getPath()));
    }

    private boolean isSimpleProjectDeployment(FileData fileData) {
        URI jarURI = ZipUtils.toJarURI((Path)fileData.getPath());
        try {
            Path zipRoot = FileSystems.getFileSystem(jarURI).getPath("/", new String[0]);
            return this.projectResolver.isRulesProject(zipRoot) != null;
        }
        catch (FileSystemNotFoundException ignored) {
            boolean bl;
            block10: {
                FileSystem fs = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                try {
                    boolean bl2 = bl = this.projectResolver.isRulesProject(fs.getPath("/", new String[0])) != null;
                    if (fs == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | UnsupportedOperationException | ProviderNotFoundException e) {
                        return false;
                    }
                }
                fs.close();
            }
            return bl;
        }
    }

    private LocalDeployment buildLocalDeployment(CommonVersion commonVersion, FileData deploymentFolder, Repository repository) throws IOException {
        LocalDeployment deployment;
        if (this.isSimpleProjectDeployment(deploymentFolder)) {
            Map<String, IProjectArtefact> resourceMap = this.gatherProjectResources(deploymentFolder, repository);
            LocalProject project = new LocalProject(deploymentFolder, resourceMap);
            deployment = new LocalDeployment(deploymentFolder.getName().split("/")[0], commonVersion, Collections.singletonMap(project.getName(), project));
        } else {
            List projectFolders = repository.listFolders(this.getDeployPath() + deploymentFolder.getName());
            HashMap<String, LocalProject> projectMap = new HashMap<String, LocalProject>();
            for (FileData projectFolder : projectFolders) {
                Map<String, IProjectArtefact> resourceMap = this.gatherProjectResources(projectFolder, repository);
                LocalProject project = new LocalProject(projectFolder, resourceMap);
                projectMap.put(project.getName(), project);
            }
            deployment = new LocalDeployment(deploymentFolder.getName().split("/")[0], commonVersion, projectMap);
        }
        return deployment;
    }

    private Map<String, IProjectArtefact> gatherProjectResources(FileData folder, Repository repository) throws IOException {
        List files = repository.list(this.getDeployPath() + folder.getName());
        HashMap<String, IProjectArtefact> resourceMap = new HashMap<String, IProjectArtefact>();
        for (FileData file : files) {
            String resourceName = file.getName().substring(folder.getName().length() + 1);
            LocalProjectResource resource = new LocalProjectResource(resourceName, repository.read(file.getName()));
            resourceMap.put(resource.getName(), (IProjectArtefact)resource);
        }
        return resourceMap;
    }

    @Override
    public void setListener(DataSourceListener dataSourceListener) {
        if (dataSourceListener == null) {
            this.repository.setListener(null);
        } else {
            this.repository.setListener(dataSourceListener::onDeploymentAdded);
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.log.debug("Data source releasing");
        if (this.repository instanceof Closeable) {
            ((Closeable)this.repository).close();
        }
        this.tempRepo.close();
        try {
            FileSystemUtils.deleteRecursively((Path)this.tempPath);
        }
        catch (Exception e) {
            this.log.error("Cannot delete temporary directory", (Throwable)e);
        }
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath.isEmpty() || deployPath.endsWith("/") ? deployPath : deployPath + "/";
    }

    private boolean isFolderStructure(String deploymentFolderPath) {
        boolean folderStructure;
        try {
            folderStructure = this.repository.supports().folders() ? !this.repository.listFolders(deploymentFolderPath + "/").isEmpty() : false;
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        return folderStructure;
    }

    private String getDeployPath() {
        if (this.repository.supports().isLocal()) {
            return "";
        }
        return this.deployPath;
    }

    @Override
    public String getLogicalProjectFolder(String realFolderPath) {
        if (StringUtils.isBlank((CharSequence)realFolderPath) || this.repository.supports().isLocal()) {
            return realFolderPath;
        }
        String baseDeployFolder = this.getDeployPath();
        if (!realFolderPath.startsWith(baseDeployFolder)) {
            return realFolderPath;
        }
        return realFolderPath.substring(baseDeployFolder.length());
    }

    @Override
    public boolean isReady() {
        try {
            this.repository.validateConnection();
            return true;
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static String cleanUp(String str) {
        return NOT_ALLOWED_SYMBOLS.matcher(str).replaceAll("_") + str.hashCode();
    }
}

