/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import org.openl.util.StringUtils;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public enum DeployStrategy {
    ALWAYS,
    NEVER,
    IF_ABSENT;


    public static DeployStrategy fromString(String source) {
        if ((source = StringUtils.trimToNull((String)source)) == null) {
            return NEVER;
        }
        ConversionService conversionService = DefaultConversionService.getSharedInstance();
        try {
            Boolean booleanValue = (Boolean)conversionService.convert((Object)source, Boolean.class);
            if (booleanValue != null) {
                return booleanValue != false ? IF_ABSENT : NEVER;
            }
        }
        catch (ConversionFailedException conversionFailedException) {
            // empty catch block
        }
        return (DeployStrategy)((Object)conversionService.convert((Object)source, DeployStrategy.class));
    }
}

