/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.deployer.DeploymentDescriptor;
import org.openl.rules.ruleservice.deployer.RulesDeployerService;
import org.openl.rules.ruleservice.loader.DeployStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class DeployClasspathJarsBean
implements InitializingBean,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(DeployClasspathJarsBean.class);
    private final boolean enabled;
    private final RulesDeployerService rulesDeployerService;
    private final DeployStrategy deployStrategy;
    private Queue<File> filesToDeploy = new LinkedList<File>();
    private ScheduledExecutorService scheduledPool;
    private long retryPeriod = 10L;

    public DeployClasspathJarsBean(RulesDeployerService rulesDeployerService, DeployStrategy deployStrategy, PropertyResolver propertyResolver) {
        String repositoryFactory = propertyResolver.getProperty("production-repository.factory");
        this.enabled = !"repo-jar".equals(repositoryFactory) && deployStrategy != null && deployStrategy != DeployStrategy.NEVER;
        this.rulesDeployerService = rulesDeployerService;
        this.deployStrategy = deployStrategy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setRetryPeriod(long retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    void setFilesToDeploy(Collection<File> filesToDeploy) {
        this.filesToDeploy = new LinkedList<File>(filesToDeploy);
    }

    private void deployJarForJboss(URL resourceURL) throws Exception {
        String urlString = resourceURL.toString();
        Object jarFile = new URL(urlString = urlString.substring(0, urlString.lastIndexOf(".jar") + 4)).openConnection().getContent();
        Class<?> clazz = jarFile.getClass();
        if (!"org.jboss.vfs.VirtualFile".equals(clazz.getName())) {
            throw new RuleServiceRuntimeException("Protocol VFS supports only for JBoss VFS. URL content must be org.jboss.vfs.VirtualFile.");
        }
        Method getNameMethod = clazz.getMethod("getName", new Class[0]);
        String jarName = (String)getNameMethod.invoke(jarFile, new Object[0]);
        Method getPhysicalFileMethod = clazz.getMethod("getPhysicalFile", new Class[0]);
        File contentsFile = (File)getPhysicalFileMethod.invoke(jarFile, new Object[0]);
        File dir = contentsFile.getParentFile();
        File physicalFile = new File(dir, jarName);
        this.filesToDeploy.add(physicalFile);
    }

    public void afterPropertiesSet() throws Exception {
        Resource[] archives;
        if (!this.isEnabled()) {
            return;
        }
        PathMatchingResourcePatternResolver prpr = new PathMatchingResourcePatternResolver();
        this.processResources(prpr.getResources(DeployClasspathJarsBean.createClasspathPattern("rules.xml")));
        this.processResources(prpr.getResources(DeployClasspathJarsBean.createClasspathPattern(DeploymentDescriptor.XML.getFileName())));
        this.processResources(prpr.getResources(DeployClasspathJarsBean.createClasspathPattern(DeploymentDescriptor.YAML.getFileName())));
        try {
            archives = prpr.getResources("/openl/*.zip");
        }
        catch (FileNotFoundException ignored) {
            archives = null;
        }
        if (archives != null) {
            this.processResources(archives);
        }
        this.scheduledPool = Executors.newSingleThreadScheduledExecutor();
        this.scheduledPool.scheduleWithFixedDelay(this::deployFiles, 0L, this.retryPeriod, TimeUnit.SECONDS);
    }

    private static String createClasspathPattern(String fileName) {
        return "classpath*:" + fileName;
    }

    private void processResources(Resource[] resources) throws Exception {
        for (Resource rulesXmlResource : resources) {
            File file;
            block7: {
                try {
                    URL resourceURL = rulesXmlResource.getURL();
                    if ("jar".equals(resourceURL.getProtocol()) || "wsjar".equals(resourceURL.getProtocol())) {
                        URL jarUrl = ResourceUtils.extractJarFileURL((URL)resourceURL);
                        file = ResourceUtils.getFile((URL)jarUrl);
                        break block7;
                    }
                    if ("vfs".equals(rulesXmlResource.getURL().getProtocol())) {
                        this.deployJarForJboss(resourceURL);
                        continue;
                    }
                    if ("file".equals(resourceURL.getProtocol())) {
                        file = ResourceUtils.getFile((URL)resourceURL);
                        break block7;
                    }
                    throw new RuleServiceRuntimeException("Protocol for URL is not supported! URL: " + resourceURL);
                }
                catch (Exception e) {
                    this.log.error("Failed to load a resource.", (Throwable)e);
                    throw new IOException("Failed to load a resource.", e);
                }
            }
            if (!file.exists()) {
                throw new IOException("File is not found. File: " + file.getAbsolutePath());
            }
            this.filesToDeploy.add(file);
        }
    }

    private void deployFiles() {
        if (this.filesToDeploy.isEmpty()) {
            this.scheduledPool.shutdown();
            return;
        }
        if (!this.rulesDeployerService.isReady()) {
            this.log.info("Rules deployer service is not ready. Wait {} seconds...", (Object)this.retryPeriod);
            return;
        }
        try {
            this.log.info("Deploying {} jars...", (Object)this.filesToDeploy.size());
            File file = this.filesToDeploy.peek();
            while (file != null) {
                if (Thread.currentThread().isInterrupted()) {
                    this.log.info("Deploy jars task is interrupted.");
                    return;
                }
                this.rulesDeployerService.deploy(file, this.getIgnoreIfExists());
                this.filesToDeploy.remove();
                file = this.filesToDeploy.peek();
            }
            this.log.info("All jars were deployed successfully.");
            this.scheduledPool.shutdown();
        }
        catch (IOException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            this.log.warn("Cannot to complete deploy of jars", e);
            throw e;
        }
    }

    private boolean getIgnoreIfExists() {
        if (this.deployStrategy == DeployStrategy.IF_ABSENT) {
            return false;
        }
        if (this.deployStrategy == DeployStrategy.ALWAYS) {
            return true;
        }
        throw new IllegalStateException("Unknown deploy strategy: " + this.deployStrategy);
    }

    public boolean isDone() {
        return !this.isEnabled() || this.scheduledPool != null && this.scheduledPool.isTerminated();
    }

    public void destroy() throws Exception {
        if (this.scheduledPool != null) {
            this.scheduledPool.shutdown();
            try {
                if (!this.scheduledPool.awaitTermination(this.retryPeriod * 3L, TimeUnit.SECONDS)) {
                    this.scheduledPool.shutdownNow();
                    if (!this.scheduledPool.awaitTermination(this.retryPeriod * 3L, TimeUnit.SECONDS)) {
                        this.log.warn("Unable to terminate deploy jars task.");
                    }
                }
            }
            catch (InterruptedException e) {
                this.scheduledPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

