/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openl.binding.MethodUtil;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.calc.CombinedSpreadsheetResultOpenClass;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultBeanPropertyNamingStrategy;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.core.RuleServiceWrapperException;
import org.openl.rules.ruleservice.core.annotations.BeanToSpreadsheetResultConvert;
import org.openl.rules.ruleservice.core.annotations.ExternalParam;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethod;
import org.openl.rules.ruleservice.core.annotations.ServiceExtraMethodHandler;
import org.openl.rules.ruleservice.core.interceptors.IOpenClassAware;
import org.openl.rules.ruleservice.core.interceptors.IOpenMemberAware;
import org.openl.rules.ruleservice.core.interceptors.RulesDeployAware;
import org.openl.rules.ruleservice.core.interceptors.ServiceClassLoaderAware;
import org.openl.rules.ruleservice.core.interceptors.ServiceInvocationAdviceListener;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAdvice;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAfterAdvice;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodAroundAdvice;
import org.openl.rules.ruleservice.core.interceptors.ServiceMethodBeforeAdvice;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAfterInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallAroundInterceptor;
import org.openl.rules.ruleservice.core.interceptors.annotations.ServiceCallBeforeInterceptor;
import org.openl.rules.runtime.LoggingCapability;
import org.openl.rules.runtime.LoggingHandler;
import org.openl.rules.serialization.ProjectJacksonObjectMapperFactoryBean;
import org.openl.runtime.AbstractOpenLMethodHandler;
import org.openl.runtime.IEngineWrapper;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

public final class ServiceInvocationAdvice
extends AbstractOpenLMethodHandler<Method, Method>
implements Ordered,
LoggingCapability {
    public static final String OBJECT_MAPPER_ID = "serviceObjectMapper";
    private final Logger log = LoggerFactory.getLogger(ServiceInvocationAdvice.class);
    private final Map<Method, List<ServiceMethodBeforeAdvice>> beforeInterceptors = new HashMap<Method, List<ServiceMethodBeforeAdvice>>();
    private final Map<Method, List<ServiceMethodAfterAdvice<?>>> afterInterceptors = new HashMap();
    private final Map<Method, ServiceMethodAroundAdvice<?>> aroundInterceptors = new HashMap();
    private final Map<Method, ServiceExtraMethodHandler<?>> serviceExtraMethodAnnotations = new HashMap();
    private final Object serviceTarget;
    private final ClassLoader serviceClassLoader;
    private final IOpenClass openClass;
    private final Collection<ServiceInvocationAdviceListener> serviceMethodAdviceListeners;
    private final Map<Class<?>, CustomSpreadsheetResultOpenClass> mapClassToSprOpenClass;
    private final Map<Method, Method> methodMap;
    private final RulesDeploy rulesDeploy;
    private final SpreadsheetResultBeanPropertyNamingStrategy sprBeanPropertyNamingStrategy;
    private final ThreadLocal<IOpenMember> iOpenMethodHolder = new ThreadLocal();
    final ConfigurableApplicationContext serviceContext;
    private final boolean loggingEnabled;
    private final Function<Object, String> serializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInvocationAdvice(IOpenClass openClass, Object serviceTarget, Map<Method, Method> methodMap, ClassLoader serviceClassLoader, Collection<ServiceInvocationAdviceListener> serviceMethodAdviceListeners, ApplicationContext applicationContext, RulesDeploy rulesDeploy) {
        this.serviceTarget = serviceTarget;
        this.methodMap = methodMap;
        this.serviceClassLoader = serviceClassLoader;
        this.openClass = openClass;
        this.serviceMethodAdviceListeners = serviceMethodAdviceListeners != null ? new ArrayList<ServiceInvocationAdviceListener>(serviceMethodAdviceListeners) : new ArrayList();
        this.mapClassToSprOpenClass = this.initMapClassToSprOpenClass();
        this.rulesDeploy = rulesDeploy;
        PropertyNamingStrategy propertyNamingStrategy = ProjectJacksonObjectMapperFactoryBean.extractPropertyNamingStrategy((RulesDeploy)rulesDeploy, (ClassLoader)serviceClassLoader);
        this.sprBeanPropertyNamingStrategy = propertyNamingStrategy instanceof SpreadsheetResultBeanPropertyNamingStrategy ? (SpreadsheetResultBeanPropertyNamingStrategy)propertyNamingStrategy : null;
        ObjectMapper mapper = this.configureObjectMapper(applicationContext, rulesDeploy, serviceClassLoader, (XlsModuleOpenClass)openClass);
        this.serializer = x -> {
            try {
                RuleServiceWrapperException exc;
                Object object = x instanceof Throwable ? ((exc = RuleServiceWrapperException.create((Throwable)((Throwable)x), (SpreadsheetResultBeanPropertyNamingStrategy)this.sprBeanPropertyNamingStrategy)).getBody() != null ? exc.getBody() : exc.getMessage()) : SpreadsheetResult.convertSpreadsheetResult((Object)x, (SpreadsheetResultBeanPropertyNamingStrategy)this.sprBeanPropertyNamingStrategy);
                return mapper.writeValueAsString(object);
            }
            catch (Exception ignore) {
                this.log.warn("Exception.", (Throwable)ignore);
                return x.toString();
            }
        };
        this.loggingEnabled = Boolean.parseBoolean(applicationContext.getEnvironment().getProperty("ruleservice.logging.enabled"));
        AnnotationConfigApplicationContext serviceContext = new AnnotationConfigApplicationContext();
        serviceContext.setClassLoader(serviceClassLoader);
        serviceContext.setParent(applicationContext);
        serviceContext.getBeanFactory().registerSingleton("openClass", (Object)openClass);
        if (rulesDeploy != null) {
            serviceContext.getBeanFactory().registerSingleton("rulesDeploy", (Object)rulesDeploy);
        }
        serviceContext.getBeanFactory().registerSingleton("serviceClassLoader", (Object)serviceClassLoader);
        serviceContext.getBeanFactory().registerSingleton(OBJECT_MAPPER_ID, (Object)mapper);
        serviceContext.getBeanFactory().registerResolvableDependency(IOpenMember.class, this.iOpenMethodHolder::get);
        try {
            Class<?> configurationClass = Class.forName("spring.SpringConfig", false, serviceClassLoader);
            if (configurationClass.isAnnotationPresent(Configuration.class)) {
                serviceContext.register(new Class[]{configurationClass});
            }
        }
        catch (ClassNotFoundException configurationClass) {
            // empty catch block
        }
        serviceContext.refresh();
        this.serviceContext = serviceContext;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
            for (Method method : methodMap.keySet()) {
                this.checkForBeforeInterceptor(method);
                this.checkForAfterInterceptor(method);
                this.checkForAroundInterceptor(method);
                this.checkForServiceExtraMethodAnnotation(method);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private ObjectMapper configureObjectMapper(ApplicationContext context, RulesDeploy rulesDeploy, ClassLoader classLoader, XlsModuleOpenClass openClass) {
        ProjectJacksonObjectMapperFactoryBean objectMapperFactory = new ProjectJacksonObjectMapperFactoryBean();
        objectMapperFactory.setRulesDeploy(rulesDeploy);
        objectMapperFactory.setEnvironment(context.getEnvironment());
        objectMapperFactory.setXlsModuleOpenClass(openClass);
        objectMapperFactory.setClassLoader(classLoader);
        try {
            return objectMapperFactory.createJacksonObjectMapper();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Class<?>, CustomSpreadsheetResultOpenClass> initMapClassToSprOpenClass() {
        XlsModuleOpenClass xlsModuleOpenClass = (XlsModuleOpenClass)this.openClass;
        HashMap<Class, Object> mapClassToCustomSpreadsheetResultOpenClass = new HashMap<Class, Object>();
        for (IOpenClass type : xlsModuleOpenClass.getTypes()) {
            if (!(type instanceof CustomSpreadsheetResultOpenClass)) continue;
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)type;
            mapClassToCustomSpreadsheetResultOpenClass.put(customSpreadsheetResultOpenClass.getBeanClass(), customSpreadsheetResultOpenClass);
        }
        for (CombinedSpreadsheetResultOpenClass combinedSpreadsheetResultOpenClass : xlsModuleOpenClass.getCombinedSpreadsheetResultOpenClasses()) {
            mapClassToCustomSpreadsheetResultOpenClass.put(combinedSpreadsheetResultOpenClass.getBeanClass(), combinedSpreadsheetResultOpenClass);
        }
        if (xlsModuleOpenClass.getSpreadsheetResultOpenClassWithResolvedFieldTypes() != null) {
            CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClassForSpreadsheetResultOpenClass = xlsModuleOpenClass.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass();
            mapClassToCustomSpreadsheetResultOpenClass.put(customSpreadsheetResultOpenClassForSpreadsheetResultOpenClass.getBeanClass(), customSpreadsheetResultOpenClassForSpreadsheetResultOpenClass);
        }
        return Collections.unmodifiableMap(mapClassToCustomSpreadsheetResultOpenClass);
    }

    private <T> T createBean(Method method, Class<T> interceptorClass) {
        IOpenMember openMember = this.getOpenMember(method);
        this.iOpenMethodHolder.set(openMember);
        AutowireCapableBeanFactory beanFactory = this.serviceContext.getAutowireCapableBeanFactory();
        Object o = beanFactory.createBean(interceptorClass);
        if (o instanceof IOpenClassAware) {
            ((IOpenClassAware)o).setIOpenClass(this.openClass);
        }
        if (o instanceof IOpenMemberAware && openMember != null) {
            ((IOpenMemberAware)o).setIOpenMember(openMember);
        }
        if (o instanceof ServiceClassLoaderAware) {
            ((ServiceClassLoaderAware)o).setServiceClassLoader(this.serviceClassLoader);
        }
        if (o instanceof RulesDeployAware) {
            ((RulesDeployAware)o).setRulesDeploy(this.rulesDeploy);
        }
        this.iOpenMethodHolder.remove();
        return (T)o;
    }

    private void checkForAroundInterceptor(Method method) {
        ServiceCallAroundInterceptor annotation = method.getAnnotation(ServiceCallAroundInterceptor.class);
        if (annotation != null) {
            Class interceptorClass = annotation.value();
            try {
                ServiceMethodAroundAdvice aroundInterceptor = (ServiceMethodAroundAdvice)this.createBean(method, interceptorClass);
                this.aroundInterceptors.put(method, aroundInterceptor);
            }
            catch (Exception e) {
                throw new RuleServiceRuntimeException(String.format("Failed to instantiate 'around' interceptor for method '%s'. Please, check that class '%s' is not abstract and has a default constructor.", MethodUtil.printQualifiedMethodName((Method)method), interceptorClass.getTypeName()), (Throwable)e);
            }
        }
    }

    private void checkForBeforeInterceptor(Method method) {
        ServiceCallBeforeInterceptor[] annotations;
        for (ServiceCallBeforeInterceptor annotation : annotations = (ServiceCallBeforeInterceptor[])method.getAnnotationsByType(ServiceCallBeforeInterceptor.class)) {
            for (Class interceptorClass : annotation.value()) {
                try {
                    ServiceMethodBeforeAdvice preInterceptor = (ServiceMethodBeforeAdvice)this.createBean(method, interceptorClass);
                    this.beforeInterceptors.computeIfAbsent(method, e -> new ArrayList()).add(preInterceptor);
                }
                catch (Exception e2) {
                    throw new RuleServiceRuntimeException(String.format("Failed to instantiate 'before' interceptor for method '%s'. Please, check that class '%s' is not abstract and has a default constructor.", MethodUtil.printQualifiedMethodName((Method)method), interceptorClass.getTypeName()), (Throwable)e2);
                }
            }
        }
    }

    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    public Function<Object, String> serializer() {
        return this.serializer;
    }

    private void checkForServiceExtraMethodAnnotation(Method method) {
        ServiceExtraMethod annotation = method.getAnnotation(ServiceExtraMethod.class);
        if (annotation != null) {
            Class serviceExtraMethodHandlerClass = annotation.value();
            try {
                ServiceExtraMethodHandler serviceExtraMethodHandler = (ServiceExtraMethodHandler)this.createBean(method, serviceExtraMethodHandlerClass);
                this.serviceExtraMethodAnnotations.put(method, serviceExtraMethodHandler);
            }
            catch (Exception e) {
                throw new RuleServiceRuntimeException(String.format("Failed to instantiate service method handler for method '%s'. Please, check that class '%s' is not abstract and has a default constructor.", MethodUtil.printQualifiedMethodName((Method)method), serviceExtraMethodHandlerClass.getTypeName()), (Throwable)e);
            }
        }
    }

    private void checkForAfterInterceptor(Method method) {
        ServiceCallAfterInterceptor[] annotations;
        for (ServiceCallAfterInterceptor annotation : annotations = (ServiceCallAfterInterceptor[])method.getAnnotationsByType(ServiceCallAfterInterceptor.class)) {
            for (Class interceptorClass : annotation.value()) {
                try {
                    ServiceMethodAfterAdvice postInterceptor = (ServiceMethodAfterAdvice)this.createBean(method, interceptorClass);
                    this.afterInterceptors.computeIfAbsent(method, e -> new ArrayList()).add(postInterceptor);
                }
                catch (Exception e2) {
                    throw new RuleServiceRuntimeException(String.format("Failed to instantiate 'afterReturning' interceptor for method '%s'. Please, check that class '%s' is not abstract and has a default constructor.", MethodUtil.printQualifiedMethodName((Method)method), interceptorClass.getTypeName()), (Throwable)e2);
                }
            }
        }
    }

    private void beforeInvocation(Method interfaceMethod, Object ... args) throws Throwable {
        for (ServiceMethodBeforeAdvice interceptor : this.beforeInterceptors.getOrDefault(interfaceMethod, Collections.emptyList())) {
            this.invokeBeforeServiceMethodAdviceOnListeners((ServiceMethodAdvice)interceptor, interfaceMethod, args, null, null);
            interceptor.before(interfaceMethod, this.serviceTarget, args);
            this.invokeAfterServiceMethodAdviceOnListeners((ServiceMethodAdvice)interceptor, interfaceMethod, args, null, null);
        }
    }

    private Object serviceExtraMethodInvoke(Method interfaceMethod, Object serviceBean, Object ... args) throws Exception {
        ServiceExtraMethodHandler<?> serviceExtraMethodHandler = this.serviceExtraMethodAnnotations.get(interfaceMethod);
        if (serviceExtraMethodHandler != null) {
            return serviceExtraMethodHandler.invoke(interfaceMethod, serviceBean, args);
        }
        throw new OpenLRuntimeException("Service method advice is not found.");
    }

    private Object afterInvocation(Method interfaceMethod, Object result, Exception t, Object ... args) throws Exception {
        Object ret = result;
        for (ServiceMethodAfterAdvice interceptor : this.afterInterceptors.getOrDefault(interfaceMethod, Collections.emptyList())) {
            this.invokeBeforeServiceMethodAdviceOnListeners((ServiceMethodAdvice)interceptor, interfaceMethod, args, result, t);
            if (t == null) {
                ret = interceptor.afterReturning(interfaceMethod, ret, args);
            } else {
                try {
                    ret = interceptor.afterThrowing(interfaceMethod, t, args);
                    t = null;
                }
                catch (Exception e) {
                    t = e;
                }
            }
            this.invokeAfterServiceMethodAdviceOnListeners((ServiceMethodAdvice)interceptor, interfaceMethod, args, result, t);
        }
        if (t != null) {
            throw t;
        }
        return ret;
    }

    private void invokeAfterServiceMethodAdviceOnListeners(ServiceMethodAdvice interceptor, Method interfaceMethod, Object[] args, Object ret, Exception ex) {
        for (ServiceInvocationAdviceListener listener : this.serviceMethodAdviceListeners) {
            listener.afterServiceMethodAdvice(interceptor, interfaceMethod, args, ret, ex, (ServiceInvocationAdviceListener.Instantiator)new Inst(interfaceMethod));
        }
    }

    private void invokeBeforeServiceMethodAdviceOnListeners(ServiceMethodAdvice interceptor, Method interfaceMethod, Object[] args, Object ret, Exception ex) {
        for (ServiceInvocationAdviceListener listener : this.serviceMethodAdviceListeners) {
            listener.beforeServiceMethodAdvice(interceptor, interfaceMethod, args, ret, ex, (ServiceInvocationAdviceListener.Instantiator)new Inst(interfaceMethod));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object invoke(Method calledMethod, Object[] args) {
        String methodName = calledMethod.getName();
        Class[] parameterTypes = calledMethod.getParameterTypes();
        Object result = null;
        Method beanMethod = null;
        if (!calledMethod.isAnnotationPresent(ServiceExtraMethod.class) && (beanMethod = this.getTargetMember(calledMethod)) == null) {
            String msg = String.format("Called method is not found in the service bean. Please, check that excel file contains method '%s'.", MethodUtil.printMethod((String)methodName, (Class[])parameterTypes));
            throw new RuleServiceWrapperException(msg, ExceptionType.SYSTEM);
        }
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Exception ex;
                block31: {
                    LoggingHandler.setup((LoggingCapability)this);
                    Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
                    this.beforeInvocation(calledMethod, args);
                    ServiceMethodAroundAdvice<?> serviceMethodAroundAdvice = this.aroundInterceptors.get(calledMethod);
                    ex = null;
                    if (serviceMethodAroundAdvice != null) {
                        this.invokeBeforeServiceMethodAdviceOnListeners((ServiceMethodAdvice)serviceMethodAroundAdvice, calledMethod, args, null, null);
                        try {
                            args = this.processArguments(calledMethod, beanMethod, args);
                            result = serviceMethodAroundAdvice.around(calledMethod, beanMethod, this.serviceTarget, args);
                        }
                        catch (Exception e) {
                            ex = e;
                        }
                        finally {
                            this.invokeAfterServiceMethodAdviceOnListeners((ServiceMethodAdvice)serviceMethodAroundAdvice, calledMethod, args, result, ex);
                        }
                    } else {
                        block29: {
                            this.invokeBeforeMethodInvocationOnListeners(calledMethod, args);
                            if (beanMethod != null) {
                                args = this.processArguments(calledMethod, beanMethod, args);
                                result = beanMethod.invoke(this.serviceTarget, args);
                                break block29;
                            }
                            result = this.serviceExtraMethodInvoke(calledMethod, this.serviceTarget, args);
                        }
                        this.invokeAfterMethodInvocationOnListeners(calledMethod, args, result, ex);
                    }
                    break block31;
                    catch (InvocationTargetException | UndeclaredThrowableException e) {
                        Throwable t = e.getCause();
                        if (t instanceof Exception) {
                            ex = (Exception)t;
                            ex.addSuppressed(e);
                        } else {
                            ex = e;
                        }
                        this.invokeAfterMethodInvocationOnListeners(calledMethod, args, result, ex);
                    }
                    catch (Exception e2) {
                        ex = e2;
                        this.invokeAfterMethodInvocationOnListeners(calledMethod, args, result, ex);
                        {
                            catch (Throwable throwable) {
                                this.invokeAfterMethodInvocationOnListeners(calledMethod, args, result, ex);
                                throw throwable;
                            }
                        }
                    }
                }
                result = this.afterInvocation(calledMethod, result, ex, args);
                if (calledMethod.getReturnType().isArray()) {
                    result = ArrayUtils.repackArray((Object)result, calledMethod.getReturnType());
                }
            }
            finally {
                LoggingHandler.remove();
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Throwable t) {
            RuleServiceWrapperException error = RuleServiceWrapperException.create((Throwable)t, (SpreadsheetResultBeanPropertyNamingStrategy)this.sprBeanPropertyNamingStrategy);
            if (error.getType().isServerError()) {
                this.log.error(error.getMessage(), t);
            }
            throw error;
        }
        finally {
            if (this.serviceTarget instanceof IEngineWrapper) {
                IEngineWrapper engine = (IEngineWrapper)this.serviceTarget;
                engine.release();
            } else {
                this.log.warn("Service bean does not implement IEngineWrapper interface. Please, don't use deprecated static wrapper classes.");
            }
        }
        return result;
    }

    private Object[] processArguments(Method interfaceMethod, Method beanMethod, Object[] args) {
        Object[] newArgs = new Object[beanMethod.getParameterCount()];
        int i = 0;
        int j = 0;
        for (Parameter parameter : interfaceMethod.getParameters()) {
            if (!parameter.isAnnotationPresent(ExternalParam.class)) {
                newArgs[j++] = parameter.isAnnotationPresent(BeanToSpreadsheetResultConvert.class) ? SpreadsheetResult.convertBeansToSpreadsheetResults((Object)args[i], this.mapClassToSprOpenClass) : args[i];
            }
            ++i;
        }
        return newArgs;
    }

    private void invokeAfterMethodInvocationOnListeners(Method interfaceMethod, Object[] args, Object result, Exception ex) {
        for (ServiceInvocationAdviceListener listener : this.serviceMethodAdviceListeners) {
            listener.afterMethodInvocation(interfaceMethod, args, result, ex, (ServiceInvocationAdviceListener.Instantiator)new Inst(interfaceMethod));
        }
    }

    private void invokeBeforeMethodInvocationOnListeners(Method interfaceMethod, Object[] args) {
        for (ServiceInvocationAdviceListener listener : this.serviceMethodAdviceListeners) {
            listener.beforeMethodInvocation(interfaceMethod, args, null, null, (ServiceInvocationAdviceListener.Instantiator)new Inst(interfaceMethod));
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object getTarget() {
        return this.serviceTarget;
    }

    public Method getTargetMember(Method key) {
        return this.methodMap.get(key);
    }

    class Inst
    implements ServiceInvocationAdviceListener.Instantiator {
        final Method method;

        Inst(Method method) {
            this.method = method;
        }

        public <T> T instantiate(Class<T> clazz) {
            return ServiceInvocationAdvice.this.createBean(this.method, clazz);
        }
    }
}

