/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Manifest;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.ResourceLoader;

public final class ServiceDescription {
    private final String name;
    private final String url;
    private final String deployPath;
    private final String serviceClassName;
    private final String rmiServiceClassName;
    private final String rmiName;
    private final String annotationTemplateClassName;
    private final boolean provideRuntimeContext;
    private final boolean provideVariations;
    private final Map<String, Object> configuration;
    private final Collection<Module> modules;
    private final DeploymentDescription deployment;
    private final String[] publishers;
    private final ResourceLoader resourceLoader;
    private final Manifest manifest;
    private final RulesDeploy rulesDeploy;

    ServiceDescription(String name, String url, String deployPath, String serviceClassName, String rmiServiceClassName, String rmiName, String annotationTemplateClassName, boolean provideRuntimeContext, boolean provideVariations, Collection<Module> modules, DeploymentDescription deployment, Map<String, Object> configuration, String[] publishers, ResourceLoader resourceLoader, Manifest manifest, RulesDeploy rulesDeploy) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.resourceLoader = Objects.requireNonNull(resourceLoader, "resourceLoader cannot be null");
        this.url = url;
        this.deployPath = deployPath;
        this.serviceClassName = serviceClassName;
        this.provideRuntimeContext = provideRuntimeContext;
        this.rmiServiceClassName = rmiServiceClassName;
        this.rmiName = rmiName;
        this.provideVariations = provideVariations;
        this.annotationTemplateClassName = annotationTemplateClassName;
        this.rulesDeploy = rulesDeploy;
        this.configuration = configuration == null ? Collections.emptyMap() : Collections.unmodifiableMap(configuration);
        this.modules = modules != null ? Collections.unmodifiableCollection(modules) : Collections.emptySet();
        this.publishers = publishers;
        this.deployment = deployment;
        this.manifest = manifest;
    }

    private ServiceDescription(ServiceDescriptionBuilder builder) {
        this(builder.name, builder.url, builder.servicePath, builder.serviceClassName, builder.rmiServiceClassName, builder.rmiName, builder.annotationTemplateClassName, builder.provideRuntimeContext, builder.provideVariations, builder.modules, builder.deployment, builder.configuration, builder.publishers.toArray(new String[0]), builder.resourceLoader, builder.manifest, builder.rulesDeploy);
    }

    public RulesDeploy getRulesDeploy() {
        return this.rulesDeploy;
    }

    public String getAnnotationTemplateClassName() {
        return this.annotationTemplateClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public String getRmiServiceClassName() {
        return this.rmiServiceClassName;
    }

    public String getRmiName() {
        return this.rmiName;
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    public Collection<Module> getModules() {
        return this.modules;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public DeploymentDescription getDeployment() {
        return this.deployment;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String[] getPublishers() {
        if (this.publishers == null) {
            return new String[0];
        }
        return this.publishers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDescription that = (ServiceDescription)o;
        return this.deployPath.equals(that.deployPath);
    }

    public int hashCode() {
        return Objects.hash(this.deployPath);
    }

    public static class ServiceDescriptionBuilder {
        private String name;
        private String url;
        private String servicePath;
        private String serviceClassName;
        private String rmiServiceClassName;
        private String rmiName;
        private String annotationTemplateClassName;
        private boolean provideRuntimeContext;
        private boolean provideVariations = false;
        private Map<String, Object> configuration;
        private Collection<Module> modules;
        private DeploymentDescription deployment;
        private Set<String> publishers = new HashSet<String>();
        private ResourceLoader resourceLoader;
        private Manifest manifest;
        private RulesDeploy rulesDeploy;

        public ServiceDescriptionBuilder setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = Objects.requireNonNull(resourceLoader, "resourceLoader cannot be null");
            return this;
        }

        public ServiceDescriptionBuilder setPublishers(Collection<String> publishers) {
            this.publishers = new HashSet<String>();
            if (publishers != null) {
                this.publishers.addAll(publishers);
            }
            return this;
        }

        public ServiceDescriptionBuilder setRulesDeploy(RulesDeploy rulesDeploy) {
            this.rulesDeploy = rulesDeploy;
            return this;
        }

        public ServiceDescriptionBuilder setAnnotationTemplateClassName(String annotationTemplateClassName) {
            this.annotationTemplateClassName = annotationTemplateClassName;
            return this;
        }

        public ServiceDescriptionBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            return this;
        }

        public ServiceDescriptionBuilder setRmiName(String rmiName) {
            this.rmiName = Objects.requireNonNull(rmiName, "rmiName cannot be null");
            return this;
        }

        public ServiceDescriptionBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public ServiceDescriptionBuilder setServicePath(String servicePath) {
            this.servicePath = servicePath;
            return this;
        }

        public ServiceDescriptionBuilder setModules(Collection<Module> modules) {
            this.modules = modules == null ? new HashSet<Module>(0) : new HashSet<Module>(modules);
            return this;
        }

        public ServiceDescriptionBuilder addModules(Collection<Module> modules) {
            if (this.modules == null) {
                this.modules = new HashSet<Module>(modules);
            } else {
                this.modules.addAll(modules);
            }
            return this;
        }

        public ServiceDescriptionBuilder addModule(Module module) {
            if (this.modules == null) {
                this.modules = new HashSet<Module>(0);
            }
            if (module != null) {
                this.modules.add(module);
            }
            return this;
        }

        public ServiceDescriptionBuilder setProvideRuntimeContext(boolean provideRuntimeContext) {
            this.provideRuntimeContext = provideRuntimeContext;
            return this;
        }

        public ServiceDescriptionBuilder setServiceClassName(String serviceClassName) {
            this.serviceClassName = serviceClassName;
            return this;
        }

        public ServiceDescriptionBuilder setRmiServiceClassName(String rmiServiceClassName) {
            this.rmiServiceClassName = rmiServiceClassName;
            return this;
        }

        public ServiceDescriptionBuilder setProvideVariations(boolean provideVariations) {
            this.provideVariations = provideVariations;
            return this;
        }

        public ServiceDescriptionBuilder setDeployment(DeploymentDescription deployment) {
            this.deployment = deployment;
            return this;
        }

        public ServiceDescriptionBuilder addConfigurationProperty(String key, Object value) {
            if (this.configuration == null) {
                this.configuration = new HashMap<String, Object>();
            }
            this.configuration.put(key, value);
            return this;
        }

        public ServiceDescriptionBuilder setConfiguration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public ServiceDescriptionBuilder setManifest(Manifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public ServiceDescription build() {
            if (this.name == null) {
                throw new IllegalStateException("Field 'name' is required for building ServiceDescription");
            }
            if (this.resourceLoader == null) {
                throw new IllegalStateException("Field 'resourceLoader' is required for building ServiceDescription");
            }
            if (this.modules == null) {
                throw new IllegalStateException("Field 'modules' is required for building ServiceDescription");
            }
            if (this.deployment == null) {
                throw new IllegalStateException("Field 'deployment' is required for building ServiceDescription");
            }
            return new ServiceDescription(this);
        }
    }
}

