/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLClassLoader;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancer;
import org.openl.rules.project.instantiation.SimpleMultiModuleInstantiationStrategy;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancer;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.core.AbstractOpenLServiceInitializer;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDependencyManager;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactory;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactoryHelper;
import org.openl.rules.ruleservice.core.RuleServiceRuntimeException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.core.ServiceInvocationAdvice;
import org.openl.rules.ruleservice.core.interceptors.DynamicInterfaceAnnotationEnhancerHelper;
import org.openl.rules.ruleservice.core.interceptors.ServiceInvocationAdviceListener;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.rules.ruleservice.management.ServiceManagerImpl;
import org.openl.runtime.ASMProxyFactory;
import org.openl.runtime.ASMProxyHandler;
import org.openl.types.IOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;

public class RuleServiceOpenLServiceInstantiationFactoryImpl
implements RuleServiceInstantiationFactory {
    private final Logger log = LoggerFactory.getLogger(RuleServiceOpenLServiceInstantiationFactoryImpl.class);
    private RuleServiceLoader ruleServiceLoader;
    private Map<String, Object> externalParameters;
    private final Map<DeploymentDescription, RuleServiceDependencyManager> dependencyManagerMap = new HashMap<DeploymentDescription, RuleServiceDependencyManager>();
    private ObjectProvider<Collection<ServiceInvocationAdviceListener>> serviceInvocationAdviceListeners;
    @Autowired
    @Lazy
    private ServiceManagerImpl serviceManager;
    @Autowired
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initService(ServiceDescription serviceDescription, RuleServiceDependencyManager dependencyManager, OpenLService service) throws RuleServiceInstantiationException, RulesInstantiationException {
        SimpleMultiModuleInstantiationStrategy baseInstantiationStrategy;
        Objects.requireNonNull(serviceDescription, "serviceDescription cannot be null");
        Objects.requireNonNull(dependencyManager, "dependencyManager cannot be null");
        Collection<Module> modules = serviceDescription.getModules();
        SimpleMultiModuleInstantiationStrategy instantiationStrategy = baseInstantiationStrategy = new SimpleMultiModuleInstantiationStrategy(modules, (IDependencyManager)dependencyManager, true);
        Map parameters = ProjectExternalDependenciesHelper.buildExternalParamsWithProjectDependencies(this.externalParameters, service.getModules());
        instantiationStrategy.setExternalParameters(parameters);
        if (service.isProvideVariations()) {
            instantiationStrategy = new VariationInstantiationStrategyEnhancer((RulesInstantiationStrategy)instantiationStrategy);
        }
        if (service.isProvideRuntimeContext()) {
            instantiationStrategy = new RuntimeContextInstantiationStrategyEnhancer((RulesInstantiationStrategy)instantiationStrategy);
        }
        this.compileOpenClass(service, (RulesInstantiationStrategy)instantiationStrategy);
        ClassLoader serviceClassLoader = this.resolveServiceClassLoader(service, (RulesInstantiationStrategy)instantiationStrategy);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClassLoader);
            Pair<Object, Map<Method, Method>> serviceTarget = this.resolveInterfaceAndClassLoader(service, serviceDescription, (RulesInstantiationStrategy)instantiationStrategy);
            if (service.getPublishers().contains(RulesDeploy.PublisherType.RMI.toString())) {
                this.resolveRmiInterface(service);
            }
            this.instantiateServiceBean(service, serviceTarget, serviceClassLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private ClassLoader resolveServiceClassLoader(OpenLService service, RulesInstantiationStrategy instantiationStrategy) throws RulesInstantiationException, RuleServiceInstantiationException {
        OpenLClassLoader moduleGeneratedClassesClassLoader = ((XlsModuleOpenClass)service.getOpenClass()).getClassGenerationClassLoader();
        OpenLClassLoader openLClassLoader = new OpenLClassLoader(null);
        openLClassLoader.addClassLoader((ClassLoader)moduleGeneratedClassesClassLoader);
        openLClassLoader.addClassLoader(instantiationStrategy.getClassLoader());
        service.setClassLoader((ClassLoader)openLClassLoader);
        return openLClassLoader;
    }

    private void compileOpenClass(OpenLService service, RulesInstantiationStrategy instantiationStrategy) throws RulesInstantiationException {
        CompiledOpenClass compiledOpenClass = instantiationStrategy.compile();
        service.setCompiledOpenClass(compiledOpenClass);
    }

    private void instantiateServiceBean(OpenLService service, Pair<Object, Map<Method, Method>> serviceTarget, ClassLoader classLoader) throws RuleServiceInstantiationException {
        Class<?> serviceClass = service.getServiceClass();
        try {
            if (!serviceClass.isInterface()) {
                throw new RuleServiceRuntimeException("Failed to create a proxy for service target object. Deprecated approach with wrapper: service class is not an interface.");
            }
            ServiceInvocationAdvice serviceInvocationAdvice = new ServiceInvocationAdvice(service.getOpenClass(), serviceTarget.getLeft(), (Map)serviceTarget.getRight(), classLoader, this.getListServiceInvocationAdviceListeners(), this.applicationContext, this.serviceManager != null ? this.serviceManager.getRulesDeployInProcess() : null);
            Object proxyServiceBean = ASMProxyFactory.newProxyInstance((ClassLoader)classLoader, (ASMProxyHandler)serviceInvocationAdvice, serviceClass);
            service.setServiceBean(proxyServiceBean);
            service.setServiceContext(serviceInvocationAdvice.serviceContext);
        }
        catch (Exception t) {
            throw new RuleServiceRuntimeException("Failed to create a proxy for service target object.", (Throwable)t);
        }
    }

    private Pair<Object, Map<Method, Method>> resolveInterfaceAndClassLoader(OpenLService service, ServiceDescription serviceDescription, RulesInstantiationStrategy instantiationStrategy) throws RuleServiceInstantiationException, RulesInstantiationException {
        Object serviceTarget;
        Class serviceTargetClass;
        Class serviceClass;
        String serviceClassName = service.getServiceClassName();
        ClassLoader serviceClassLoader = service.getClassLoader();
        if (serviceClassName != null) {
            try {
                serviceClass = serviceClassLoader.loadClass(serviceClassName.trim());
                if (!serviceClass.isInterface()) {
                    throw new RuleServiceRuntimeException(String.format("Failed to apply service class '%s'. Interface is expected, but class is found.", serviceClass));
                }
                serviceTargetClass = RuleServiceInstantiationFactoryHelper.buildInterfaceForInstantiationStrategy(serviceClass, (ClassLoader)instantiationStrategy.getClassLoader(), (Object)instantiationStrategy.instantiate(), (boolean)serviceDescription.isProvideRuntimeContext(), (boolean)serviceDescription.isProvideVariations());
                instantiationStrategy.setServiceClass(serviceTargetClass);
                service.setServiceClass(serviceClass);
                serviceTarget = instantiationStrategy.instantiate();
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new RuleServiceRuntimeException(String.format("Failed to load a service class '%s'.", serviceClassName), e);
            }
        } else {
            this.log.info("Service class is undefined for service '{}'. Generated interface is used.", (Object)service.getDeployPath());
            serviceTargetClass = instantiationStrategy.getInstanceClass();
            serviceTarget = instantiationStrategy.instantiate();
            IOpenClass openClass = service.getOpenClass();
            Class<?> annotatedClass = this.processAnnotatedTemplateClass(serviceDescription, serviceTargetClass, openClass, serviceClassLoader);
            serviceClass = RuleServiceInstantiationFactoryHelper.buildInterfaceForService((IOpenClass)openClass, annotatedClass, (ClassLoader)serviceClassLoader, (Object)serviceTarget, (boolean)serviceDescription.isProvideRuntimeContext(), (boolean)serviceDescription.isProvideVariations());
            service.setServiceClass(serviceClass);
        }
        Map methodMap = RuleServiceInstantiationFactoryHelper.getMethodMap((Class)serviceClass, (Class)serviceTargetClass, (Object)serviceTarget, (ClassLoader)serviceClassLoader, (IOpenClass)service.getOpenClass());
        return Pair.of((Object)serviceTarget, (Object)methodMap);
    }

    private void resolveRmiInterface(OpenLService service) throws RuleServiceInstantiationException {
        String rmiServiceClassName = service.getRmiServiceClassName();
        Class<?> serviceClass = null;
        ClassLoader serviceClassLoader = service.getClassLoader();
        if (rmiServiceClassName != null) {
            try {
                serviceClass = serviceClassLoader.loadClass(rmiServiceClassName.trim());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new RuleServiceRuntimeException(String.format("Failed to load RMI service class '%s'.", rmiServiceClassName), e);
            }
        }
        if (serviceClass == null) {
            this.log.info("Service class is undefined for service '{}'. Default RMI interface is used.", (Object)service.getDeployPath());
            service.setRmiServiceClassName(null);
        }
        service.setRmiServiceClass(serviceClass);
    }

    private Class<?> processAnnotatedTemplateClass(ServiceDescription serviceDescription, Class<?> serviceClass, IOpenClass openClass, ClassLoader classLoader) {
        String annotationTemplateClassName = serviceDescription.getAnnotationTemplateClassName();
        if (annotationTemplateClassName != null) {
            try {
                Class<?> annotationTemplateClass = classLoader.loadClass(annotationTemplateClassName.trim());
                if (annotationTemplateClass.isInterface() || Modifier.isAbstract(annotationTemplateClass.getModifiers())) {
                    Class decoratedClass = DynamicInterfaceAnnotationEnhancerHelper.decorate(serviceClass, annotationTemplateClass, (IOpenClass)openClass, (ClassLoader)classLoader);
                    this.log.info("Annotation template class '{}' is used for service {}.", (Object)annotationTemplateClassName, (Object)serviceDescription.getDeployPath());
                    return decoratedClass;
                }
                throw new RuleServiceRuntimeException(String.format("Failed to apply annotation template class '%s'. Interface or abstract class is expected, but class is found.", annotationTemplateClassName));
            }
            catch (RuleServiceRuntimeException e) {
                throw e;
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new RuleServiceRuntimeException(String.format("Failed to load or apply annotation template class '%s'.", annotationTemplateClassName), e);
            }
        }
        return serviceClass;
    }

    @Override
    public OpenLService createService(final ServiceDescription serviceDescription) {
        this.log.debug("Resolving modules for service '{}'.", (Object)serviceDescription.getDeployPath());
        Collection<Module> modules = serviceDescription.getModules();
        OpenLService.OpenLServiceBuilder builder = new OpenLService.OpenLServiceBuilder();
        builder.setName(serviceDescription.getName()).setUrl(serviceDescription.getUrl()).setDeployPath(serviceDescription.getDeployPath()).setServiceClassName(serviceDescription.getServiceClassName()).setRmiServiceClassName(serviceDescription.getRmiServiceClassName()).setRmiName(serviceDescription.getRmiName()).setProvideRuntimeContext(serviceDescription.isProvideRuntimeContext()).setProvideVariations(serviceDescription.isProvideVariations()).addModules(modules).setDeployment(serviceDescription.getDeployment());
        for (String publisher : serviceDescription.getPublishers()) {
            builder.addPublisher(publisher);
        }
        return builder.build(new AbstractOpenLServiceInitializer(){

            @Override
            public void init(OpenLService openLService) throws RuleServiceInstantiationException {
                try {
                    RuleServiceOpenLServiceInstantiationFactoryImpl.this.initService(serviceDescription, RuleServiceOpenLServiceInstantiationFactoryImpl.this.getDependencyManager(serviceDescription), openLService);
                }
                catch (RuleServiceInstantiationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuleServiceInstantiationException(String.format("Failed to initialize service '%s'.", openLService.getDeployPath()), e);
                }
            }
        });
    }

    public RuleServiceLoader getRuleServiceLoader() {
        return this.ruleServiceLoader;
    }

    public void setRuleServiceLoader(RuleServiceLoader ruleServiceLoader) {
        this.ruleServiceLoader = Objects.requireNonNull(ruleServiceLoader, "ruleServiceLoader cannot be null");
    }

    public Collection<ServiceInvocationAdviceListener> getListServiceInvocationAdviceListeners() {
        if (this.getServiceInvocationAdviceListeners() != null) {
            return (Collection)this.getServiceInvocationAdviceListeners().getIfAvailable();
        }
        return Collections.emptyList();
    }

    public ObjectProvider<Collection<ServiceInvocationAdviceListener>> getServiceInvocationAdviceListeners() {
        return this.serviceInvocationAdviceListeners;
    }

    public void setServiceInvocationAdviceListeners(ObjectProvider<Collection<ServiceInvocationAdviceListener>> serviceInvocationAdviceListeners) {
        this.serviceInvocationAdviceListeners = serviceInvocationAdviceListeners;
    }

    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    public void setExternalParameters(Map<String, Object> externalParameters) {
        this.externalParameters = externalParameters;
    }

    @Override
    public void clean(ServiceDescription serviceDescription) {
        this.dependencyManagerMap.remove(serviceDescription.getDeployment()).resetAll();
    }

    private RuleServiceDependencyManager getDependencyManager(ServiceDescription serviceDescription) {
        RuleServiceDependencyManager dependencyManager;
        DeploymentDescription deployment = serviceDescription.getDeployment();
        if (this.dependencyManagerMap.containsKey(deployment)) {
            dependencyManager = this.dependencyManagerMap.get(deployment);
        } else {
            ClassLoader rootClassLoader = Thread.currentThread().getContextClassLoader();
            dependencyManager = new RuleServiceDependencyManager(deployment, this.ruleServiceLoader, rootClassLoader, this.externalParameters);
            this.dependencyManagerMap.put(deployment, dependencyManager);
        }
        return dependencyManager;
    }
}

