/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openl.CompiledOpenClass;
import org.openl.rules.project.model.Module;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.OpenLServiceInitializer;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.types.IOpenClass;
import org.springframework.context.ConfigurableApplicationContext;

public final class OpenLService {
    private final String name;
    private final String url;
    private final String deployPath;
    private String serviceClassName;
    private String rmiServiceClassName;
    private final String rmiName;
    private Class<?> serviceClass;
    private Class<?> rmiServiceClass;
    private Object serviceBean;
    private CompiledOpenClass compiledOpenClass;
    private final boolean provideRuntimeContext;
    private final boolean provideVariations;
    private final Collection<Module> modules;
    private final Set<String> publishers;
    private ClassLoader classLoader;
    private OpenLServiceInitializer initializer;
    private Throwable exception;
    private Map<String, String> urls = Collections.emptyMap();
    private final DeploymentDescription deployment;
    private ConfigurableApplicationContext serviceContext;

    public ClassLoader getClassLoader() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.classLoader;
    }

    OpenLService(String name, String url, String deployPath, String serviceClassName, String rmiServiceClassName, String rmiName, boolean provideRuntimeContext, boolean provideVariations, Set<String> publishers, Collection<Module> modules, ClassLoader classLoader, Class<?> serviceClass, DeploymentDescription deployment) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.url = url;
        this.deployPath = deployPath;
        this.modules = modules != null ? Collections.unmodifiableCollection(modules) : Collections.emptyList();
        this.serviceClassName = serviceClassName;
        this.rmiServiceClassName = rmiServiceClassName;
        this.rmiName = rmiName;
        this.provideRuntimeContext = provideRuntimeContext;
        this.provideVariations = provideVariations;
        this.publishers = publishers != null ? Collections.unmodifiableSet(publishers) : Collections.emptySet();
        this.classLoader = classLoader;
        this.serviceClass = serviceClass;
        this.deployment = deployment;
    }

    private OpenLService(OpenLServiceBuilder builder, OpenLServiceInitializer initializer) {
        this(builder.name, builder.url, builder.deployPath, builder.serviceClassName, builder.rmiServiceClassName, builder.rmiName, builder.provideRuntimeContext, builder.provideVariations, builder.publishers, builder.modules, null, builder.serviceClass, builder.deployment);
        this.initializer = Objects.requireNonNull(initializer, "initializer cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public Collection<String> getPublishers() {
        if (this.publishers == null) {
            return Collections.emptyList();
        }
        return this.publishers;
    }

    public Collection<Module> getModules() {
        if (this.modules == null) {
            return Collections.emptyList();
        }
        return this.modules;
    }

    private void ensureInitialization() throws RuleServiceInstantiationException {
        this.initializer.ensureInitialization(this);
    }

    public String getServiceClassName() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.serviceClassName;
    }

    void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public String getRmiServiceClassName() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.rmiServiceClassName;
    }

    public String getRmiName() {
        return this.rmiName;
    }

    void setRmiServiceClassName(String rmiServiceClassName) {
        this.rmiServiceClassName = rmiServiceClassName;
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    public Class<?> getServiceClass() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.serviceClass;
    }

    public Class<?> getRmiServiceClass() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.rmiServiceClass;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    void setRmiServiceClass(Class<?> rmiServiceClass) {
        this.rmiServiceClass = rmiServiceClass;
    }

    public Object getServiceBean() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.serviceBean;
    }

    void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public CompiledOpenClass getCompiledOpenClass() {
        return this.compiledOpenClass;
    }

    void setCompiledOpenClass(CompiledOpenClass compiledOpenClass) {
        this.compiledOpenClass = compiledOpenClass;
        compiledOpenClass.throwErrorExceptionsIfAny();
    }

    public IOpenClass getOpenClass() throws RuleServiceInstantiationException {
        this.ensureInitialization();
        return this.compiledOpenClass != null ? this.compiledOpenClass.getOpenClass() : null;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Map<String, String> getUrls() {
        return this.urls;
    }

    public void setUrls(Map<String, String> urls) {
        this.urls = urls;
    }

    public DeploymentDescription getDeployment() {
        return this.deployment;
    }

    public ConfigurableApplicationContext getServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(ConfigurableApplicationContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deployPath == null ? 0 : this.deployPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenLService other = (OpenLService)obj;
        return !(this.deployPath == null ? other.deployPath != null : !this.deployPath.equals(other.deployPath));
    }

    public static class OpenLServiceBuilder {
        private String name;
        private String url;
        private String deployPath;
        private String serviceClassName;
        private String rmiServiceClassName;
        private String rmiName;
        private Class<?> serviceClass;
        private boolean provideRuntimeContext = false;
        private boolean provideVariations = false;
        private Collection<Module> modules;
        private Set<String> publishers;
        private DeploymentDescription deployment;

        public OpenLServiceBuilder addPublisher(String publisher) {
            if (this.publishers == null) {
                this.publishers = new HashSet<String>();
            }
            if (publisher != null) {
                this.publishers.add(publisher);
            }
            return this;
        }

        public OpenLServiceBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            return this;
        }

        public OpenLServiceBuilder setServiceClassName(String serviceClassName) {
            this.serviceClassName = serviceClassName;
            return this;
        }

        public OpenLServiceBuilder setRmiServiceClassName(String rmiServiceClassName) {
            this.rmiServiceClassName = rmiServiceClassName;
            return this;
        }

        public OpenLServiceBuilder setRmiName(String rmiName) {
            this.rmiName = rmiName;
            return this;
        }

        public OpenLServiceBuilder setProvideRuntimeContext(boolean provideRuntimeContext) {
            this.provideRuntimeContext = provideRuntimeContext;
            return this;
        }

        public OpenLServiceBuilder setProvideVariations(boolean provideVariations) {
            this.provideVariations = provideVariations;
            return this;
        }

        public OpenLServiceBuilder setModules(Collection<Module> modules) {
            this.modules = modules == null ? new ArrayList<Module>(0) : new ArrayList<Module>(modules);
            return this;
        }

        public OpenLServiceBuilder addModules(Collection<Module> modules) {
            if (this.modules == null) {
                this.modules = new ArrayList<Module>();
            }
            this.modules.addAll(modules);
            return this;
        }

        public OpenLServiceBuilder addModule(Module module) {
            if (this.modules == null) {
                this.modules = new ArrayList<Module>();
            }
            if (module != null) {
                this.modules.add(module);
            }
            return this;
        }

        public OpenLServiceBuilder setDeployPath(String deployPath) {
            this.deployPath = deployPath;
            return this;
        }

        public OpenLServiceBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public OpenLServiceBuilder setServiceClass(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        public OpenLServiceBuilder setDeployment(DeploymentDescription deployment) {
            this.deployment = deployment;
            return this;
        }

        public OpenLService build(OpenLServiceInitializer initializer) {
            if (this.name == null) {
                throw new IllegalStateException("Field 'name' is required for building ServiceDescription.");
            }
            if (this.deployPath == null) {
                throw new IllegalStateException("Field 'deployPath' is required for building ServiceDescription.");
            }
            if (this.deployment == null) {
                throw new IllegalStateException("Field 'deployment' is required for building ServiceDescription.");
            }
            return new OpenLService(this, initializer);
        }
    }
}

