/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.common.ProjectException;
import org.openl.rules.project.IRulesDeploySerializer;
import org.openl.rules.project.abstraction.IDeployment;
import org.openl.rules.project.abstraction.IProject;
import org.openl.rules.project.abstraction.IProjectArtefact;
import org.openl.rules.project.abstraction.IProjectResource;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.project.xml.XmlRulesDeploySerializer;
import org.openl.rules.ruleservice.conf.DeploymentNameMatcher;
import org.openl.rules.ruleservice.conf.ResourceLoaderImpl;
import org.openl.rules.ruleservice.conf.ServiceConfigurer;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LastVersionProjectsServiceConfigurer
implements ServiceConfigurer,
InitializingBean {
    public static final String RULES_DEPLOY_XML = "rules-deploy.xml";
    private final Logger log = LoggerFactory.getLogger(LastVersionProjectsServiceConfigurer.class);
    private IRulesDeploySerializer rulesDeploySerializer;
    private boolean provideRuntimeContext = false;
    private boolean supportVariations = false;
    private String supportedGroups = null;
    private DeploymentNameMatcher deploymentMatcher = DeploymentNameMatcher.DEFAULT;
    private Collection<String> defaultPublishers = Collections.emptyList();
    private Collection<RuleServicePublisher> supportedPublishers;

    @Override
    public final Collection<ServiceDescription> getServicesToBeDeployed(RuleServiceLoader ruleServiceLoader) {
        this.log.debug("Calculate services to be deployed...");
        Collection<IDeployment> deployments = ruleServiceLoader.getDeployments();
        HashSet<ServiceDescription> serviceDescriptions = new HashSet<ServiceDescription>();
        for (IDeployment deployment : deployments) {
            if (!this.deploymentMatcher.hasMatches(deployment.getDeploymentName())) continue;
            String deploymentName = deployment.getDeploymentName();
            CommonVersion deploymentVersion = deployment.getCommonVersion();
            DeploymentDescription deploymentDescription = new DeploymentDescription(deploymentName, deploymentVersion);
            for (IProject project : deployment.getProjects()) {
                if (project.isDeleted()) continue;
                String projectName = project.getName();
                try {
                    RulesDeploy rulesDeploy;
                    ServiceDescription.ServiceDescriptionBuilder serviceDescriptionBuilder;
                    block22: {
                        ProjectDescriptor pd = ruleServiceLoader.resolveProject(deploymentName, deploymentVersion, projectName);
                        if (pd == null) continue;
                        List modulesOfProject = pd.getModules();
                        serviceDescriptionBuilder = new ServiceDescription.ServiceDescriptionBuilder().setProvideRuntimeContext(this.isProvideRuntimeContext()).setProvideVariations(this.isSupportVariations()).setPublishers(this.defaultPublishers).setDeployment(deploymentDescription);
                        serviceDescriptionBuilder.setModules(modulesOfProject);
                        ResourceLoaderImpl resourceLoader = new ResourceLoaderImpl(project);
                        serviceDescriptionBuilder.setResourceLoader(resourceLoader);
                        rulesDeploy = null;
                        try {
                            IProjectArtefact artifact = project.getArtefact(RULES_DEPLOY_XML);
                            if (!(artifact instanceof IProjectResource)) break block22;
                            IProjectResource resource = (IProjectResource)artifact;
                            try (InputStream content = resource.getContent();){
                                rulesDeploy = this.getRulesDeploySerializer().deserialize(content);
                                serviceDescriptionBuilder.setRulesDeploy(rulesDeploy);
                                if (rulesDeploy.getServiceClass() != null && !rulesDeploy.getServiceClass().trim().isEmpty()) {
                                    serviceDescriptionBuilder.setServiceClassName(rulesDeploy.getServiceClass().trim());
                                }
                                if (rulesDeploy.getRmiServiceClass() != null && !rulesDeploy.getRmiServiceClass().trim().isEmpty()) {
                                    serviceDescriptionBuilder.setRmiServiceClassName(rulesDeploy.getRmiServiceClass().trim());
                                }
                                if (rulesDeploy.isProvideRuntimeContext() != null) {
                                    serviceDescriptionBuilder.setProvideRuntimeContext(rulesDeploy.isProvideRuntimeContext());
                                }
                                if (rulesDeploy.isProvideVariations() != null) {
                                    serviceDescriptionBuilder.setProvideVariations(rulesDeploy.isProvideVariations());
                                }
                                if (rulesDeploy.getPublishers() != null) {
                                    Set<String> publishers = Arrays.stream(rulesDeploy.getPublishers()).map(Enum::toString).collect(Collectors.toSet());
                                    serviceDescriptionBuilder.setPublishers(publishers);
                                }
                                if (rulesDeploy.getConfiguration() != null) {
                                    serviceDescriptionBuilder.setConfiguration(rulesDeploy.getConfiguration());
                                }
                                if (rulesDeploy.getInterceptingTemplateClassName() != null && !rulesDeploy.getInterceptingTemplateClassName().trim().isEmpty()) {
                                    serviceDescriptionBuilder.setAnnotationTemplateClassName(rulesDeploy.getInterceptingTemplateClassName().trim());
                                }
                                if (rulesDeploy.getRmiName() != null && !rulesDeploy.getRmiName().trim().isEmpty()) {
                                    serviceDescriptionBuilder.setRmiName(rulesDeploy.getRmiName());
                                }
                                if (rulesDeploy.getAnnotationTemplateClassName() != null && !rulesDeploy.getAnnotationTemplateClassName().trim().isEmpty()) {
                                    serviceDescriptionBuilder.setAnnotationTemplateClassName(rulesDeploy.getAnnotationTemplateClassName().trim());
                                }
                            }
                        }
                        catch (ProjectException artifact) {
                            // empty catch block
                        }
                    }
                    serviceDescriptionBuilder.setManifest(this.readManifestFile(project));
                    serviceDescriptionBuilder.setName(this.buildServiceName(deployment, projectName, rulesDeploy));
                    serviceDescriptionBuilder.setUrl(this.buildServiceUrl(deployment, projectName, rulesDeploy));
                    serviceDescriptionBuilder.setServicePath(ruleServiceLoader.getLogicalProjectFolder(project.getFolderPath()));
                    ServiceDescription serviceDescription = serviceDescriptionBuilder.build();
                    if (!serviceDescriptions.contains(serviceDescription) && this.serviceGroupSupported(rulesDeploy)) {
                        serviceDescriptions.add(serviceDescription);
                        continue;
                    }
                    if (!serviceDescriptions.contains(serviceDescription)) continue;
                    this.log.error("Service '{}' already exists in the deployment list.", (Object)serviceDescription.getDeployPath());
                }
                catch (Exception e) {
                    this.log.error("Failed to load a project from the repository. Project '{}' in deployment '{}' has been skipped.", new Object[]{projectName, deploymentName, e});
                }
            }
        }
        return serviceDescriptions;
    }

    private Manifest readManifestFile(IProject project) {
        block8: {
            Manifest manifest;
            block9: {
                IProjectArtefact artifact = project.getArtefact("META-INF/MANIFEST.MF");
                if (!(artifact instanceof IProjectResource)) break block8;
                InputStream content = ((IProjectResource)artifact).getContent();
                try {
                    manifest = new Manifest(content);
                    if (content == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (content != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ProjectException throwable3) {
                        // empty catch block
                    }
                }
                content.close();
            }
            return manifest;
        }
        return null;
    }

    private Set<String> getSupportedGroupsSet() {
        if (this.getSupportedGroups() != null && !this.getSupportedGroups().trim().isEmpty()) {
            String[] groups = this.getSupportedGroups().split(",");
            HashSet<String> supportedGroupSet = new HashSet<String>();
            for (String group : groups) {
                supportedGroupSet.add(group.trim());
            }
            return supportedGroupSet;
        }
        return Collections.emptySet();
    }

    private boolean serviceGroupSupported(RulesDeploy rulesDeploy) {
        Set<String> supportedGroupSet = this.getSupportedGroupsSet();
        if (!supportedGroupSet.isEmpty()) {
            String[] groups;
            if (rulesDeploy == null || rulesDeploy.getGroups() == null || rulesDeploy.getGroups().trim().isEmpty()) {
                return false;
            }
            for (String group : groups = rulesDeploy.getGroups().split(",")) {
                if (!supportedGroupSet.contains(group)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String buildServiceName(IDeployment deployment, String projectName, RulesDeploy rulesDeploy) {
        if (rulesDeploy != null) {
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getServiceName())) {
                if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                    return rulesDeploy.getServiceName() + "(version=" + rulesDeploy.getVersion() + ")";
                }
                return rulesDeploy.getServiceName();
            }
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                return deployment.getDeploymentName() + "_" + projectName + "(version=" + rulesDeploy.getVersion() + ")";
            }
        }
        return deployment.getDeploymentName() + "_" + projectName;
    }

    private String buildServiceUrl(IDeployment deployment, String projectName, RulesDeploy rulesDeploy) {
        if (rulesDeploy != null) {
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getUrl())) {
                if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                    if (rulesDeploy.getUrl().startsWith("/")) {
                        return "/" + rulesDeploy.getVersion() + rulesDeploy.getUrl();
                    }
                    return "/" + rulesDeploy.getVersion() + "/" + rulesDeploy.getUrl();
                }
                return rulesDeploy.getUrl();
            }
            if (StringUtils.isNotEmpty((CharSequence)rulesDeploy.getVersion())) {
                return "/" + rulesDeploy.getVersion() + "/" + deployment.getDeploymentName() + "/" + projectName;
            }
        }
        return deployment.getDeploymentName() + "/" + projectName;
    }

    public final IRulesDeploySerializer getRulesDeploySerializer() {
        if (this.rulesDeploySerializer == null) {
            this.rulesDeploySerializer = new XmlRulesDeploySerializer();
        }
        return this.rulesDeploySerializer;
    }

    public final void setRulesDeploySerializer(IRulesDeploySerializer rulesDeploySerializer) {
        this.rulesDeploySerializer = Objects.requireNonNull(rulesDeploySerializer, "rulesDeploySerializer cannot be null");
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public void setProvideRuntimeContext(boolean provideRuntimeContext) {
        this.provideRuntimeContext = provideRuntimeContext;
    }

    public boolean isSupportVariations() {
        return this.supportVariations;
    }

    public void setSupportVariations(boolean supportVariations) {
        this.supportVariations = supportVariations;
    }

    public void setSupportedGroups(String supportedGroups) {
        this.supportedGroups = supportedGroups;
    }

    public String getSupportedGroups() {
        return this.supportedGroups;
    }

    public void setDatasourceDeploymentPatterns(String deploymentPatterns) {
        this.deploymentMatcher = new DeploymentNameMatcher(deploymentPatterns);
    }

    public void setDefaultPublishers(String[] defaultPublishers) {
        if (defaultPublishers != null) {
            this.defaultPublishers = new HashSet<String>();
            Collections.addAll(this.defaultPublishers, defaultPublishers);
        } else {
            this.defaultPublishers = Collections.emptyList();
        }
    }

    @Autowired
    public void setSupportedPublishers(Collection<RuleServicePublisher> supportedPublishers) {
        this.supportedPublishers = supportedPublishers;
    }

    public void afterPropertiesSet() throws Exception {
        for (String defPublisher : this.defaultPublishers) {
            Optional<RuleServicePublisher> publisher = this.supportedPublishers.stream().filter(n -> n.name().equalsIgnoreCase(defPublisher)).findAny();
            if (!publisher.isEmpty()) continue;
            throw new BeanInitializationException(String.format("Default publisher with id '%s' is not found in the map of supported publishers.", defPublisher));
        }
    }
}

