/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.conf;

import java.util.regex.Pattern;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeploymentNameMatcher {
    private final Logger log = LoggerFactory.getLogger(DeploymentNameMatcher.class);
    private static final Pattern WILDCARD_REDUNDANT_OCCUR = Pattern.compile("\\*{2,}");
    public static final DeploymentNameMatcher DEFAULT = new DeploymentNameMatcher();
    private final Pattern pattern;

    public DeploymentNameMatcher() {
        this(null);
    }

    public DeploymentNameMatcher(String source) {
        this.pattern = source == null ? null : this.compilePattern(source);
    }

    private Pattern compilePattern(String source) {
        String[] patterns = source.split(",");
        Character delimiter = null;
        StringBuilder regex = new StringBuilder();
        for (String pattern : patterns) {
            if (this.isBlankPattern(pattern)) continue;
            if (WILDCARD_REDUNDANT_OCCUR.matcher(pattern).find()) {
                this.log.warn("Rule name pattern '{}' cannot have more than one wildcard letter in a row", (Object)pattern);
                continue;
            }
            if (delimiter != null) {
                regex.append(delimiter);
            } else {
                delimiter = Character.valueOf('|');
            }
            regex.append("(\\Q").append(pattern.trim()).append("\\E)");
        }
        return regex.length() > 0 ? Pattern.compile(regex.toString().replace("*", "\\E.*\\Q")) : null;
    }

    private boolean isBlankPattern(String pattern) {
        return StringUtils.isBlank((CharSequence)pattern) || "*".equals(pattern);
    }

    public boolean hasMatches(String deploymentName) {
        if (this.pattern == null) {
            return true;
        }
        return this.pattern.matcher(deploymentName).matches();
    }
}

