/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.openl.binding.MethodUtil;
import org.openl.rules.ruleservice.core.ExceptionType;
import org.openl.rules.ruleservice.core.RuleServiceWrapperException;
import org.openl.rules.ruleservice.simple.RulesFrontend;
import org.openl.runtime.ASMProxyFactory;
import org.openl.spring.env.PropertySourcesLoader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class OpenLService {
    static volatile RulesFrontend rulesFrontend;
    private static ClassPathXmlApplicationContext context;

    public static Object call(String serviceName, String ruleName, Object ... params) throws Exception {
        if (params == null) {
            params = new Object[]{};
        }
        Class[] types = (Class[])Arrays.stream(params).map(x -> x != null ? x.getClass() : null).toArray(Class[]::new);
        return OpenLService.execute(serviceName, ruleName, types, params);
    }

    public static String callJSON(String serviceName, String ruleName, String json) throws Exception {
        Invoker invoker = OpenLService.getInvoker(serviceName, ruleName, json);
        Object result = invoker.invoke();
        return result == null || result instanceof String ? (String)result : invoker.mapper.writeValueAsString(result);
    }

    public static String tryJSON(String serviceName, String ruleName, String json) {
        try {
            Invoker invoker = OpenLService.getInvoker(serviceName, ruleName, json);
            try {
                Object result = invoker.invoke();
                ObjectNode x = invoker.mapper.createObjectNode();
                x.putPOJO("result", result);
                x.putNull("error");
                return invoker.mapper.writeValueAsString((Object)x);
            }
            catch (Exception ex) {
                return OpenLService.errorJSON(invoker.mapper, ex);
            }
        }
        catch (Exception ex) {
            return OpenLService.errorJSON(null, ex);
        }
    }

    private static Invoker getInvoker(String serviceName, String ruleName, String json) throws Exception {
        org.openl.rules.ruleservice.core.OpenLService service = OpenLService.getService(serviceName);
        if (service == null) {
            throw new IllegalArgumentException(String.format("Service '%s' is not found.", serviceName));
        }
        Object instance = service.getServiceBean();
        ArrayList<Method> methods = new ArrayList<Method>(2);
        for (Method method : instance.getClass().getMethods()) {
            if (!method.getName().equals(ruleName)) continue;
            methods.add(method);
        }
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Method '%s' is not found in service '%s'.", ruleName, serviceName));
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Non-unique '%s' method name in service '%s'. There are %d methods with the same name.", ruleName, serviceName, methods.size()));
        }
        Method caller = (Method)methods.get(0);
        Object[] args = new Object[caller.getParameterCount()];
        ObjectMapper mapper = (ObjectMapper)service.getServiceContext().getBean("serviceObjectMapper", ObjectMapper.class);
        if (json != null) {
            if (caller.getParameterCount() == 1) {
                Class<String> type = caller.getParameterTypes()[0];
                args[0] = type.isAssignableFrom(String.class) ? json : mapper.readValue(json, type);
            } else {
                JsonNode tree = mapper.readTree(json);
                for (int i = 0; i < caller.getParameterCount(); ++i) {
                    Parameter parameter = caller.getParameters()[i];
                    String name = parameter.getName();
                    Class<?> type = parameter.getType();
                    JsonNode node = tree.get(name);
                    args[i] = mapper.treeToValue((TreeNode)node, type);
                }
            }
        }
        return new Invoker(instance, caller, args, mapper);
    }

    private static String errorJSON(ObjectMapper mapper, Throwable ex) {
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        String message = ex.getMessage();
        ExceptionType type = ex instanceof JsonParseException ? ExceptionType.BAD_REQUEST : ExceptionType.SYSTEM;
        LinkedHashMap<String, String> body = null;
        if (ex instanceof RuleServiceWrapperException) {
            RuleServiceWrapperException e = (RuleServiceWrapperException)ex;
            type = e.getType();
            body = e.getBody();
        }
        if (body == null) {
            LinkedHashMap<String, String> b = new LinkedHashMap<String, String>();
            b.put("message", message);
            b.put("type", type.name());
            body = b;
        }
        if (mapper != null) {
            try {
                ObjectNode x = mapper.createObjectNode();
                x.putNull("result");
                x.putPOJO("error", (Object)body);
                return mapper.writeValueAsString((Object)x);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "{\"result\":null,\"error\":{\"message\":\"" + message.replace("\\", "\\\\").replace("\"", "\\\"") + "\",\"type\":\"" + type + "\"}}";
    }

    public static String callJSONArgs(String serviceName, String ruleName, String ... json) throws Exception {
        org.openl.rules.ruleservice.core.OpenLService service = OpenLService.getService(serviceName);
        if (service == null) {
            throw new IllegalArgumentException(String.format("Service '%s' is not found.", serviceName));
        }
        Object instance = service.getServiceBean();
        int argsCount = json == null ? 0 : json.length;
        ArrayList<Method> methods = new ArrayList<Method>(2);
        for (Method method : instance.getClass().getMethods()) {
            if (!method.getName().equals(ruleName) || method.getParameterCount() != argsCount) continue;
            methods.add(method);
        }
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Method '%s' with %d input arguments is not found in service '%s'.", ruleName, argsCount, serviceName));
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Non-unique '%s' method name with %d input arguments in service '%s'. There are %d methods with the same name and count of arguments.", ruleName, argsCount, serviceName, methods.size()));
        }
        Method caller = (Method)methods.get(0);
        Object[] args = new Object[argsCount];
        ObjectMapper mapper = (ObjectMapper)service.getServiceContext().getBean("serviceObjectMapper", ObjectMapper.class);
        for (int i = 0; i < argsCount; ++i) {
            Class<?> type = caller.getParameterTypes()[i];
            args[i] = json[i] == null || String.class.isAssignableFrom(type) ? json[i] : mapper.readValue(json[i], type);
        }
        Object result = caller.invoke(instance, args);
        return result == null || result instanceof String ? (String)result : mapper.writeValueAsString(result);
    }

    public static <T> T proxy(String serviceName, Class<T> proxyInterface) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return (T)ASMProxyFactory.newProxyInstance((ClassLoader)cl, (method, args) -> OpenLService.execute(serviceName, method.getName(), method.getParameterTypes(), args), proxyInterface);
    }

    public static <T> T get(String serviceName) throws Exception {
        org.openl.rules.ruleservice.core.OpenLService service = OpenLService.getService(serviceName);
        return (T)(service != null ? service.getServiceBean() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static org.openl.rules.ruleservice.core.OpenLService getService(String serviceName) {
        if (rulesFrontend != null) return rulesFrontend.findServiceByName(serviceName);
        Class<OpenLService> clazz = OpenLService.class;
        synchronized (OpenLService.class) {
            if (rulesFrontend != null) return rulesFrontend.findServiceByName(serviceName);
            ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext();
            springContext.setConfigLocations(new String[]{"classpath:openl-ruleservice-beans.xml"});
            new PropertySourcesLoader().initialize((ConfigurableApplicationContext)springContext);
            springContext.refresh();
            context = springContext;
            rulesFrontend = (RulesFrontend)springContext.getBean(RulesFrontend.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rulesFrontend.findServiceByName(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reset() {
        if (rulesFrontend == null) return;
        Class<OpenLService> clazz = OpenLService.class;
        synchronized (OpenLService.class) {
            if (rulesFrontend == null) return;
            context.close();
            context = null;
            rulesFrontend = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Object execute(String serviceName, String ruleName, Class<?>[] inputParamsTypes, Object[] params) throws Exception {
        Object instance = OpenLService.get(serviceName);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Service '%s' is not found.", serviceName));
        }
        Method method = MethodUtil.getMatchingAccessibleMethod(instance.getClass(), (String)ruleName, (Class[])inputParamsTypes);
        if (method == null) {
            String types = Arrays.stream(inputParamsTypes).map(x -> x == null ? "null-class" : x.getTypeName()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Method '%s(%s)' is not found in service '%s'.", ruleName, types, serviceName));
        }
        return method.invoke(instance, params);
    }

    private static class Invoker {
        public final Object instance;
        public final Method caller;
        public final Object[] args;
        public final ObjectMapper mapper;

        public Invoker(Object instance, Method caller, Object[] args, ObjectMapper mapper) {
            this.instance = instance;
            this.caller = caller;
            this.args = args;
            this.mapper = mapper;
        }

        Object invoke() throws Exception {
            return this.caller.invoke(this.instance, this.args);
        }
    }
}

