/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openl.rules.ruleservice.rmi.DefaultRmiHandler;

class DefaultRmiMethodHandler
implements DefaultRmiHandler {
    private final Object target;
    private final Map<String, List<Method>> methodMap;

    DefaultRmiMethodHandler(Object target, Map<String, List<Method>> methodMap) {
        this.target = Objects.requireNonNull(target, "target cannot be null");
        this.methodMap = Objects.requireNonNull(methodMap, "methodMap cannot be null");
    }

    public Object execute(String ruleName, Class<?>[] inputParamsTypes, Object[] params) {
        if (inputParamsTypes.length != params.length) {
            throw new IllegalArgumentException("inputParamTypes size must be equals to params size.");
        }
        return this.invoke(ruleName, inputParamsTypes, params, true);
    }

    public Object execute(String ruleName, Object ... params) {
        Class[] inputParamsTypes = new Class[params.length];
        int i = 0;
        for (Object o : params) {
            inputParamsTypes[i] = o.getClass();
            ++i;
        }
        return this.invoke(ruleName, inputParamsTypes, params, false);
    }

    private Object invoke(String ruleName, Class<?>[] inputParamsTypes, Object[] params, boolean strictMatch) {
        List<Method> methods = this.methodMap.get(ruleName);
        if (methods == null) {
            throw new IllegalArgumentException("Method with requested ruleName is not found.");
        }
        int match = 0;
        Method matchedMethod = null;
        for (Method m : methods) {
            int i = 0;
            boolean f = true;
            for (Class<?> inputParamsType : inputParamsTypes) {
                if (strictMatch && !m.getParameterTypes()[i].equals(inputParamsType)) {
                    f = false;
                    break;
                }
                if (!strictMatch && !m.getParameterTypes()[i].isAssignableFrom(inputParamsType)) {
                    f = false;
                    break;
                }
                ++i;
            }
            if (!f) continue;
            ++match;
            matchedMethod = m;
        }
        if (match == 1) {
            try {
                return matchedMethod.invoke(this.target, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (match > 1) {
            throw new IllegalArgumentException("More than one method is found with requested ruleName and parameters.");
        }
        throw new IllegalArgumentException("Method with requested ruleName and parameters is not found.");
    }
}

